/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zeitauswahl im 1-Stunden Raster bis zu 1 Tag.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttStundenIntervall01Bis24h extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_1__1_STUNDE = new AttStundenIntervall01Bis24h("1 Stunde", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_2__2_STUNDEN = new AttStundenIntervall01Bis24h("2 Stunden", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_3__3_STUNDEN = new AttStundenIntervall01Bis24h("3 Stunden", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_4__4_STUNDEN = new AttStundenIntervall01Bis24h("4 Stunden", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_5__5_STUNDEN = new AttStundenIntervall01Bis24h("5 Stunden", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_6__6_STUNDEN = new AttStundenIntervall01Bis24h("6 Stunden", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_7__7_STUNDEN = new AttStundenIntervall01Bis24h("7 Stunden", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_8__8_STUNDEN = new AttStundenIntervall01Bis24h("8 Stunden", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_9__9_STUNDEN = new AttStundenIntervall01Bis24h("9 Stunden", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_10__10_STUNDEN = new AttStundenIntervall01Bis24h("10 Stunden", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_11__11_STUNDEN = new AttStundenIntervall01Bis24h("11 Stunden", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_12__12_STUNDEN = new AttStundenIntervall01Bis24h("12 Stunden", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_13__13_STUNDEN = new AttStundenIntervall01Bis24h("13 Stunden", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_14__14_STUNDEN = new AttStundenIntervall01Bis24h("14 Stunden", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_15__15_STUNDEN = new AttStundenIntervall01Bis24h("15 Stunden", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_16__16_STUNDEN = new AttStundenIntervall01Bis24h("16 Stunden", 		Byte
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_17__17_STUNDEN = new AttStundenIntervall01Bis24h("17 Stunden", 		Byte
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_18__18_STUNDEN = new AttStundenIntervall01Bis24h("18 Stunden", 		Byte
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_19__19_STUNDEN = new AttStundenIntervall01Bis24h("19 Stunden", 		Byte
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_20__20_STUNDEN = new AttStundenIntervall01Bis24h("20 Stunden", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_21__21_STUNDEN = new AttStundenIntervall01Bis24h("21 Stunden", 		Byte
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_22__22_STUNDEN = new AttStundenIntervall01Bis24h("22 Stunden", 		Byte
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_23__23_STUNDEN = new AttStundenIntervall01Bis24h("23 Stunden", 		Byte
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervall01Bis24h ZUSTAND_24__1_TAG = new AttStundenIntervall01Bis24h("1 Tag", 		Byte
	.valueOf("24"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStundenIntervall01Bis24h getZustand(final 		Byte
	 value) {
		for (AttStundenIntervall01Bis24h e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStundenIntervall01Bis24h getZustand(final String value) {
		for (AttStundenIntervall01Bis24h e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStundenIntervall01Bis24h> getZustaende() {
		List<AttStundenIntervall01Bis24h> list = new ArrayList<AttStundenIntervall01Bis24h>();
		list.add(ZUSTAND_1__1_STUNDE);
		list.add(ZUSTAND_2__2_STUNDEN);
		list.add(ZUSTAND_3__3_STUNDEN);
		list.add(ZUSTAND_4__4_STUNDEN);
		list.add(ZUSTAND_5__5_STUNDEN);
		list.add(ZUSTAND_6__6_STUNDEN);
		list.add(ZUSTAND_7__7_STUNDEN);
		list.add(ZUSTAND_8__8_STUNDEN);
		list.add(ZUSTAND_9__9_STUNDEN);
		list.add(ZUSTAND_10__10_STUNDEN);
		list.add(ZUSTAND_11__11_STUNDEN);
		list.add(ZUSTAND_12__12_STUNDEN);
		list.add(ZUSTAND_13__13_STUNDEN);
		list.add(ZUSTAND_14__14_STUNDEN);
		list.add(ZUSTAND_15__15_STUNDEN);
		list.add(ZUSTAND_16__16_STUNDEN);
		list.add(ZUSTAND_17__17_STUNDEN);
		list.add(ZUSTAND_18__18_STUNDEN);
		list.add(ZUSTAND_19__19_STUNDEN);
		list.add(ZUSTAND_20__20_STUNDEN);
		list.add(ZUSTAND_21__21_STUNDEN);
		list.add(ZUSTAND_22__22_STUNDEN);
		list.add(ZUSTAND_23__23_STUNDEN);
		list.add(ZUSTAND_24__1_TAG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StundenIntervall01Bis24h.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStundenIntervall01Bis24h(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStundenIntervall01Bis24h(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
