/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.ilse.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attribut zum Speichern eines Logbucheintrages.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttAktionLogbuch extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_0_EINLOGGEN = new AttAktionLogbuch("Einloggen", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_1_AUSLOGGEN = new AttAktionLogbuch("Ausloggen", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_2_RESET = new AttAktionLogbuch("Reset", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_3_ARCHIVANFRAGE = new AttAktionLogbuch("Archivanfrage", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_4_AKTUELLE_DATEN = new AttAktionLogbuch("Aktuelle Daten", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_5_UNBEFUGTER_RESETVERSUCH = new AttAktionLogbuch("Unbefugter Resetversuch", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_6_UEBERWACHUNGSPUNKT_HINZUFUEGEN = new AttAktionLogbuch("Überwachungspunkt hinzufügen", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_7_UEBERWACHUNGSPUNKT_ENTFERNEN = new AttAktionLogbuch("Überwachungspunkt entfernen", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_8_UEBERWACHUNGSPUNKT_UEBERWACHEN = new AttAktionLogbuch("Überwachungspunkt überwachen", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAktionLogbuch ZUSTAND_9_UEBERWACHUNGSPUNKT_NICHT_UEBERWACHEN = new AttAktionLogbuch("Überwachungspunkt nicht überwachen", 		Byte
	.valueOf("9"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttAktionLogbuch getZustand(final 		Byte
	 value) {
		for (AttAktionLogbuch e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttAktionLogbuch getZustand(final String value) {
		for (AttAktionLogbuch e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttAktionLogbuch> getZustaende() {
		List<AttAktionLogbuch> list = new ArrayList<AttAktionLogbuch>();
		list.add(ZUSTAND_0_EINLOGGEN);
		list.add(ZUSTAND_1_AUSLOGGEN);
		list.add(ZUSTAND_2_RESET);
		list.add(ZUSTAND_3_ARCHIVANFRAGE);
		list.add(ZUSTAND_4_AKTUELLE_DATEN);
		list.add(ZUSTAND_5_UNBEFUGTER_RESETVERSUCH);
		list.add(ZUSTAND_6_UEBERWACHUNGSPUNKT_HINZUFUEGEN);
		list.add(ZUSTAND_7_UEBERWACHUNGSPUNKT_ENTFERNEN);
		list.add(ZUSTAND_8_UEBERWACHUNGSPUNKT_UEBERWACHEN);
		list.add(ZUSTAND_9_UEBERWACHUNGSPUNKT_NICHT_UEBERWACHEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut AktionLogbuch.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttAktionLogbuch(final 		Byte
	 value) {
		super(value);
	}
	
	private AttAktionLogbuch(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
