/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter der BitCtrl Streckenstations-Ueberwachung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdLveStatusUeberwachungsParameter extends AbstractParameterDatensatz<PdLveStatusUeberwachungsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttMinutenOffset
				 _berechnungsOffsetInMinuten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttStundenOffset
				 _zeitFensterInStunden
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
				 _maxNullInFolgeBAB
				= new de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
				 _maxNullInFolgeRest
				= new de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				 _nKfz
				= new de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				 _krad
				= new de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				 _pkwA
				= new de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _schleifenFehlerUeberwachen
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Minutenoffset zu einer Stunde.
			<p>
			
			</p>
			
			@return der Wert von BerechnungsOffsetInMinuten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttMinutenOffset
				 getBerechnungsOffsetInMinuten() {
				return _berechnungsOffsetInMinuten;
			}
		
			/**
			Minutenoffset zu einer Stunde.
			<p>
			
			</p>
			
			@param _berechnungsOffsetInMinuten der neue Wert von BerechnungsOffsetInMinuten.
			*/
			public void setBerechnungsOffsetInMinuten(de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttMinutenOffset
			 _berechnungsOffsetInMinuten) {
				this._berechnungsOffsetInMinuten = _berechnungsOffsetInMinuten;
			}
		
			/**
			Stundenoffset zu einem Tag.
			<p>
			
			</p>
			
			@return der Wert von ZeitFensterInStunden.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttStundenOffset
				 getZeitFensterInStunden() {
				return _zeitFensterInStunden;
			}
		
			/**
			Stundenoffset zu einem Tag.
			<p>
			
			</p>
			
			@param _zeitFensterInStunden der neue Wert von ZeitFensterInStunden.
			*/
			public void setZeitFensterInStunden(de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttStundenOffset
			 _zeitFensterInStunden) {
				this._zeitFensterInStunden = _zeitFensterInStunden;
			}
		
			/**
			Enthaelt die Informationen, ob die letzten X
								Stunden
								daraufhin ueberprueft werden soll, ob durchgaengig keine
								Fahrzeuge
								gefahren sind.
			<p>
			
			</p>
			
			@return der Wert von MaxNullInFolgeBAB.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
				 getMaxNullInFolgeBAB() {
				return _maxNullInFolgeBAB;
			}
		
			/**
			Enthaelt die Informationen, ob die letzten X
								Stunden
								daraufhin ueberprueft werden soll, ob durchgaengig keine
								Fahrzeuge
								gefahren sind.
			<p>
			
			</p>
			
			@param _maxNullInFolgeBAB der neue Wert von MaxNullInFolgeBAB.
			*/
			public void setMaxNullInFolgeBAB(de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
			 _maxNullInFolgeBAB) {
				this._maxNullInFolgeBAB = _maxNullInFolgeBAB;
			}
		
			/**
			Enthaelt die Informationen, ob die letzten X
								Stunden
								daraufhin ueberprueft werden soll, ob durchgaengig keine
								Fahrzeuge
								gefahren sind.
			<p>
			
			</p>
			
			@return der Wert von MaxNullInFolgeRest.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
				 getMaxNullInFolgeRest() {
				return _maxNullInFolgeRest;
			}
		
			/**
			Enthaelt die Informationen, ob die letzten X
								Stunden
								daraufhin ueberprueft werden soll, ob durchgaengig keine
								Fahrzeuge
								gefahren sind.
			<p>
			
			</p>
			
			@param _maxNullInFolgeRest der neue Wert von MaxNullInFolgeRest.
			*/
			public void setMaxNullInFolgeRest(de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlNullDatensaetzeUeberpruefung
			 _maxNullInFolgeRest) {
				this._maxNullInFolgeRest = _maxNullInFolgeRest;
			}
		
			/**
			Enthaelt die Informationen, ob der Anteil einer bestimmten
								Fahrzeugart pro DE ueberwacht werden, und bei Ueberschreitung
								welchen Prozentsatzes dann eine Warnung erzeugt werden soll.
			<p>
			
			</p>
			
			@return der Wert von NKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				 getNKfz() {
				return _nKfz;
			}
		
			/**
			Enthaelt die Informationen, ob der Anteil einer bestimmten
								Fahrzeugart pro DE ueberwacht werden, und bei Ueberschreitung
								welchen Prozentsatzes dann eine Warnung erzeugt werden soll.
			<p>
			
			</p>
			
			@param _nKfz der neue Wert von NKfz.
			*/
			public void setNKfz(de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
			 _nKfz) {
				this._nKfz = _nKfz;
			}
		
			/**
			Enthaelt die Informationen, ob der Anteil einer bestimmten
								Fahrzeugart pro DE ueberwacht werden, und bei Ueberschreitung
								welchen Prozentsatzes dann eine Warnung erzeugt werden soll.
			<p>
			
			</p>
			
			@return der Wert von Krad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				 getKrad() {
				return _krad;
			}
		
			/**
			Enthaelt die Informationen, ob der Anteil einer bestimmten
								Fahrzeugart pro DE ueberwacht werden, und bei Ueberschreitung
								welchen Prozentsatzes dann eine Warnung erzeugt werden soll.
			<p>
			
			</p>
			
			@param _krad der neue Wert von Krad.
			*/
			public void setKrad(de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
			 _krad) {
				this._krad = _krad;
			}
		
			/**
			Enthaelt die Informationen, ob der Anteil einer bestimmten
								Fahrzeugart pro DE ueberwacht werden, und bei Ueberschreitung
								welchen Prozentsatzes dann eine Warnung erzeugt werden soll.
			<p>
			
			</p>
			
			@return der Wert von PkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
				 getPkwA() {
				return _pkwA;
			}
		
			/**
			Enthaelt die Informationen, ob der Anteil einer bestimmten
								Fahrzeugart pro DE ueberwacht werden, und bei Ueberschreitung
								welchen Prozentsatzes dann eine Warnung erzeugt werden soll.
			<p>
			
			</p>
			
			@param _pkwA der neue Wert von PkwA.
			*/
			public void setPkwA(de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AtlFahrzeugAnteilUeberpruefung
			 _pkwA) {
				this._pkwA = _pkwA;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von SchleifenFehlerUeberwachen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSchleifenFehlerUeberwachen() {
				return _schleifenFehlerUeberwachen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _schleifenFehlerUeberwachen der neue Wert von SchleifenFehlerUeberwachen.
			*/
			public void setSchleifenFehlerUeberwachen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _schleifenFehlerUeberwachen) {
				this._schleifenFehlerUeberwachen = _schleifenFehlerUeberwachen;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getBerechnungsOffsetInMinuten() != null) {
		                if (getBerechnungsOffsetInMinuten().isZustand()) {
		                    datum.getUnscaledValue("berechnungsOffsetInMinuten").setText(getBerechnungsOffsetInMinuten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("berechnungsOffsetInMinuten").set(getBerechnungsOffsetInMinuten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZeitFensterInStunden() != null) {
		                if (getZeitFensterInStunden().isZustand()) {
		                    datum.getUnscaledValue("zeitFensterInStunden").setText(getZeitFensterInStunden().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("zeitFensterInStunden").set(getZeitFensterInStunden().getValue());
		                }
					}
					// AttributListenDefinition
						getMaxNullInFolgeBAB().bean2Atl(datum.getItem("maxNullInFolgeBAB"), factory);
					// AttributListenDefinition
						getMaxNullInFolgeRest().bean2Atl(datum.getItem("maxNullInFolgeRest"), factory);
					// AttributListenDefinition
						getNKfz().bean2Atl(datum.getItem("nKfz"), factory);
					// AttributListenDefinition
						getKrad().bean2Atl(datum.getItem("Krad"), factory);
					// AttributListenDefinition
						getPkwA().bean2Atl(datum.getItem("PkwA"), factory);
					// GanzzahlAttributTyp
					if (getSchleifenFehlerUeberwachen() != null) {
		                if (getSchleifenFehlerUeberwachen().isZustand()) {
		                    datum.getUnscaledValue("schleifenFehlerUeberwachen").setText(getSchleifenFehlerUeberwachen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("schleifenFehlerUeberwachen").set(getSchleifenFehlerUeberwachen().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							setBerechnungsOffsetInMinuten(new de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttMinutenOffset
							(daten.
								getUnscaledValue
							("berechnungsOffsetInMinuten").
									byteValue
							()));
					// GanzzahlAttributTyp
							setZeitFensterInStunden(new de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute.AttStundenOffset
							(daten.
								getUnscaledValue
							("zeitFensterInStunden").
									byteValue
							()));
					// AttributListenDefinition
						getMaxNullInFolgeBAB().atl2Bean(daten.getItem("maxNullInFolgeBAB"), factory);
					// AttributListenDefinition
						getMaxNullInFolgeRest().atl2Bean(daten.getItem("maxNullInFolgeRest"), factory);
					// AttributListenDefinition
						getNKfz().atl2Bean(daten.getItem("nKfz"), factory);
					// AttributListenDefinition
						getKrad().atl2Bean(daten.getItem("Krad"), factory);
					// AttributListenDefinition
						getPkwA().atl2Bean(daten.getItem("PkwA"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("schleifenFehlerUeberwachen").isState()) {
								setSchleifenFehlerUeberwachen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("schleifenFehlerUeberwachen").getText()));
							} else {
							setSchleifenFehlerUeberwachen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("schleifenFehlerUeberwachen").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setBerechnungsOffsetInMinuten(getBerechnungsOffsetInMinuten());
							klon.setZeitFensterInStunden(getZeitFensterInStunden());
							klon._maxNullInFolgeBAB = getMaxNullInFolgeBAB().clone();
							klon._maxNullInFolgeRest = getMaxNullInFolgeRest().clone();
							klon._nKfz = getNKfz().clone();
							klon._krad = getKrad().clone();
							klon._pkwA = getPkwA().clone();
							klon.setSchleifenFehlerUeberwachen(getSchleifenFehlerUeberwachen());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.lveStatusUeberwachungsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdLveStatusUeberwachungsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
