/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste zur Definition eines Default-Parameterdatensatzes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlDefaultParameterdatensatz implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _typ
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributgruppe
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttSerialisiererVersion
			 _serialisierer
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> _datensatz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			>(0, true);
	
		/**
		Referenz auf den Typ der Objekte für die dieser Default-Parameterdatensatzes gelten soll.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getTyp() {
			return _typ;
		}
	
		/**
		Referenz auf den Typ der Objekte für die dieser Default-Parameterdatensatzes gelten soll.
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		Referenz auf die Attributgruppe des Default-Parameterdatensatzes.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppe.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAttributgruppe() {
			return _attributgruppe;
		}
	
		/**
		Referenz auf die Attributgruppe des Default-Parameterdatensatzes.
		<p>
		
		</p>
		
		@param _attributgruppe der neue Wert von Attributgruppe.
		*/
		public void setAttributgruppe(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _attributgruppe) {
			this._attributgruppe = _attributgruppe;
		}
	
		/**
		Version des Serialisierers der bei der Serialisierung eines Default-Parameterdatensatzes in das nachfolgende Byte-Array verwendet wurde.
		                        Als Serialisiererversion sollte anfangs die 3 verwendet werden. Später kann bei Bedarf eine neuere Version verwendet werden.
		<p>
		
		</p>
		
		@return der Wert von Serialisierer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttSerialisiererVersion
			 getSerialisierer() {
			return _serialisierer;
		}
	
		/**
		Version des Serialisierers der bei der Serialisierung eines Default-Parameterdatensatzes in das nachfolgende Byte-Array verwendet wurde.
		                        Als Serialisiererversion sollte anfangs die 3 verwendet werden. Später kann bei Bedarf eine neuere Version verwendet werden.
		<p>
		
		</p>
		
		@param _serialisierer der neue Wert von Serialisierer.
		*/
		public void setSerialisierer(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttSerialisiererVersion
		 _serialisierer) {
			this._serialisierer = _serialisierer;
		}
	
		/**
		Serialisierter Default-Parameterdatensatz.
		<p>
		&lt;absatz&gt;
		                            Dieses Attribut enthält ein Byte-Array in dem ein Default-Parameterdatensatz in serialisierter Form enthalten ist.
		                            Zum lesenden Zugriff auf den enthalten Datensatz ist mit Hilfe der Methode
		                            &lt;code&gt;SerializingFactory.createDeserializer(serializerVersion, inputStream)&lt;&#47;code&gt;
		                            ein Deserializer in der Version zu erzeugen, die im Attribut serialisierer eingetragen ist. Ein passender InputStream kann mit Hilfe
		                            der Klasse ByteArrayInputStream aus dem Byte-Array
		                            erzeugt werden. Der enthaltene Datensatz kann dann mit der Methode Deserializer.readData(AttributeGroup atg, ObjectLookup dataModel)
		                            in ein entsprechendes Data-Objekt konvertiert werden. Der zweite Parameter (dataModel) muss zwingend angegeben werden, damit
		                            Referenzen mit Referenzierungsart Assoziation richtig aufgelöst werden können.
		                        &lt;&#47;absatz&gt;
		                        &lt;absatz&gt;
		                            Der schreibende Zugriff kann analog mit einem entsprechenden Serializer durchgeführt werden. Als Serialisiererversion sollte anfangs
		                            die 3 verwendet werden. Später kann bei Bedarf eine neuere Version verwendet werden.
		                        &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Datensatz.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> getDatensatz() {
			return _datensatz;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soTyp = getTyp();
					final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
					datum.getReferenceValue("typ").setSystemObject(tmpTyp);
				// ObjektReferenzAttributTyp
					final Object soAttributgruppe = getAttributgruppe();
					final SystemObject tmpAttributgruppe;
						if (soAttributgruppe instanceof SystemObject) {
							tmpAttributgruppe = (SystemObject)soAttributgruppe;
						} else if(soAttributgruppe instanceof SystemObjekt){
							tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
						} else{
							tmpAttributgruppe = null;
						}
					datum.getReferenceValue("attributgruppe").setSystemObject(tmpAttributgruppe);
				// GanzzahlAttributTyp
				if (getSerialisierer() != null) {
	                if (getSerialisierer().isZustand()) {
	                    datum.getUnscaledValue("serialisierer").setText(getSerialisierer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("serialisierer").set(getSerialisierer().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDatensatz() != null) {
					final Data.NumberArray arrayDatensatz = datum.
						getUnscaledArray
						("datensatz");
					arrayDatensatz.setLength(getDatensatz().size());
					for (int i = 0; i < arrayDatensatz.getLength(); ++i) {
						arrayDatensatz.getValue(i).set(getDatensatz().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idTyp = daten.getReferenceValue("typ").getId();
					final SystemObjekt tmpTyp;
					if (idTyp == 0) {
						tmpTyp = null;
					} else {
						final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
						if (soTyp == null) {
								tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTyp);
						} else {
							tmpTyp = factory.getModellobjekt(soTyp);
						}
					}
					setTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpTyp);
				// ObjektReferenzAttributTyp
					final long idAttributgruppe = daten.getReferenceValue("attributgruppe").getId();
					final SystemObjekt tmpAttributgruppe;
					if (idAttributgruppe == 0) {
						tmpAttributgruppe = null;
					} else {
						final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
						if (soAttributgruppe == null) {
								tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
						} else {
							tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
						}
					}
					setAttributgruppe((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAttributgruppe);
				// GanzzahlAttributTyp
						setSerialisierer(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttSerialisiererVersion
						(daten.
							getUnscaledValue
						("serialisierer").
								intValue
						()));
				// GanzzahlAttributTyp
					final Data.NumberArray arrayDatensatz = daten.
						getUnscaledArray
					("datensatz");
	
					for (int i = 0; i < arrayDatensatz.getLength(); ++i) {
	                    getDatensatz().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
	                    (arrayDatensatz.
	                    		byteValue
	                    (i)));
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDefaultParameterdatensatz clone() {
		AtlDefaultParameterdatensatz klon = new AtlDefaultParameterdatensatz();
		
						klon.setTyp(getTyp());
						klon.setAttributgruppe(getAttributgruppe());
						klon.setSerialisierer(getSerialisierer());
					klon._datensatz = getDatensatz().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
