/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fasst die Attribute zusammen, die zu einer KonfigurationsÄnderung gehören.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlKonfigurationsAenderung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _stand
			;
			private String
			 _autor
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 _version
			;
			private String
			 _grund
			= new String
			()
			;
			private String
			 _text
			= new String
			()
			;
	
		/**
		Das Datum an dem die KonfigurationsÄnderung vorgenommen wurde.
		<p>
		
		</p>
		
		@return der Wert von Stand.
		*/
			public 	Zeitstempel
			 getStand() {
			return _stand;
		}
	
		/**
		Das Datum an dem die KonfigurationsÄnderung vorgenommen wurde.
		<p>
		
		</p>
		
		@param _stand der neue Wert von Stand.
		*/
		public void setStand(	Zeitstempel
		 _stand) {
			this._stand = _stand;
		}
	
		/**
		Der Name dessen, der die KonfigurationsÄnderung vorgenommen hat.
		<p>
		
		</p>
		
		@return der Wert von Autor.
		*/
			public String
			 getAutor() {
			return _autor;
		}
	
		/**
		Der Name dessen, der die KonfigurationsÄnderung vorgenommen hat.
		<p>
		
		</p>
		
		@param _autor der neue Wert von Autor.
		*/
		public void setAutor(String
		 _autor) {
			if (_autor.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._autor = _autor;
		}
	
		/**
		Versionsnummer des Konfigurationsbereichs, in der die Versorgungsdatei importiert wurde.
		<p>
		Die Versionsnummer wird vom Import gesetzt. Sie entspricht der Version des Konfigurationsbereichs, die sich beim Import der
		                        Versorgungsdatei in Bearbeitung befindet.
		</p>
		
		@return der Wert von Version.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 getVersion() {
			return _version;
		}
	
		/**
		Versionsnummer des Konfigurationsbereichs, in der die Versorgungsdatei importiert wurde.
		<p>
		Die Versionsnummer wird vom Import gesetzt. Sie entspricht der Version des Konfigurationsbereichs, die sich beim Import der
		                        Versorgungsdatei in Bearbeitung befindet.
		</p>
		
		@param _version der neue Wert von Version.
		*/
		public void setVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
		 _version) {
			this._version = _version;
		}
	
		/**
		Gibt an, warum eine KonfigurationsÄnderung erforderlich ist&#47;war.
		<p>
		
		</p>
		
		@return der Wert von Grund.
		*/
			public String
			 getGrund() {
			return _grund;
		}
	
		/**
		Gibt an, warum eine KonfigurationsÄnderung erforderlich ist&#47;war.
		<p>
		
		</p>
		
		@param _grund der neue Wert von Grund.
		*/
		public void setGrund(String
		 _grund) {
			if (_grund.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._grund = _grund;
		}
	
		/**
		Erklärenden Text zur KonfigurationsÄnderung was alles an der Versorgung geändert wurde.
		<p>
		
		</p>
		
		@return der Wert von Text.
		*/
			public String
			 getText() {
			return _text;
		}
	
		/**
		Erklärenden Text zur KonfigurationsÄnderung was alles an der Versorgung geändert wurde.
		<p>
		
		</p>
		
		@param _text der neue Wert von Text.
		*/
		public void setText(String
		 _text) {
			if (_text.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._text = _text;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Stand").setMillis(getStand().getTime());
				// ZeichenkettenAttributTyp
				if (getAutor() != null) {
					datum.getTextValue("Autor").setText(getAutor());
				}
				// GanzzahlAttributTyp
				if (getVersion() != null) {
	                if (getVersion().isZustand()) {
	                    datum.getUnscaledValue("Version").setText(getVersion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Version").set(getVersion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getGrund() != null) {
					datum.getTextValue("Grund").setText(getGrund());
				}
				// ZeichenkettenAttributTyp
				if (getText() != null) {
					datum.getTextValue("Text").setText(getText());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setStand(new
						Zeitstempel
						(daten.getTimeValue("Stand").getMillis()));
				// ZeichenkettenAttributTyp
					setAutor(daten.getTextValue("Autor").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Version").isState()) {
							setVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
							.getZustand(daten.getScaledValue("Version").getText()));
						} else {
						setVersion(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
						(daten.
							getUnscaledValue
						("Version").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					setGrund(daten.getTextValue("Grund").getText());
				// ZeichenkettenAttributTyp
					setText(daten.getTextValue("Text").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlKonfigurationsAenderung clone() {
		AtlKonfigurationsAenderung klon = new AtlKonfigurationsAenderung();
		
						klon.setStand(getStand());
						klon.setAutor(getAutor());
						klon.setVersion(getVersion());
						klon.setGrund(getGrund());
						klon.setText(getText());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
