/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert einen Transaktionsdatensatz.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class AtlTransaktionsDatensatz implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlDatenIdentifikation
			 _datenidentifikation
			= new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlDatenIdentifikation
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _datenindex
			;
			private 	Zeitstempel
			 _datenzeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ausTransaktion
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> _daten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			>(0, true);
	
		/**
		Definiert eine Datenidentifikation.
		<p>
		
		</p>
		
		@return der Wert von Datenidentifikation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlDatenIdentifikation
			 getDatenidentifikation() {
			return _datenidentifikation;
		}
	
		/**
		Definiert eine Datenidentifikation.
		<p>
		
		</p>
		
		@param _datenidentifikation der neue Wert von Datenidentifikation.
		*/
		public void setDatenidentifikation(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlDatenIdentifikation
		 _datenidentifikation) {
			this._datenidentifikation = _datenidentifikation;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@return der Wert von Datenindex.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getDatenindex() {
			return _datenindex;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
		<p>
		
		</p>
		
		@param _datenindex der neue Wert von Datenindex.
		*/
		public void setDatenindex(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _datenindex) {
			this._datenindex = _datenindex;
		}
	
		/**
		Zeitstempel.
		<p>
		Der Zeitstempel wird z.B.im Zusammenhang von"gültigAb" und"nichtMehrGültigAb" in der Tabelle für die dynamischen Objekte (z.B.
		                    Staus) benutzt.
		</p>
		
		@return der Wert von Datenzeit.
		*/
			public 	Zeitstempel
			 getDatenzeit() {
			return _datenzeit;
		}
	
		/**
		Zeitstempel.
		<p>
		Der Zeitstempel wird z.B.im Zusammenhang von"gültigAb" und"nichtMehrGültigAb" in der Tabelle für die dynamischen Objekte (z.B.
		                    Staus) benutzt.
		</p>
		
		@param _datenzeit der neue Wert von Datenzeit.
		*/
		public void setDatenzeit(	Zeitstempel
		 _datenzeit) {
			this._datenzeit = _datenzeit;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von AusTransaktion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getAusTransaktion() {
			return _ausTransaktion;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _ausTransaktion der neue Wert von AusTransaktion.
		*/
		public void setAusTransaktion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _ausTransaktion) {
			this._ausTransaktion = _ausTransaktion;
		}
	
		/**
		Beliebige ganze Zahl im Bereich -128 bis 127.
		<p>
		
		</p>
		
		@return der Wert von Daten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> getDaten() {
			return _daten;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getDatenidentifikation().bean2Atl(datum.getItem("Datenidentifikation"), factory);
				// GanzzahlAttributTyp
				if (getDatenindex() != null) {
	                if (getDatenindex().isZustand()) {
	                    datum.getUnscaledValue("Datenindex").setText(getDatenindex().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Datenindex").set(getDatenindex().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Datenzeit").setMillis(getDatenzeit().getTime());
				// GanzzahlAttributTyp
				if (getAusTransaktion() != null) {
	                if (getAusTransaktion().isZustand()) {
	                    datum.getUnscaledValue("AusTransaktion").setText(getAusTransaktion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AusTransaktion").set(getAusTransaktion().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDaten() != null) {
					final Data.NumberArray arrayDaten = datum.
						getUnscaledArray
						("Daten");
					arrayDaten.setLength(getDaten().size());
					for (int i = 0; i < arrayDaten.getLength(); ++i) {
						arrayDaten.getValue(i).set(getDaten().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getDatenidentifikation().atl2Bean(daten.getItem("Datenidentifikation"), factory);
				// GanzzahlAttributTyp
						setDatenindex(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Datenindex").
								longValue
						()));
				// ZeitstempelAttributTyp
					setDatenzeit(new
						Zeitstempel
						(daten.getTimeValue("Datenzeit").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AusTransaktion").isState()) {
							setAusTransaktion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("AusTransaktion").getText()));
						} else {
						setAusTransaktion(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("AusTransaktion").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayDaten = daten.
						getUnscaledArray
					("Daten");
	
					for (int i = 0; i < arrayDaten.getLength(); ++i) {
	                    getDaten().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
	                    (arrayDaten.
	                    		byteValue
	                    (i)));
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTransaktionsDatensatz clone() {
		AtlTransaktionsDatensatz klon = new AtlTransaktionsDatensatz();
		
						klon._datenidentifikation = getDatenidentifikation().clone();
						klon.setDatenindex(getDatenindex());
						klon.setDatenzeit(getDatenzeit());
						klon.setAusTransaktion(getAusTransaktion());
					klon._daten = getDaten().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
