/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Position, Name, Anzahl (fest, variabel) und Attribut-Typ-Referenz eines Attributs in einer Attributmenge.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAttributEigenschaften extends AbstractKonfigurationsDatensatz<KdAttributEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttPosition
				 _position
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
				 _anzahl
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _anzahlVariabel
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributTyp
				 _attributTyp
				;
		
			/**
			Position eines Attributs in einer Attributgruppe oder -liste.
			<p>
			
			</p>
			
			@return der Wert von Position.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttPosition
				 getPosition() {
				return _position;
			}
		
			/**
			Position eines Attributs in einer Attributgruppe oder -liste.
			<p>
			
			</p>
			
			@param _position der neue Wert von Position.
			*/
			public void setPosition(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttPosition
			 _position) {
				this._position = _position;
			}
		
			/**
			Maximal mögliche Anzahl.
			<p>
			
			</p>
			
			@return der Wert von Anzahl.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
				 getAnzahl() {
				return _anzahl;
			}
		
			/**
			Maximal mögliche Anzahl.
			<p>
			
			</p>
			
			@param _anzahl der neue Wert von Anzahl.
			*/
			public void setAnzahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
			 _anzahl) {
				this._anzahl = _anzahl;
			}
		
			/**
			Spezifiziert ob die Anzahl der verwendeten Feldelement zwischen 0 und der im Attribut 'anzahl' angegebenen Größe variieren
			                        kann.
			<p>
			
			</p>
			
			@return der Wert von AnzahlVariabel.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAnzahlVariabel() {
				return _anzahlVariabel;
			}
		
			/**
			Spezifiziert ob die Anzahl der verwendeten Feldelement zwischen 0 und der im Attribut 'anzahl' angegebenen Größe variieren
			                        kann.
			<p>
			
			</p>
			
			@param _anzahlVariabel der neue Wert von AnzahlVariabel.
			*/
			public void setAnzahlVariabel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _anzahlVariabel) {
				this._anzahlVariabel = _anzahlVariabel;
			}
		
			/**
			Attribut zur Referenzierung von Attribut-Typen.
			<p>
			
			</p>
			
			@return der Wert von AttributTyp.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributTyp
				 getAttributTyp() {
				return _attributTyp;
			}
		
			/**
			Attribut zur Referenzierung von Attribut-Typen.
			<p>
			
			</p>
			
			@param _attributTyp der neue Wert von AttributTyp.
			*/
			public void setAttributTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributTyp
			 _attributTyp) {
				this._attributTyp = _attributTyp;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getPosition() != null) {
		                if (getPosition().isZustand()) {
		                    datum.getUnscaledValue("position").setText(getPosition().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("position").set(getPosition().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahl() != null) {
		                if (getAnzahl().isZustand()) {
		                    datum.getUnscaledValue("anzahl").setText(getAnzahl().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("anzahl").set(getAnzahl().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlVariabel() != null) {
		                if (getAnzahlVariabel().isZustand()) {
		                    datum.getUnscaledValue("anzahlVariabel").setText(getAnzahlVariabel().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("anzahlVariabel").set(getAnzahlVariabel().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soAttributTyp = getAttributTyp();
						final SystemObject tmpAttributTyp;
							if (soAttributTyp instanceof SystemObject) {
								tmpAttributTyp = (SystemObject)soAttributTyp;
							} else if(soAttributTyp instanceof SystemObjekt){
								tmpAttributTyp = ((SystemObjekt)soAttributTyp).getSystemObject();
							} else{
								tmpAttributTyp = null;
							}
						datum.getReferenceValue("attributTyp").setSystemObject(tmpAttributTyp);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setPosition(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttPosition
							(daten.
								getUnscaledValue
							("position").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("anzahl").isState()) {
								setAnzahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
								.getZustand(daten.getScaledValue("anzahl").getText()));
							} else {
							setAnzahl(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
							(daten.
								getUnscaledValue
							("anzahl").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("anzahlVariabel").isState()) {
								setAnzahlVariabel(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("anzahlVariabel").getText()));
							} else {
							setAnzahlVariabel(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("anzahlVariabel").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idAttributTyp = daten.getReferenceValue("attributTyp").getId();
						final SystemObjekt tmpAttributTyp;
						if (idAttributTyp == 0) {
							tmpAttributTyp = null;
						} else {
							final SystemObject soAttributTyp = factory.getDav().getDataModel().getObject(idAttributTyp);
							if (soAttributTyp == null) {
									tmpAttributTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributTypUngueltig(idAttributTyp);
							} else {
								tmpAttributTyp = factory.getModellobjekt(soAttributTyp);
							}
						}
						setAttributTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributTyp
						) tmpAttributTyp);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setPosition(getPosition());
							klon.setAnzahl(getAnzahl());
							klon.setAnzahlVariabel(getAnzahlVariabel());
							klon.setAttributTyp(getAttributTyp());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.attributEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAttributEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
