/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält Informationen, wenn dieses Objekt mit KExDaV übertragen wurde und von einer anderen Konfiguration stammt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class KdKexdavAustauschObjekt extends AbstractKonfigurationsDatensatz<KdKexdavAustauschObjekt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _originalId
				;
				private String
				 _konfigurationsVerantwortlicher
				= new String
				()
				;
				private String
				 _kexdavObjekt
				= new String
				()
				;
		
			/**
			Die Id des Objektes auf dem Quellsystem.
			<p>
			
			</p>
			
			@return der Wert von OriginalId.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getOriginalId() {
				return _originalId;
			}
		
			/**
			Die Id des Objektes auf dem Quellsystem.
			<p>
			
			</p>
			
			@param _originalId der neue Wert von OriginalId.
			*/
			public void setOriginalId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _originalId) {
				this._originalId = _originalId;
			}
		
			/**
			Der Konfigurationsverantwortliche des Originalobjekts.
			<p>
			
			</p>
			
			@return der Wert von KonfigurationsVerantwortlicher.
			*/
				public String
				 getKonfigurationsVerantwortlicher() {
				return _konfigurationsVerantwortlicher;
			}
		
			/**
			Der Konfigurationsverantwortliche des Originalobjekts.
			<p>
			
			</p>
			
			@param _konfigurationsVerantwortlicher der neue Wert von KonfigurationsVerantwortlicher.
			*/
			public void setKonfigurationsVerantwortlicher(String
			 _konfigurationsVerantwortlicher) {
				if (_konfigurationsVerantwortlicher.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._konfigurationsVerantwortlicher = _konfigurationsVerantwortlicher;
			}
		
			/**
			Das KExDaV-Objekt mit dem dieses Objekt übertragen wurde.
			<p>
			
			</p>
			
			@return der Wert von KexdavObjekt.
			*/
				public String
				 getKexdavObjekt() {
				return _kexdavObjekt;
			}
		
			/**
			Das KExDaV-Objekt mit dem dieses Objekt übertragen wurde.
			<p>
			
			</p>
			
			@param _kexdavObjekt der neue Wert von KexdavObjekt.
			*/
			public void setKexdavObjekt(String
			 _kexdavObjekt) {
				if (_kexdavObjekt.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._kexdavObjekt = _kexdavObjekt;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getOriginalId() != null) {
		                if (getOriginalId().isZustand()) {
		                    datum.getUnscaledValue("originalId").setText(getOriginalId().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("originalId").set(getOriginalId().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getKonfigurationsVerantwortlicher() != null) {
						datum.getTextValue("konfigurationsVerantwortlicher").setText(getKonfigurationsVerantwortlicher());
					}
					// ZeichenkettenAttributTyp
					if (getKexdavObjekt() != null) {
						datum.getTextValue("kexdavObjekt").setText(getKexdavObjekt());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setOriginalId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("originalId").
									longValue
							()));
					// ZeichenkettenAttributTyp
						setKonfigurationsVerantwortlicher(daten.getTextValue("konfigurationsVerantwortlicher").getText());
					// ZeichenkettenAttributTyp
						setKexdavObjekt(daten.getTextValue("kexdavObjekt").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setOriginalId(getOriginalId());
							klon.setKonfigurationsVerantwortlicher(getKonfigurationsVerantwortlicher());
							klon.setKexdavObjekt(getKexdavObjekt());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.kexdavAustauschObjekt";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdKexdavAustauschObjekt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
