/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe, die die minimal und maximal erlaubte Anzahl von Objekten in Mengen des jeweiligen Typs definiert.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdMengenTypEigenschaften extends AbstractKonfigurationsDatensatz<KdMengenTypEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMinimaleAnzahl
				 _minimaleAnzahl
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
				 _maximaleAnzahl
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _aenderbar
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
				 _referenzierungsart
				;
		
			/**
			Minimale Anzahl der Elemente in der Menge.
			<p>
			
			</p>
			
			@return der Wert von MinimaleAnzahl.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMinimaleAnzahl
				 getMinimaleAnzahl() {
				return _minimaleAnzahl;
			}
		
			/**
			Minimale Anzahl der Elemente in der Menge.
			<p>
			
			</p>
			
			@param _minimaleAnzahl der neue Wert von MinimaleAnzahl.
			*/
			public void setMinimaleAnzahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMinimaleAnzahl
			 _minimaleAnzahl) {
				this._minimaleAnzahl = _minimaleAnzahl;
			}
		
			/**
			Maximale Anzahl der Elemente in der Menge.
			<p>
			
			</p>
			
			@return der Wert von MaximaleAnzahl.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
				 getMaximaleAnzahl() {
				return _maximaleAnzahl;
			}
		
			/**
			Maximale Anzahl der Elemente in der Menge.
			<p>
			
			</p>
			
			@param _maximaleAnzahl der neue Wert von MaximaleAnzahl.
			*/
			public void setMaximaleAnzahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
			 _maximaleAnzahl) {
				this._maximaleAnzahl = _maximaleAnzahl;
			}
		
			/**
			Legt fest, ob Mengen dieses Typs online änderbar sind.
			<p>
			
			</p>
			
			@return der Wert von Aenderbar.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAenderbar() {
				return _aenderbar;
			}
		
			/**
			Legt fest, ob Mengen dieses Typs online änderbar sind.
			<p>
			
			</p>
			
			@param _aenderbar der neue Wert von Aenderbar.
			*/
			public void setAenderbar(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aenderbar) {
				this._aenderbar = _aenderbar;
			}
		
			/**
			Referenzierungsart von Mengen (Gerichtete Assoziation, Aggregation oder Komposition).
			<p>
			&lt;absatz&gt;
			                            Zu jedem Mengentyp von Konfigurationsmengen muss verwaltet werden, ob die Referenzen auf die Elemente einer Menge dieses Typs als
			                            gerichtete Assoziation, als Aggregation oder als Komposition realisiert werden soll. (TPuK1-90 Referenzierungsart von
			                            Konfigurationsmengen).
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Zu jedem Mengentyp von dynamischen Mengen darf als Referenzierungsart nur die gerichtete Assoziation zugelassen werden. (TPuK1-91
			                            Referenzierungsart von dynamischen Mengen).
			                        &lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Referenzierungsart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
				 getReferenzierungsart() {
				return _referenzierungsart;
			}
		
			/**
			Referenzierungsart von Mengen (Gerichtete Assoziation, Aggregation oder Komposition).
			<p>
			&lt;absatz&gt;
			                            Zu jedem Mengentyp von Konfigurationsmengen muss verwaltet werden, ob die Referenzen auf die Elemente einer Menge dieses Typs als
			                            gerichtete Assoziation, als Aggregation oder als Komposition realisiert werden soll. (TPuK1-90 Referenzierungsart von
			                            Konfigurationsmengen).
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Zu jedem Mengentyp von dynamischen Mengen darf als Referenzierungsart nur die gerichtete Assoziation zugelassen werden. (TPuK1-91
			                            Referenzierungsart von dynamischen Mengen).
			                        &lt;&#47;absatz&gt;
			</p>
			
			@param _referenzierungsart der neue Wert von Referenzierungsart.
			*/
			public void setReferenzierungsart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
			 _referenzierungsart) {
				this._referenzierungsart = _referenzierungsart;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getMinimaleAnzahl() != null) {
		                if (getMinimaleAnzahl().isZustand()) {
		                    datum.getUnscaledValue("minimaleAnzahl").setText(getMinimaleAnzahl().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("minimaleAnzahl").set(getMinimaleAnzahl().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaximaleAnzahl() != null) {
		                if (getMaximaleAnzahl().isZustand()) {
		                    datum.getUnscaledValue("maximaleAnzahl").setText(getMaximaleAnzahl().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("maximaleAnzahl").set(getMaximaleAnzahl().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAenderbar() != null) {
		                if (getAenderbar().isZustand()) {
		                    datum.getUnscaledValue("änderbar").setText(getAenderbar().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("änderbar").set(getAenderbar().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReferenzierungsart() != null) {
		                if (getReferenzierungsart().isZustand()) {
		                    datum.getUnscaledValue("referenzierungsart").setText(getReferenzierungsart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("referenzierungsart").set(getReferenzierungsart().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setMinimaleAnzahl(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMinimaleAnzahl
							(daten.
								getUnscaledValue
							("minimaleAnzahl").
									intValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("maximaleAnzahl").isState()) {
								setMaximaleAnzahl(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
								.getZustand(daten.getScaledValue("maximaleAnzahl").getText()));
							} else {
							setMaximaleAnzahl(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttMaximaleAnzahl
							(daten.
								getUnscaledValue
							("maximaleAnzahl").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("änderbar").isState()) {
								setAenderbar(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("änderbar").getText()));
							} else {
							setAenderbar(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("änderbar").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("referenzierungsart").isState()) {
								setReferenzierungsart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
								.getZustand(daten.getScaledValue("referenzierungsart").getText()));
							} else {
							setReferenzierungsart(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
							(daten.
								getUnscaledValue
							("referenzierungsart").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setMinimaleAnzahl(getMinimaleAnzahl());
							klon.setMaximaleAnzahl(getMaximaleAnzahl());
							klon.setAenderbar(getAenderbar());
							klon.setReferenzierungsart(getReferenzierungsart());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.mengenTypEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdMengenTypEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
