/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Speicherung der Eigenschaften einer MengenVerwendung.
<p>
Bei jeder TypDefinition ist eine Liste von Mengen angegeben, die bei Objekten dieses Typs verwendet werden müssen oder können. Für
                    jede Menge der Typdefinition wird in dieser Attributgruppe beschrieben, wie die Menge heißen muss, welchen Mengentyp sie haben muss und ob
                    sie bei jedem Objekt des Typs vorhanden sein muss oder optional ist.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdMengenVerwendungsEigenschaften extends AbstractKonfigurationsDatensatz<KdMengenVerwendungsEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _mengenName
				= new String
				()
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
				 _mengenTyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _erforderlich
				;
		
			/**
			Persistenter Name der Menge.
			<p>
			Der Name unter dem die Menge ausgehend von einem Objekt des jeweiligen Typs referenzierbar ist.
			</p>
			
			@return der Wert von MengenName.
			*/
				public String
				 getMengenName() {
				return _mengenName;
			}
		
			/**
			Persistenter Name der Menge.
			<p>
			Der Name unter dem die Menge ausgehend von einem Objekt des jeweiligen Typs referenzierbar ist.
			</p>
			
			@param _mengenName der neue Wert von MengenName.
			*/
			public void setMengenName(String
			 _mengenName) {
				if (_mengenName.length() > 64) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
				}
				this._mengenName = _mengenName;
			}
		
			/**
			Referenz auf die MengenDefinition die den Typ der Menge beschreibt.
			<p>
			
			</p>
			
			@return der Wert von MengenTyp.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
				 getMengenTyp() {
				return _mengenTyp;
			}
		
			/**
			Referenz auf die MengenDefinition die den Typ der Menge beschreibt.
			<p>
			
			</p>
			
			@param _mengenTyp der neue Wert von MengenTyp.
			*/
			public void setMengenTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			 _mengenTyp) {
				this._mengenTyp = _mengenTyp;
			}
		
			/**
			Gibt an ob die Existenz der Menge unter einem Objekt des jeweiligen Typs erforderlich ist.
			<p>
			
			</p>
			
			@return der Wert von Erforderlich.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getErforderlich() {
				return _erforderlich;
			}
		
			/**
			Gibt an ob die Existenz der Menge unter einem Objekt des jeweiligen Typs erforderlich ist.
			<p>
			
			</p>
			
			@param _erforderlich der neue Wert von Erforderlich.
			*/
			public void setErforderlich(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _erforderlich) {
				this._erforderlich = _erforderlich;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getMengenName() != null) {
						datum.getTextValue("mengenName").setText(getMengenName());
					}
					// ObjektReferenzAttributTyp
						final Object soMengenTyp = getMengenTyp();
						final SystemObject tmpMengenTyp;
							if (soMengenTyp instanceof SystemObject) {
								tmpMengenTyp = (SystemObject)soMengenTyp;
							} else if(soMengenTyp instanceof SystemObjekt){
								tmpMengenTyp = ((SystemObjekt)soMengenTyp).getSystemObject();
							} else{
								tmpMengenTyp = null;
							}
						datum.getReferenceValue("mengenTyp").setSystemObject(tmpMengenTyp);
					// GanzzahlAttributTyp
					if (getErforderlich() != null) {
		                if (getErforderlich().isZustand()) {
		                    datum.getUnscaledValue("erforderlich").setText(getErforderlich().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("erforderlich").set(getErforderlich().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setMengenName(daten.getTextValue("mengenName").getText());
					// ObjektReferenzAttributTyp
						final long idMengenTyp = daten.getReferenceValue("mengenTyp").getId();
						final SystemObjekt tmpMengenTyp;
						if (idMengenTyp == 0) {
							tmpMengenTyp = null;
						} else {
							final SystemObject soMengenTyp = factory.getDav().getDataModel().getObject(idMengenTyp);
							if (soMengenTyp == null) {
									tmpMengenTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.MengenTypUngueltig(idMengenTyp);
							} else {
								tmpMengenTyp = factory.getModellobjekt(soMengenTyp);
							}
						}
						setMengenTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
						) tmpMengenTyp);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("erforderlich").isState()) {
								setErforderlich(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("erforderlich").getText()));
							} else {
							setErforderlich(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("erforderlich").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setMengenName(getMengenName());
							klon.setMengenTyp(getMengenTyp());
							klon.setErforderlich(getErforderlich());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.mengenVerwendungsEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdMengenVerwendungsEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
