/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zur Gruppierung von Konfigurationsobjekten und Konfigurationsdaten nach modellspezifischen, inhaltlichen und organisatorischen
                    Gesichtspunkten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface KonfigurationsBereich extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	, de.bsvrz.sys.funclib.bitctrl.modell.SystemObjektBereich
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.konfigurationsBereich"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Verwaltet beliebig viele Abhängigkeiten der Konfigurationsbereiche.
	<p>
	Durch Referenzen in andere Bereich können Abhängigkeiten unter den Bereichen entstehen. Alle Abhängigkeiten eines Bereichs zu anderen
	                    Bereichen werden in dieser Attributgruppe gespeichert.
	</p>
	@return der Datensatz KonfigurationsBereichAbhaengigkeiten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsBereichAbhaengigkeiten getKdKonfigurationsBereichAbhaengigkeiten();
	
	/**
	Attributgruppe zur Speicherung von Informationen zur Übernahme eines Konfigurationsbereichs.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsBereichUebernahmeInformationen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsBereichUebernahmeInformationen getKdKonfigurationsBereichUebernahmeInformationen();
	
	/**
	Verwaltet beliebig viele Änderungseinträge der Konfigurationsbereiche.
	<p>
	Jedem Konfigurationsbereich können in der Versorgungsdatei Konfigurationsänderungen mitgeteilt werden. Diese werden in diesem Datensatz
	                    abgelegt.
	</p>
	@return der Datensatz KonfigurationsAenderungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsAenderungen getKdKonfigurationsAenderungen();
	
	/**
	Attributgruppe zur Speicherung von Eigenschaften von Konfigurationsbereichen.
	<p>
	Dieser Datensatz sollte nur durch den Import und die Aktivierung geändert werden.
	</p>
	@return der Datensatz KonfigurationsBereichEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsBereichEigenschaften getKdKonfigurationsBereichEigenschaften();
	
	/**
	Attributgruppe zur Speicherung von Zeiten der letzten Änderung eines Bereichs.
	<p>
	Um die Aktualität seitens einer Applikation zwischengespeicherter Konfigurationsdaten zu unterstützen, müssen zu jedem Konfigurationsbereich
	                    verschiedene Zeitpunkte verwaltet werden.
	</p>
	@return der Datensatz KonfigurationsBereichAenderungsZeiten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsBereichAenderungsZeiten getKdKonfigurationsBereichAenderungsZeiten();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Enthält eine Liste von Versionen mit unversionierten Datenmodelländerungen, die in dieser Version aktiviert werden&#47;wurden.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsBereichUnversionierteAenderungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsBereichUnversionierteAenderungen getKdKonfigurationsBereichUnversionierteAenderungen();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
