/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Objekte dieses Typs können für die Konfiguration von konfigurierenden Objekten zuständig sein. (z.B. VRZen, UZen, System).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface KonfigurationsVerantwortlicher extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.konfigurationsVerantwortlicher"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Zur Übermittlung von Anfragen an die Konfiguration.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrage getOdKonfigurationsAnfrage();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Zur Übermittlung von Änderungsanfragen an die Konfiguration.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsSchreibAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsSchreibAnfrage getOdKonfigurationsSchreibAnfrage();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht es, die
						Konfiguration zu beauftragen bestimmte Objekt in der Konfigurations zu ändern.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Auf alle Objekte der Konfiguration kann nur schreibend
						zugegriffen werden.
	</p>
	@return der Datensatz KonfigurationsAnfrageSchnittstelleSchreibend.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleSchreibend getOdKonfigurationsAnfrageSchnittstelleSchreibend();
	
	/**
	Attributgruppe zur Speicherung von Eigenschaften von Konfigurationsbereichen.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsVerantwortlicherEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherEigenschaften getKdKonfigurationsVerantwortlicherEigenschaften();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht es, die
						Konfiguration zu beauftragen die Konfigurationsbereiche der Konfigurations zu verwalten.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Die Konfiguration kann über diese Schnittstelle angewiesen
						werden Konfigurationsbereiche in einer neuen Version zu aktivieren, Konsistenzprüfungen durchzuführen, Konfigurationsbereiche zur übernahme
						freizugeben, usw..
	</p>
	@return der Datensatz KonfigurationsBereichsverwaltungsAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBereichsverwaltungsAnfrageSchnittstelle getOdKonfigurationsBereichsverwaltungsAnfrageSchnittstelle();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert.
	</p>
	@return der Datensatz KonfigurationsAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelle getOdKonfigurationsAnfrageSchnittstelle();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht nur
						lesenden Zugriff auf die Konfiguration.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Auf alle Objekte der Konfiguration kann nur lesen zugegriffen
						werden, es kann keine Änderung in der Konfigurations angestoßen werden.
	</p>
	@return der Datensatz KonfigurationsAnfrageSchnittstelleLesend.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleLesend getOdKonfigurationsAnfrageSchnittstelleLesend();
	
	/**
	Speichert die Laufende Nummer des KonfigurationsVerantwortlichen.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsVerantwortlicherLaufendeNummer.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherLaufendeNummer getKdKonfigurationsVerantwortlicherLaufendeNummer();
	
	/**
	Zur Übermittlung von Archiv-Anfragen an die Datenhaltung.
	<p>
	
	</p>
	@return der Datensatz ArchivAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrage getOdArchivAnfrage();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht es, die
						Konfiguration zu beauftragen die Benutzer der Konfiguration zu verwalten.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Die Konfigurations kann über diese Schnittstelle angewiesen
						werden neue Benutzer anzulegen, Einmal-Passwörter zu erzeugen, Rechte festzulegen, Benutzerpasswörter zu ändern, usw.. Die meisten Aufträge,
						die erteilt werden können, bedürfen spezieller Rechte oder dürfen nur durch den jeweiligen Benutzer&#47;Admin (Passwort ändern) durchgeführt
						werden Die Konfiguration wird nach empfang eines Auftrags erst prüfen, ob der Benutzer, der den Auftrag erteilt hat, diese speziellen Rechte
						besitzt.
	</p>
	@return der Datensatz KonfigurationsBenutzerverwaltungsAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBenutzerverwaltungsAnfrageSchnittstelle getOdKonfigurationsBenutzerverwaltungsAnfrageSchnittstelle();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
