/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Belegungsinformationen und (Fehler)Zustand zu den Sensoren der Parktasche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSensorZustand implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueBelegung
			 _belegung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fehlerhaft
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueHerstellerSpezifischerCode
			 _herstellerSpezifischerCode
			;
	
		/**
		Gibt an, ob der Sensor innerhalb der zugeordneten Tasche belegt&#47;nicht belegt ist.
		<p>
		
		</p>
		
		@return der Wert von Belegung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueBelegung
			 getBelegung() {
			return _belegung;
		}
	
		/**
		Gibt an, ob der Sensor innerhalb der zugeordneten Tasche belegt&#47;nicht belegt ist.
		<p>
		
		</p>
		
		@param _belegung der neue Wert von Belegung.
		*/
		public void setBelegung(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueBelegung
		 _belegung) {
			this._belegung = _belegung;
		}
	
		/**
		Gibt an, ob der Zustand des Sensors innerhalb der zugeordneten Tasche fehlerhaft ist.
		<p>
		
		</p>
		
		@return der Wert von Fehlerhaft.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getFehlerhaft() {
			return _fehlerhaft;
		}
	
		/**
		Gibt an, ob der Zustand des Sensors innerhalb der zugeordneten Tasche fehlerhaft ist.
		<p>
		
		</p>
		
		@param _fehlerhaft der neue Wert von Fehlerhaft.
		*/
		public void setFehlerhaft(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _fehlerhaft) {
			this._fehlerhaft = _fehlerhaft;
		}
	
		/**
		Herstellerdefinitionen.
		<p>
		
		</p>
		
		@return der Wert von HerstellerSpezifischerCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueHerstellerSpezifischerCode
			 getHerstellerSpezifischerCode() {
			return _herstellerSpezifischerCode;
		}
	
		/**
		Herstellerdefinitionen.
		<p>
		
		</p>
		
		@param _herstellerSpezifischerCode der neue Wert von HerstellerSpezifischerCode.
		*/
		public void setHerstellerSpezifischerCode(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueHerstellerSpezifischerCode
		 _herstellerSpezifischerCode) {
			this._herstellerSpezifischerCode = _herstellerSpezifischerCode;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getBelegung() != null) {
	                if (getBelegung().isZustand()) {
	                    datum.getUnscaledValue("Belegung").setText(getBelegung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Belegung").set(getBelegung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFehlerhaft() != null) {
	                if (getFehlerhaft().isZustand()) {
	                    datum.getUnscaledValue("Fehlerhaft").setText(getFehlerhaft().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Fehlerhaft").set(getFehlerhaft().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getHerstellerSpezifischerCode() != null) {
	                if (getHerstellerSpezifischerCode().isZustand()) {
	                    datum.getUnscaledValue("HerstellerSpezifischerCode").setText(getHerstellerSpezifischerCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("HerstellerSpezifischerCode").set(getHerstellerSpezifischerCode().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Belegung").isState()) {
							setBelegung(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueBelegung
							.getZustand(daten.getScaledValue("Belegung").getText()));
						} else {
						setBelegung(new de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueBelegung
						(daten.
							getUnscaledValue
						("Belegung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Fehlerhaft").isState()) {
							setFehlerhaft(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Fehlerhaft").getText()));
						} else {
						setFehlerhaft(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Fehlerhaft").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setHerstellerSpezifischerCode(new de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueHerstellerSpezifischerCode
						(daten.
							getUnscaledValue
						("HerstellerSpezifischerCode").
								byteValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSensorZustand clone() {
		AtlSensorZustand klon = new AtlSensorZustand();
		
						klon.setBelegung(getBelegung());
						klon.setFehlerhaft(getFehlerhaft());
						klon.setHerstellerSpezifischerCode(getHerstellerSpezifischerCode());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
