/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zyklus für die zeitlichen Abstände der Übertragung
				    von Messwerten.
<p>
&lt;absatz&gt;
					    Der Wert "Erfassungsperiodendauer" gibt an, in
					    welchen zeitlichen Abständen die Übertragung des
					    Messergebnisses erfolgen soll. Es sind nur Werte
					    zugelassen, die ein ganzzahliges Vielfaches
					    haben, welches 24 Stunden ergibt (1, 2, 3, 4, 5,
					    6, 10, 12, 15, 20, und 30 Minuten und 1, 1½, 2,
					    3, 4, 6, 8 und 12 Stunden).
				    &lt;&#47;absatz&gt;
				    &lt;absatz&gt;
					    Der Wert "Erfassungsperiodendauer" ist nur relevant bei
					    der zyklischen Abgabe von Meldungen (Byte
					    "Übertragungsverfahren" = 1).
				    &lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsPpueErfassungsperiodendauer extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_60__1_MINUTE = new AttTlsPpueErfassungsperiodendauer("1 Minute", 		Integer
	.valueOf("60"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_120__2_MINUTEN = new AttTlsPpueErfassungsperiodendauer("2 Minuten", 		Integer
	.valueOf("120"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_180__3_MINUTEN = new AttTlsPpueErfassungsperiodendauer("3 Minuten", 		Integer
	.valueOf("180"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_240__4_MINUTEN = new AttTlsPpueErfassungsperiodendauer("4 Minuten", 		Integer
	.valueOf("240"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_300__5_MINUTEN = new AttTlsPpueErfassungsperiodendauer("5 Minuten", 		Integer
	.valueOf("300"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_360__6_MINUTEN = new AttTlsPpueErfassungsperiodendauer("6 Minuten", 		Integer
	.valueOf("360"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_600__10_MINUTEN = new AttTlsPpueErfassungsperiodendauer("10 Minuten", 		Integer
	.valueOf("600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_720__12_MINUTEN = new AttTlsPpueErfassungsperiodendauer("12 Minuten", 		Integer
	.valueOf("720"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_900__15_MINUTEN = new AttTlsPpueErfassungsperiodendauer("15 Minuten", 		Integer
	.valueOf("900"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_1200__20_MINUTEN = new AttTlsPpueErfassungsperiodendauer("20 Minuten", 		Integer
	.valueOf("1200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_1800__30_MINUTEN = new AttTlsPpueErfassungsperiodendauer("30 Minuten", 		Integer
	.valueOf("1800"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_3600__1_STUNDE = new AttTlsPpueErfassungsperiodendauer("1 Stunde", 		Integer
	.valueOf("3600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_5400__1_STUNDEN = new AttTlsPpueErfassungsperiodendauer("1½ Stunden", 		Integer
	.valueOf("5400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_7200__2_STUNDEN = new AttTlsPpueErfassungsperiodendauer("2 Stunden", 		Integer
	.valueOf("7200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_10800__3_STUNDEN = new AttTlsPpueErfassungsperiodendauer("3 Stunden", 		Integer
	.valueOf("10800"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_14400__4_STUNDEN = new AttTlsPpueErfassungsperiodendauer("4 Stunden", 		Integer
	.valueOf("14400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_21600__6_STUNDEN = new AttTlsPpueErfassungsperiodendauer("6 Stunden", 		Integer
	.valueOf("21600"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_28800__8_STUNDEN = new AttTlsPpueErfassungsperiodendauer("8 Stunden", 		Integer
	.valueOf("28800"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPpueErfassungsperiodendauer ZUSTAND_43200__12_STUNDEN = new AttTlsPpueErfassungsperiodendauer("12 Stunden", 		Integer
	.valueOf("43200"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPpueErfassungsperiodendauer getZustand(final 		Integer
	 value) {
		for (AttTlsPpueErfassungsperiodendauer e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPpueErfassungsperiodendauer getZustand(final String value) {
		for (AttTlsPpueErfassungsperiodendauer e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPpueErfassungsperiodendauer> getZustaende() {
		List<AttTlsPpueErfassungsperiodendauer> list = new ArrayList<AttTlsPpueErfassungsperiodendauer>();
		list.add(ZUSTAND_60__1_MINUTE);
		list.add(ZUSTAND_120__2_MINUTEN);
		list.add(ZUSTAND_180__3_MINUTEN);
		list.add(ZUSTAND_240__4_MINUTEN);
		list.add(ZUSTAND_300__5_MINUTEN);
		list.add(ZUSTAND_360__6_MINUTEN);
		list.add(ZUSTAND_600__10_MINUTEN);
		list.add(ZUSTAND_720__12_MINUTEN);
		list.add(ZUSTAND_900__15_MINUTEN);
		list.add(ZUSTAND_1200__20_MINUTEN);
		list.add(ZUSTAND_1800__30_MINUTEN);
		list.add(ZUSTAND_3600__1_STUNDE);
		list.add(ZUSTAND_5400__1_STUNDEN);
		list.add(ZUSTAND_7200__2_STUNDEN);
		list.add(ZUSTAND_10800__3_STUNDEN);
		list.add(ZUSTAND_14400__4_STUNDEN);
		list.add(ZUSTAND_21600__6_STUNDEN);
		list.add(ZUSTAND_28800__8_STUNDEN);
		list.add(ZUSTAND_43200__12_STUNDEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSPpüErfassungsperiodendauer.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPpueErfassungsperiodendauer(final 		Integer
	 value) {
		super(value);
	}
	
	private AttTlsPpueErfassungsperiodendauer(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
