/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fahrtrichtung, in der der Fahrzeugidentifikator passiert wird.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AttTlsPpueFahrtrichtung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Fahrzeug überfährt das Detektionsfeld in vordefinierter Richtung.
	<p>
	
	</p>
	*/
	public static final AttTlsPpueFahrtrichtung ZUSTAND_0_IN_VORDEFINIERTER_RICHTUNG = new AttTlsPpueFahrtrichtung("In vordefinierter Richtung", 		Short
	.valueOf("0"));

	/**
	Fahrzeug überfährt das Detektionsfeld entgegen der vordefinierten Richtung.
	<p>
	
	</p>
	*/
	public static final AttTlsPpueFahrtrichtung ZUSTAND_1_ENTGEGEN_DER_VORDEFINIERTEN_RICHTUNG = new AttTlsPpueFahrtrichtung("Entgegen der vordefinierten Richtung", 		Short
	.valueOf("1"));

	/**
	Fahrtrichtungswechsel auf der Schleife (Fahrzeug fährt rückwärts auf die Schleife, hält an und
	                            verlässt die Schleife wieder in Vorwärts-Richtung = Rangieren auf der Schleife).
	<p>
	
	</p>
	*/
	public static final AttTlsPpueFahrtrichtung ZUSTAND_2_FAHRTRICHTUNGSWECHSEL_AUF_DER_SCHLEIFE = new AttTlsPpueFahrtrichtung("Fahrtrichtungswechsel auf der Schleife", 		Short
	.valueOf("2"));

	/**
	Fahrtrichtung ist nicht ermittelbar.
	<p>
	
	</p>
	*/
	public static final AttTlsPpueFahrtrichtung ZUSTAND_255_FAHRTRICHTUNG_IST_NICHT_ERMITTELBAR = new AttTlsPpueFahrtrichtung("Fahrtrichtung ist nicht ermittelbar", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPpueFahrtrichtung getZustand(final 		Short
	 value) {
		for (AttTlsPpueFahrtrichtung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPpueFahrtrichtung getZustand(final String value) {
		for (AttTlsPpueFahrtrichtung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPpueFahrtrichtung> getZustaende() {
		List<AttTlsPpueFahrtrichtung> list = new ArrayList<AttTlsPpueFahrtrichtung>();
		list.add(ZUSTAND_0_IN_VORDEFINIERTER_RICHTUNG);
		list.add(ZUSTAND_1_ENTGEGEN_DER_VORDEFINIERTEN_RICHTUNG);
		list.add(ZUSTAND_2_FAHRTRICHTUNGSWECHSEL_AUF_DER_SCHLEIFE);
		list.add(ZUSTAND_255_FAHRTRICHTUNG_IST_NICHT_ERMITTELBAR);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Fahrtrichtung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPpueFahrtrichtung(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsPpueFahrtrichtung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
