/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ordnet einem dynamischem Typen einen Vorhaltezeitraum zu.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AtlParameterEndgueltigesLoeschenObjekte implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "typ.dynamischesObjekt")
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
			 _objekttyp
			;
			@Defaultwert(wert = "365 Tage")
			private 	RelativerZeitstempel
			 _vorhaltezeitraum
			;
	
		/**
		Dynamischer Typ, für den ein maximaler Vorhaltezeitraum definiert werden soll.
		<p>
		
		</p>
		
		@return der Wert von Objekttyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
			 getObjekttyp() {
			return _objekttyp;
		}
	
		/**
		Dynamischer Typ, für den ein maximaler Vorhaltezeitraum definiert werden soll.
		<p>
		
		</p>
		
		@param _objekttyp der neue Wert von Objekttyp.
		*/
		public void setObjekttyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
		 _objekttyp) {
			this._objekttyp = _objekttyp;
		}
	
		/**
		Wie lange ein ungültiges dynamisches Objekt mindestens erhalten bleiben soll.
		<p>
		
		</p>
		
		@return der Wert von Vorhaltezeitraum.
		*/
			public 	RelativerZeitstempel
			 getVorhaltezeitraum() {
			return _vorhaltezeitraum;
		}
	
		/**
		Wie lange ein ungültiges dynamisches Objekt mindestens erhalten bleiben soll.
		<p>
		
		</p>
		
		@param _vorhaltezeitraum der neue Wert von Vorhaltezeitraum.
		*/
		public void setVorhaltezeitraum(	RelativerZeitstempel
		 _vorhaltezeitraum) {
			this._vorhaltezeitraum = _vorhaltezeitraum;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soObjekttyp = getObjekttyp();
					final SystemObject tmpObjekttyp;
						if (soObjekttyp instanceof SystemObject) {
							tmpObjekttyp = (SystemObject)soObjekttyp;
						} else if(soObjekttyp instanceof SystemObjekt){
							tmpObjekttyp = ((SystemObjekt)soObjekttyp).getSystemObject();
						} else{
							tmpObjekttyp = null;
						}
					datum.getReferenceValue("Objekttyp").setSystemObject(tmpObjekttyp);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Vorhaltezeitraum").setMillis(getVorhaltezeitraum().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idObjekttyp = daten.getReferenceValue("Objekttyp").getId();
					final SystemObjekt tmpObjekttyp;
					if (idObjekttyp == 0) {
						tmpObjekttyp = null;
					} else {
						final SystemObject soObjekttyp = factory.getDav().getDataModel().getObject(idObjekttyp);
						if (soObjekttyp == null) {
								tmpObjekttyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.DynamischerTypUngueltig(idObjekttyp);
						} else {
							tmpObjekttyp = factory.getModellobjekt(soObjekttyp);
						}
					}
					setObjekttyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp
					) tmpObjekttyp);
				// ZeitstempelAttributTyp
					setVorhaltezeitraum(new
						RelativerZeitstempel
						(daten.getTimeValue("Vorhaltezeitraum").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterEndgueltigesLoeschenObjekte clone() {
		AtlParameterEndgueltigesLoeschenObjekte klon = new AtlParameterEndgueltigesLoeschenObjekte();
		
						klon.setObjekttyp(getObjekttyp());
						klon.setVorhaltezeitraum(getVorhaltezeitraum());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
