/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter zum endgültigen Löschen von historischen dynamischen Objekten und historischen Mengenreferenzen.
<p>
&lt;absatz&gt;
                        Mit diesem Datensatz werden die Parameter festgelegt, die definieren, wie lange gelöschte dynamische Objekte
                        und gelöschte Mengenelemente behalten werden. Hiermit lässt sich für verschiedene Typen von dynamischen Objekten
                        und für verschiedene Mengentypen ein Vorhaltezeitraum vorgeben, der angibt, wie lange diese Objekte bzw. Referenzen
                        auf jeden Fall behalten werden und für historische Anfragen weiterhin gültig bleiben.
                    &lt;&#47;absatz&gt;
                    &lt;absatz&gt;
                        Objekte und Mengen, für die keine Angaben gemacht werden, bleiben unendlich lange bestehen. Spezifische Angaben
                        haben Vorrang, sodass man beispielsweise mit "typ.dynamischesObjekt" für alle dynamischen Objekte eine Vorgabe
                        machen kann und diese ggf. für beliebige Subtypen überschreiben kann.
                    &lt;&#47;absatz&gt;
                    &lt;absatz&gt;
                        Im Fall der Mehrfachvererbung wird der Supertyp berücksichtigt, der den längsten Vorhaltezeitraum
                        besitzt. Wenn Typ C also von Typ A und Typ B erbt und für Typ C keine Vorgabe gemacht ist, dann müssen sowohl
                        Typ A und Typ B direkt oder indirekt einen Vorhaltezeitraum besitzen, damit das Objekt endgültig gelöscht werden kann.
                        In dem Fall wird der längere der beiden Vorhaltezeiträume verwendet.
                    &lt;&#47;absatz&gt;
                    &lt;absatz&gt;
                        Außerdem bleiben historische dynamische Objekte auf jeden Fall mindestens so lange bestehen, wie noch
                        gültige Objekte oder Mengen auf diese referenzieren. (Das betrifft Konfigurationsdaten oder Mengenreferenzen.
                        Online-Daten oder Parameter werden dabei nicht berücksichtigt.)
                    &lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class PdParameterEndgueltigesLoeschen extends AbstractParameterDatensatz<PdParameterEndgueltigesLoeschen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				@Defaultwert(wert = "0 2 * * Montag")
				private String
				 _intervallRestrukturierung
				= new String
				()
				;
				@Defaultwert(wert = "0 2 * * Sonntag")
				private String
				 _intervallLoeschen
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenObjekte
				> _dynamischeObjekte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenObjekte
				>(0, true);
				private Feld<	RelativerZeitstempel
				> _dynamischeMengenStandard = new Feld<	RelativerZeitstempel
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenMengen
				> _dynamischeMengen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenMengen
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Cron-String, der angibt, wann eine automatische Restrukturierung in der Konfiguration ausgeführt wird.
			<p>
			&lt;absatz&gt;
			                            Bei der Restrukturierung werden ungültige dynamische Objekte in eine effiziente Datenstruktur
			                            der Konfigurationsdatei (NgDyn-Block) verschoben, sodass weitere Zugriffe performant erfolgen können. Je nach
			                            Größe eines Konfigurationsbereichs, Leistung des Rechners und Dauer seit der letzten Restrukturierung kann
			                            eine Restrukturierung wenige Millisekunden bis wenige Sekunden dauern.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            In dieser Zeit ist eine Konfigurationsbereich für verschiedene Lese- und Schreiboperationen gesperrt.
			                            Da dadurch Konfigurationsanfragen für kurze Zeit blockiert werden können, sollte die Restrukturierung
			                            möglichst in Zeiten geringer Last durchgeführt werden.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Standardmäßig wird die Restrukturierung wöchentlich jeden Montag um 02:00 Nachts durchgeführt.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;Ein Cron-Eintrag besteht aus 5 Werten:&lt;&#47;absatz&gt;
			                        &lt;numListe typ="1"&gt;
			                            &lt;listenPunkt&gt;Minute (0-59)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Stunde (0-23)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Tag des Monats (1-31)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Monat (1-12 oder Monatsnamen)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Tag der Woche (0-7, 0 und 7 sind Sonntag, oder Namen)&lt;&#47;listenPunkt&gt;
			                        &lt;&#47;numListe&gt;
			                        &lt;absatz&gt;
			                            Soll ein Wert ignoriert werden, sind Sternchen möglich. (Wildcard)
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Listen und Bereiche können ebenfalls angegeben werden mit "," und "-".
			                            Mit &#47; kann der Befehl alle x Intervalle ausgeführt werden.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Wochen und Monatsnamen sind in deutscher Sprache anzugeben und werden tolerant behandelt.
			                            Gültig für Sonntag ist beispielsweise "so", "son", "Sonntag", usw., Groß- und Kleinschreibung ist
			                            unerheblich.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;Beispiele:&lt;&#47;absatz&gt;
			                        &lt;listing&gt;
			                            #  Min    Std  Tag  Mon   WT
			                            #    5      0    *    *    *    Jeden Tag um 00:05:00
			                            #   15  14,20    1    *    *    Am 1. jeden Monats um 14:15:00 und um 20:15:00
			                            #    0     22    *    *  1-5    An jedem Werktag (Mo-Fr) um 22:00:00
			                            #   23    *&#47;2    *    *    *    Alle 2 Stunden um jeweils xx:23:00, also 00:23:00, 02:23:00, ...
			                            #    5      4    *    *  son    Jeden Sonntag um 04:05:00
			                            #    0      1    1   12    1    Jeden 1. Dezember UND jeden Montag im Dezember jeweils um 01:00:00
			                        &lt;&#47;listing&gt;
			</p>
			
			@return der Wert von IntervallRestrukturierung.
			*/
				public String
				 getIntervallRestrukturierung() {
				return _intervallRestrukturierung;
			}
		
			/**
			Cron-String, der angibt, wann eine automatische Restrukturierung in der Konfiguration ausgeführt wird.
			<p>
			&lt;absatz&gt;
			                            Bei der Restrukturierung werden ungültige dynamische Objekte in eine effiziente Datenstruktur
			                            der Konfigurationsdatei (NgDyn-Block) verschoben, sodass weitere Zugriffe performant erfolgen können. Je nach
			                            Größe eines Konfigurationsbereichs, Leistung des Rechners und Dauer seit der letzten Restrukturierung kann
			                            eine Restrukturierung wenige Millisekunden bis wenige Sekunden dauern.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            In dieser Zeit ist eine Konfigurationsbereich für verschiedene Lese- und Schreiboperationen gesperrt.
			                            Da dadurch Konfigurationsanfragen für kurze Zeit blockiert werden können, sollte die Restrukturierung
			                            möglichst in Zeiten geringer Last durchgeführt werden.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Standardmäßig wird die Restrukturierung wöchentlich jeden Montag um 02:00 Nachts durchgeführt.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;Ein Cron-Eintrag besteht aus 5 Werten:&lt;&#47;absatz&gt;
			                        &lt;numListe typ="1"&gt;
			                            &lt;listenPunkt&gt;Minute (0-59)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Stunde (0-23)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Tag des Monats (1-31)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Monat (1-12 oder Monatsnamen)&lt;&#47;listenPunkt&gt;
			                            &lt;listenPunkt&gt;Tag der Woche (0-7, 0 und 7 sind Sonntag, oder Namen)&lt;&#47;listenPunkt&gt;
			                        &lt;&#47;numListe&gt;
			                        &lt;absatz&gt;
			                            Soll ein Wert ignoriert werden, sind Sternchen möglich. (Wildcard)
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Listen und Bereiche können ebenfalls angegeben werden mit "," und "-".
			                            Mit &#47; kann der Befehl alle x Intervalle ausgeführt werden.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Wochen und Monatsnamen sind in deutscher Sprache anzugeben und werden tolerant behandelt.
			                            Gültig für Sonntag ist beispielsweise "so", "son", "Sonntag", usw., Groß- und Kleinschreibung ist
			                            unerheblich.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;Beispiele:&lt;&#47;absatz&gt;
			                        &lt;listing&gt;
			                            #  Min    Std  Tag  Mon   WT
			                            #    5      0    *    *    *    Jeden Tag um 00:05:00
			                            #   15  14,20    1    *    *    Am 1. jeden Monats um 14:15:00 und um 20:15:00
			                            #    0     22    *    *  1-5    An jedem Werktag (Mo-Fr) um 22:00:00
			                            #   23    *&#47;2    *    *    *    Alle 2 Stunden um jeweils xx:23:00, also 00:23:00, 02:23:00, ...
			                            #    5      4    *    *  son    Jeden Sonntag um 04:05:00
			                            #    0      1    1   12    1    Jeden 1. Dezember UND jeden Montag im Dezember jeweils um 01:00:00
			                        &lt;&#47;listing&gt;
			</p>
			
			@param _intervallRestrukturierung der neue Wert von IntervallRestrukturierung.
			*/
			public void setIntervallRestrukturierung(String
			 _intervallRestrukturierung) {
				if (_intervallRestrukturierung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._intervallRestrukturierung = _intervallRestrukturierung;
			}
		
			/**
			Cron-String, der angibt, wann ermittelt werden soll, welche historischen dynamischen Objekte
			                        und Mengenreferenzen zu löschen sind.
			<p>
			&lt;absatz&gt;
			                            Die Konfiguration prüft periodisch, welche dynamischen Objekte alt genug sind um endgültig
			                            gelöscht zu werden. Objekte, die alt genug sind und nicht mehr von anderen gültigen Objekten referenziert
			                            werden (über Mengen oder Konfigurationsdaten), können permanent gelöscht werden. (Um Probleme bei
			                            laufenden Applikationen zu vermeiden, werden sie erst bei einem Neustart der Konfiguration wirklich gelöscht).
			                            Ebenfalls werden historische Mengenreferenzen gelöscht, die alt genug sind. Hier ist kein Neustart erforderlich.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Parallele Anfragen sind während der Ermittlung, welche Objekte gelöscht werden können, möglich.
			                            Dennoch führt dieser Vorgang ggf. zu einer gewissen Last und sollte daher in Zeiten durchgeführt werden, in
			                            denen die Konfiguration möglichst wenig anderweitig belastet wird.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Standardmäßig wird die Vorbereitung des endgültigen Löschens wöchentlich jeden Sonntag um 02:00 Nachts durchgeführt.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Zur Erklärung des Cron-Strings siehe Attribut 'intervallRestrukturierung'.
			                        &lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von IntervallLoeschen.
			*/
				public String
				 getIntervallLoeschen() {
				return _intervallLoeschen;
			}
		
			/**
			Cron-String, der angibt, wann ermittelt werden soll, welche historischen dynamischen Objekte
			                        und Mengenreferenzen zu löschen sind.
			<p>
			&lt;absatz&gt;
			                            Die Konfiguration prüft periodisch, welche dynamischen Objekte alt genug sind um endgültig
			                            gelöscht zu werden. Objekte, die alt genug sind und nicht mehr von anderen gültigen Objekten referenziert
			                            werden (über Mengen oder Konfigurationsdaten), können permanent gelöscht werden. (Um Probleme bei
			                            laufenden Applikationen zu vermeiden, werden sie erst bei einem Neustart der Konfiguration wirklich gelöscht).
			                            Ebenfalls werden historische Mengenreferenzen gelöscht, die alt genug sind. Hier ist kein Neustart erforderlich.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Parallele Anfragen sind während der Ermittlung, welche Objekte gelöscht werden können, möglich.
			                            Dennoch führt dieser Vorgang ggf. zu einer gewissen Last und sollte daher in Zeiten durchgeführt werden, in
			                            denen die Konfiguration möglichst wenig anderweitig belastet wird.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Standardmäßig wird die Vorbereitung des endgültigen Löschens wöchentlich jeden Sonntag um 02:00 Nachts durchgeführt.
			                        &lt;&#47;absatz&gt;
			                        &lt;absatz&gt;
			                            Zur Erklärung des Cron-Strings siehe Attribut 'intervallRestrukturierung'.
			                        &lt;&#47;absatz&gt;
			</p>
			
			@param _intervallLoeschen der neue Wert von IntervallLoeschen.
			*/
			public void setIntervallLoeschen(String
			 _intervallLoeschen) {
				if (_intervallLoeschen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._intervallLoeschen = _intervallLoeschen;
			}
		
			/**
			Zur Festlegung der Vorhaltezeiträume für ungültige dynamische Objekte je Typ.
			<p>
			
			</p>
			
			@return der Wert von DynamischeObjekte.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenObjekte
				> getDynamischeObjekte() {
				return _dynamischeObjekte;
			}
		
		
			/**
			Wie lange eine historische Mengenreferenz mindestens erhalten bleiben soll (Standardwert für Mengentypen,
			                        für die keine explizite Angabe erfolgt).
			<p>
			
			</p>
			
			@return der Wert von DynamischeMengenStandard.
			*/
				public Feld<	RelativerZeitstempel
				> getDynamischeMengenStandard() {
				return _dynamischeMengenStandard;
			}
		
		
			/**
			Zur Festlegung der Vorhaltezeiträume für historische Elemente von dynamischen Mengen.
			<p>
			
			</p>
			
			@return der Wert von DynamischeMengen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenMengen
				> getDynamischeMengen() {
				return _dynamischeMengen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getIntervallRestrukturierung() != null) {
						datum.getTextValue("IntervallRestrukturierung").setText(getIntervallRestrukturierung());
					}
					// ZeichenkettenAttributTyp
					if (getIntervallLoeschen() != null) {
						datum.getTextValue("IntervallLöschen").setText(getIntervallLoeschen());
					}
					// AttributListenDefinition
						final Data.Array arrayDynamischeObjekte = datum.getArray("DynamischeObjekte");
						arrayDynamischeObjekte.setLength(getDynamischeObjekte().size());
						for (int i = 0; i < arrayDynamischeObjekte.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenObjekte
							 atl = getDynamischeObjekte().get(i);
							atl.bean2Atl(arrayDynamischeObjekte.getItem(i), factory);
		
						}
					// ZeitstempelAttributTyp
						final Data.TimeArray arrayDynamischeMengenStandard = datum.getTimeArray("DynamischeMengenStandard");
						arrayDynamischeMengenStandard.setLength(getDynamischeMengenStandard().size());
						for (int i = 0; i < arrayDynamischeMengenStandard.getLength(); ++i) {
							arrayDynamischeMengenStandard.getTimeValue(i).setMillis(getDynamischeMengenStandard().get(i).getTime());
						}
					// AttributListenDefinition
						final Data.Array arrayDynamischeMengen = datum.getArray("DynamischeMengen");
						arrayDynamischeMengen.setLength(getDynamischeMengen().size());
						for (int i = 0; i < arrayDynamischeMengen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenMengen
							 atl = getDynamischeMengen().get(i);
							atl.bean2Atl(arrayDynamischeMengen.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setIntervallRestrukturierung(daten.getTextValue("IntervallRestrukturierung").getText());
					// ZeichenkettenAttributTyp
						setIntervallLoeschen(daten.getTextValue("IntervallLöschen").getText());
					// AttributListenDefinition
						final Data.Array arrayDynamischeObjekte = daten.getArray("DynamischeObjekte");
						for (int i = 0; i < arrayDynamischeObjekte.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenObjekte
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenObjekte
							 ();
							atl.atl2Bean(arrayDynamischeObjekte.getItem(i), factory);
							getDynamischeObjekte().add(atl);
						}
					// ZeitstempelAttributTyp
						final Data.Array arrayDynamischeMengenStandard = daten.getArray("DynamischeMengenStandard");
						for (int i = 0; i < arrayDynamischeMengenStandard.getLength(); ++i) {
								RelativerZeitstempel
							 atl = new 	RelativerZeitstempel
							 (arrayDynamischeMengenStandard.getItem(i).asTimeValue().getMillis());
							getDynamischeMengenStandard().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayDynamischeMengen = daten.getArray("DynamischeMengen");
						for (int i = 0; i < arrayDynamischeMengen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenMengen
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute.AtlParameterEndgueltigesLoeschenMengen
							 ();
							atl.atl2Bean(arrayDynamischeMengen.getItem(i), factory);
							getDynamischeMengen().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setIntervallRestrukturierung(getIntervallRestrukturierung());
							klon.setIntervallLoeschen(getIntervallLoeschen());
						klon._dynamischeObjekte = getDynamischeObjekte().clone();
						klon._dynamischeMengenStandard = getDynamischeMengenStandard().clone();
						klon._dynamischeMengen = getDynamischeMengen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.parameterEndgültigesLöschen";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdParameterEndgueltigesLoeschen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
