/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste zur Beschreibung einer Aktivität.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 27
 */
public class AtlAktivitaetDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _konfigurationsbereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> _attributgruppe = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> _aspekt = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			>(0, true);
			@Defaultwert(wert = "KeineAussage")
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 _empfaenger
			;
			@Defaultwert(wert = "KeineAussage")
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 _sender
			;
			@Defaultwert(wert = "KeineAussage")
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 _quelle
			;
			@Defaultwert(wert = "KeineAussage")
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 _senke
			;
	
		/**
		Beschreibender Name dieser Aktivität.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Beschreibender Name dieser Aktivität.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Angabe von Konfigurationsbereichen, die die Auswahl der Attributgruppen filtern.
								Wenn hier ein oder mehrere Konfigurationsbereiche vorgegeben werden,
								wird damit die Auswahl der Attributgruppen beschränkt.
								Damit ist es leicht möglich, alle Attributgruppen eines Modells auszuwählen (Wildcard bei Attributgruppe und Aspekt).
								Die Aspekte werden durch die Vorgabe von Konfigurationsbereichen nicht gefiltert, da Aspekte häufig in anderen KB definiert sind.
		´.
		<p>
		
		</p>
		
		@return der Wert von Konfigurationsbereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getKonfigurationsbereich() {
			return _konfigurationsbereich;
		}
	
	
		/**
		Array von Attributgruppen. Wenn dieses Array leer ist, sind alle Attributgruppen
		                        ausgewählt.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppe.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			> getAttributgruppe() {
			return _attributgruppe;
		}
	
	
		/**
		Array von Aspekten. Wenn dieses Array leer ist, sind alle Attributgruppen ausgewählt.
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			> getAspekt() {
			return _aspekt;
		}
	
	
		/**
		Gibt an, ob die Daten mit diesen Rechte empfangen (gelesen) werden dürfen.
		<p>
		
		</p>
		
		@return der Wert von Empfaenger.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 getEmpfaenger() {
			return _empfaenger;
		}
	
		/**
		Gibt an, ob die Daten mit diesen Rechte empfangen (gelesen) werden dürfen.
		<p>
		
		</p>
		
		@param _empfaenger der neue Wert von Empfaenger.
		*/
		public void setEmpfaenger(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
		 _empfaenger) {
			this._empfaenger = _empfaenger;
		}
	
		/**
		Gibt an, ob die Daten mit diesen Rechte gesendet (geschrieben) werden dürfen.
		<p>
		
		</p>
		
		@return der Wert von Sender.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 getSender() {
			return _sender;
		}
	
		/**
		Gibt an, ob die Daten mit diesen Rechte gesendet (geschrieben) werden dürfen.
		<p>
		
		</p>
		
		@param _sender der neue Wert von Sender.
		*/
		public void setSender(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
		 _sender) {
			this._sender = _sender;
		}
	
		/**
		Gibt an, ob die Daten mit diesen Rechte als Quelle angemeldet werden dürfen.
		<p>
		
		</p>
		
		@return der Wert von Quelle.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 getQuelle() {
			return _quelle;
		}
	
		/**
		Gibt an, ob die Daten mit diesen Rechte als Quelle angemeldet werden dürfen.
		<p>
		
		</p>
		
		@param _quelle der neue Wert von Quelle.
		*/
		public void setQuelle(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
		 _quelle) {
			this._quelle = _quelle;
		}
	
		/**
		Gibt an, ob die Daten mit diesen Rechte als Senke angemeldet werden dürfen.
		<p>
		
		</p>
		
		@return der Wert von Senke.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
			 getSenke() {
			return _senke;
		}
	
		/**
		Gibt an, ob die Daten mit diesen Rechte als Senke angemeldet werden dürfen.
		<p>
		
		</p>
		
		@param _senke der neue Wert von Senke.
		*/
		public void setSenke(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
		 _senke) {
			this._senke = _senke;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = datum.getReferenceArray("Konfigurationsbereich");
					arrayKonfigurationsbereich.setLength(getKonfigurationsbereich().size());
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final Object soKonfigurationsbereich = getKonfigurationsbereich().get(i);
						final SystemObject tmpKonfigurationsbereich;
						if (soKonfigurationsbereich instanceof SystemObject) {
							tmpKonfigurationsbereich = (SystemObject)soKonfigurationsbereich;
						} else if(soKonfigurationsbereich instanceof SystemObjekt){
							tmpKonfigurationsbereich = ((SystemObjekt)soKonfigurationsbereich).getSystemObject();
						} else{
							tmpKonfigurationsbereich = null;
						}
						arrayKonfigurationsbereich.getReferenceValue(i).setSystemObject(tmpKonfigurationsbereich);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributgruppe = datum.getReferenceArray("Attributgruppe");
					arrayAttributgruppe.setLength(getAttributgruppe().size());
					for (int i = 0; i < arrayAttributgruppe.getLength(); ++i) {
						final Object soAttributgruppe = getAttributgruppe().get(i);
						final SystemObject tmpAttributgruppe;
						if (soAttributgruppe instanceof SystemObject) {
							tmpAttributgruppe = (SystemObject)soAttributgruppe;
						} else if(soAttributgruppe instanceof SystemObjekt){
							tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
						} else{
							tmpAttributgruppe = null;
						}
						arrayAttributgruppe.getReferenceValue(i).setSystemObject(tmpAttributgruppe);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAspekt = datum.getReferenceArray("Aspekt");
					arrayAspekt.setLength(getAspekt().size());
					for (int i = 0; i < arrayAspekt.getLength(); ++i) {
						final Object soAspekt = getAspekt().get(i);
						final SystemObject tmpAspekt;
						if (soAspekt instanceof SystemObject) {
							tmpAspekt = (SystemObject)soAspekt;
						} else if(soAspekt instanceof SystemObjekt){
							tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
						} else{
							tmpAspekt = null;
						}
						arrayAspekt.getReferenceValue(i).setSystemObject(tmpAspekt);
					}
				// GanzzahlAttributTyp
				if (getEmpfaenger() != null) {
	                if (getEmpfaenger().isZustand()) {
	                    datum.getUnscaledValue("Empfänger").setText(getEmpfaenger().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Empfänger").set(getEmpfaenger().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSender() != null) {
	                if (getSender().isZustand()) {
	                    datum.getUnscaledValue("Sender").setText(getSender().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Sender").set(getSender().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getQuelle() != null) {
	                if (getQuelle().isZustand()) {
	                    datum.getUnscaledValue("Quelle").setText(getQuelle().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Quelle").set(getQuelle().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSenke() != null) {
	                if (getSenke().isZustand()) {
	                    datum.getUnscaledValue("Senke").setText(getSenke().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Senke").set(getSenke().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich");
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final long idKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich").getReferenceValue(i).getId();
						final SystemObjekt tmpKonfigurationsbereich;
						if (idKonfigurationsbereich == 0) {
							tmpKonfigurationsbereich = null;
						} else {
							final SystemObject soKonfigurationsbereich = factory.getDav().getDataModel().getObject(idKonfigurationsbereich);
							if (soKonfigurationsbereich == null) {
									tmpKonfigurationsbereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idKonfigurationsbereich);
							} else {
								tmpKonfigurationsbereich = factory.getModellobjekt(soKonfigurationsbereich);
							}
						}
							getKonfigurationsbereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpKonfigurationsbereich);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAttributgruppe = daten.getReferenceArray("Attributgruppe");
					for (int i = 0; i < arrayAttributgruppe.getLength(); ++i) {
						final long idAttributgruppe = daten.getReferenceArray("Attributgruppe").getReferenceValue(i).getId();
						final SystemObjekt tmpAttributgruppe;
						if (idAttributgruppe == 0) {
							tmpAttributgruppe = null;
						} else {
							final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
							if (soAttributgruppe == null) {
									tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
							} else {
								tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
							}
						}
							getAttributgruppe().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
							) tmpAttributgruppe);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAspekt = daten.getReferenceArray("Aspekt");
					for (int i = 0; i < arrayAspekt.getLength(); ++i) {
						final long idAspekt = daten.getReferenceArray("Aspekt").getReferenceValue(i).getId();
						final SystemObjekt tmpAspekt;
						if (idAspekt == 0) {
							tmpAspekt = null;
						} else {
							final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
							if (soAspekt == null) {
									tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
							} else {
								tmpAspekt = factory.getModellobjekt(soAspekt);
							}
						}
							getAspekt().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
							) tmpAspekt);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Empfänger").isState()) {
							setEmpfaenger(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
							.getZustand(daten.getScaledValue("Empfänger").getText()));
						} else {
						setEmpfaenger(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
						(daten.
							getUnscaledValue
						("Empfänger").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Sender").isState()) {
							setSender(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
							.getZustand(daten.getScaledValue("Sender").getText()));
						} else {
						setSender(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
						(daten.
							getUnscaledValue
						("Sender").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Quelle").isState()) {
							setQuelle(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
							.getZustand(daten.getScaledValue("Quelle").getText()));
						} else {
						setQuelle(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
						(daten.
							getUnscaledValue
						("Quelle").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Senke").isState()) {
							setSenke(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
							.getZustand(daten.getScaledValue("Senke").getText()));
						} else {
						setSenke(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttJaNeinKeineAussage
						(daten.
							getUnscaledValue
						("Senke").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAktivitaetDaten clone() {
		AtlAktivitaetDaten klon = new AtlAktivitaetDaten();
		
						klon.setName(getName());
					klon._konfigurationsbereich = getKonfigurationsbereich().clone();
					klon._attributgruppe = getAttributgruppe().clone();
					klon._aspekt = getAspekt().clone();
						klon.setEmpfaenger(getEmpfaenger());
						klon.setSender(getSender());
						klon.setQuelle(getQuelle());
						klon.setSenke(getSenke());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
