/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste zur Beschreibung, welche Objekte neu angelegt, geändert oder gelöscht werden dürfen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 29
 */
public class AtlAktivitaetObjekteNeu implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> _objekttyp = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _konfigurationsbereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			@Defaultwert(wert = "Ja")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _objekteErzeugenAendernLoeschen
			;
	
		/**
		Objekttypen, die hier betrachtet werden sollen.
		                        Wenn das Array leer ist, sind alle Objekttypen gemeint.
		<p>
		
		</p>
		
		@return der Wert von Objekttyp.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> getObjekttyp() {
			return _objekttyp;
		}
	
	
		/**
		Konfigurationsbereiche, in denen Objekte neu erzeugt, geändert oder gelöscht werden dürfen.
		                        Wenn das Array leer ist, dürfen in allen möglichen Konfigurationsbereichen
		                        (grundsätzlich dürfen nur KB geändert werden, für die die entsprechende Konfiguration auch Konfigutationsverantworlicher ist)
		                         Objekt erzeugt werden.
		<p>
		
		</p>
		
		@return der Wert von Konfigurationsbereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getKonfigurationsbereich() {
			return _konfigurationsbereich;
		}
	
	
		/**
		Gibt an, ob zu den spezifizierten Objekttypen, Objekte erzeugt, geändert oder gelöscht werden dürfen.
		<p>
		
		</p>
		
		@return der Wert von ObjekteErzeugenAendernLoeschen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getObjekteErzeugenAendernLoeschen() {
			return _objekteErzeugenAendernLoeschen;
		}
	
		/**
		Gibt an, ob zu den spezifizierten Objekttypen, Objekte erzeugt, geändert oder gelöscht werden dürfen.
		<p>
		
		</p>
		
		@param _objekteErzeugenAendernLoeschen der neue Wert von ObjekteErzeugenAendernLoeschen.
		*/
		public void setObjekteErzeugenAendernLoeschen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _objekteErzeugenAendernLoeschen) {
			this._objekteErzeugenAendernLoeschen = _objekteErzeugenAendernLoeschen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekttyp = datum.getReferenceArray("Objekttyp");
					arrayObjekttyp.setLength(getObjekttyp().size());
					for (int i = 0; i < arrayObjekttyp.getLength(); ++i) {
						final Object soObjekttyp = getObjekttyp().get(i);
						final SystemObject tmpObjekttyp;
						if (soObjekttyp instanceof SystemObject) {
							tmpObjekttyp = (SystemObject)soObjekttyp;
						} else if(soObjekttyp instanceof SystemObjekt){
							tmpObjekttyp = ((SystemObjekt)soObjekttyp).getSystemObject();
						} else{
							tmpObjekttyp = null;
						}
						arrayObjekttyp.getReferenceValue(i).setSystemObject(tmpObjekttyp);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = datum.getReferenceArray("Konfigurationsbereich");
					arrayKonfigurationsbereich.setLength(getKonfigurationsbereich().size());
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final Object soKonfigurationsbereich = getKonfigurationsbereich().get(i);
						final SystemObject tmpKonfigurationsbereich;
						if (soKonfigurationsbereich instanceof SystemObject) {
							tmpKonfigurationsbereich = (SystemObject)soKonfigurationsbereich;
						} else if(soKonfigurationsbereich instanceof SystemObjekt){
							tmpKonfigurationsbereich = ((SystemObjekt)soKonfigurationsbereich).getSystemObject();
						} else{
							tmpKonfigurationsbereich = null;
						}
						arrayKonfigurationsbereich.getReferenceValue(i).setSystemObject(tmpKonfigurationsbereich);
					}
				// GanzzahlAttributTyp
				if (getObjekteErzeugenAendernLoeschen() != null) {
	                if (getObjekteErzeugenAendernLoeschen().isZustand()) {
	                    datum.getUnscaledValue("ObjekteErzeugenÄndernLöschen").setText(getObjekteErzeugenAendernLoeschen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ObjekteErzeugenÄndernLöschen").set(getObjekteErzeugenAendernLoeschen().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekttyp = daten.getReferenceArray("Objekttyp");
					for (int i = 0; i < arrayObjekttyp.getLength(); ++i) {
						final long idObjekttyp = daten.getReferenceArray("Objekttyp").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekttyp;
						if (idObjekttyp == 0) {
							tmpObjekttyp = null;
						} else {
							final SystemObject soObjekttyp = factory.getDav().getDataModel().getObject(idObjekttyp);
							if (soObjekttyp == null) {
									tmpObjekttyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idObjekttyp);
							} else {
								tmpObjekttyp = factory.getModellobjekt(soObjekttyp);
							}
						}
							getObjekttyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
							) tmpObjekttyp);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich");
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final long idKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich").getReferenceValue(i).getId();
						final SystemObjekt tmpKonfigurationsbereich;
						if (idKonfigurationsbereich == 0) {
							tmpKonfigurationsbereich = null;
						} else {
							final SystemObject soKonfigurationsbereich = factory.getDav().getDataModel().getObject(idKonfigurationsbereich);
							if (soKonfigurationsbereich == null) {
									tmpKonfigurationsbereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idKonfigurationsbereich);
							} else {
								tmpKonfigurationsbereich = factory.getModellobjekt(soKonfigurationsbereich);
							}
						}
							getKonfigurationsbereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpKonfigurationsbereich);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ObjekteErzeugenÄndernLöschen").isState()) {
							setObjekteErzeugenAendernLoeschen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("ObjekteErzeugenÄndernLöschen").getText()));
						} else {
						setObjekteErzeugenAendernLoeschen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("ObjekteErzeugenÄndernLöschen").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAktivitaetObjekteNeu clone() {
		AtlAktivitaetObjekteNeu klon = new AtlAktivitaetObjekteNeu();
		
					klon._objekttyp = getObjekttyp().clone();
					klon._konfigurationsbereich = getKonfigurationsbereich().clone();
						klon.setObjekteErzeugenAendernLoeschen(getObjekteErzeugenAendernLoeschen());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
