/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält jeweils die Referenz auf eine verbundene Applikation, den Benutzer der Applikation, Zeitpunkt der Anmeldung der
					Applikation(fest) und die aktuelle Größe des Sendepuffers der Applikation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AtlAngemeldeteApplikation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 _applikation
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _benutzer
			;
			private 	Zeitstempel
			 _seit
			;
			private String
			 _sendepufferzustand
			= new String
			()
			;
	
		/**
		Referenz auf die angemeldete
								&lt;verweis pid="typ.applikation" txt="Applikation"&gt;&lt;&#47;verweis&gt;
								.
		<p>
		
		</p>
		
		@return der Wert von Applikation.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
			 getApplikation() {
			return _applikation;
		}
	
		/**
		Referenz auf die angemeldete
								&lt;verweis pid="typ.applikation" txt="Applikation"&gt;&lt;&#47;verweis&gt;
								.
		<p>
		
		</p>
		
		@param _applikation der neue Wert von Applikation.
		*/
		public void setApplikation(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
		 _applikation) {
			this._applikation = _applikation;
		}
	
		/**
		Referenz auf den Benutzer, der die Applikation angemeldet hat.
		<p>
		
		</p>
		
		@return der Wert von Benutzer.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 getBenutzer() {
			return _benutzer;
		}
	
		/**
		Referenz auf den Benutzer, der die Applikation angemeldet hat.
		<p>
		
		</p>
		
		@param _benutzer der neue Wert von Benutzer.
		*/
		public void setBenutzer(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
		 _benutzer) {
			this._benutzer = _benutzer;
		}
	
		/**
		Zeitpunkt, seit dem die Applikation angemeledet ist.
		<p>
		
		</p>
		
		@return der Wert von Seit.
		*/
			public 	Zeitstempel
			 getSeit() {
			return _seit;
		}
	
		/**
		Zeitpunkt, seit dem die Applikation angemeledet ist.
		<p>
		
		</p>
		
		@param _seit der neue Wert von Seit.
		*/
		public void setSeit(	Zeitstempel
		 _seit) {
			this._seit = _seit;
		}
	
		/**
		Anzahl zu versendener Bytes und Zustand der Durchsatzprüfung falls aktiviert mit zuletzt gemessenem Durchsatz (Bytes pro Sekunde).
		<p>
		
		</p>
		
		@return der Wert von Sendepufferzustand.
		*/
			public String
			 getSendepufferzustand() {
			return _sendepufferzustand;
		}
	
		/**
		Anzahl zu versendener Bytes und Zustand der Durchsatzprüfung falls aktiviert mit zuletzt gemessenem Durchsatz (Bytes pro Sekunde).
		<p>
		
		</p>
		
		@param _sendepufferzustand der neue Wert von Sendepufferzustand.
		*/
		public void setSendepufferzustand(String
		 _sendepufferzustand) {
			if (_sendepufferzustand.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._sendepufferzustand = _sendepufferzustand;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soApplikation = getApplikation();
					final SystemObject tmpApplikation;
						if (soApplikation instanceof SystemObject) {
							tmpApplikation = (SystemObject)soApplikation;
						} else if(soApplikation instanceof SystemObjekt){
							tmpApplikation = ((SystemObjekt)soApplikation).getSystemObject();
						} else{
							tmpApplikation = null;
						}
					datum.getReferenceValue("applikation").setSystemObject(tmpApplikation);
				// ObjektReferenzAttributTyp
					final Object soBenutzer = getBenutzer();
					final SystemObject tmpBenutzer;
						if (soBenutzer instanceof SystemObject) {
							tmpBenutzer = (SystemObject)soBenutzer;
						} else if(soBenutzer instanceof SystemObjekt){
							tmpBenutzer = ((SystemObjekt)soBenutzer).getSystemObject();
						} else{
							tmpBenutzer = null;
						}
					datum.getReferenceValue("benutzer").setSystemObject(tmpBenutzer);
				// ZeitstempelAttributTyp
					datum.getTimeValue("seit").setMillis(getSeit().getTime());
				// ZeichenkettenAttributTyp
				if (getSendepufferzustand() != null) {
					datum.getTextValue("sendepufferzustand").setText(getSendepufferzustand());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idApplikation = daten.getReferenceValue("applikation").getId();
					final SystemObjekt tmpApplikation;
					if (idApplikation == 0) {
						tmpApplikation = null;
					} else {
						final SystemObject soApplikation = factory.getDav().getDataModel().getObject(idApplikation);
						if (soApplikation == null) {
								tmpApplikation = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idApplikation);
						} else {
							tmpApplikation = factory.getModellobjekt(soApplikation);
						}
					}
					setApplikation((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
					) tmpApplikation);
				// ObjektReferenzAttributTyp
					final long idBenutzer = daten.getReferenceValue("benutzer").getId();
					final SystemObjekt tmpBenutzer;
					if (idBenutzer == 0) {
						tmpBenutzer = null;
					} else {
						final SystemObject soBenutzer = factory.getDav().getDataModel().getObject(idBenutzer);
						if (soBenutzer == null) {
								tmpBenutzer = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idBenutzer);
						} else {
							tmpBenutzer = factory.getModellobjekt(soBenutzer);
						}
					}
					setBenutzer((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
					) tmpBenutzer);
				// ZeitstempelAttributTyp
					setSeit(new
						Zeitstempel
						(daten.getTimeValue("seit").getMillis()));
				// ZeichenkettenAttributTyp
					setSendepufferzustand(daten.getTextValue("sendepufferzustand").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAngemeldeteApplikation clone() {
		AtlAngemeldeteApplikation klon = new AtlAngemeldeteApplikation();
		
						klon.setApplikation(getApplikation());
						klon.setBenutzer(getBenutzer());
						klon.setSeit(getSeit());
						klon.setSendepufferzustand(getSendepufferzustand());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
