/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter (Anzahl der Archivdatensätze, Containergröße in Byte und die Zeitspanne der Container), die angeben, wann ein
					Container des Archivsystems abzuschließen ist.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlContainerAbschlussParameter implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussStandard
			 _standardeinstellung
			= new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussStandard
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussAusnahmen
			> _ausnahmen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussAusnahmen
			>(0, true);
	
		/**
		Enthält die Parameter (Anzahl der Archivdatensätze, Containergröße in Byte und die Zeitspanne der Container), die angeben, wann ein
							Container des Archivsystems abzuschließen ist.
		<p>
		
		</p>
		
		@return der Wert von Standardeinstellung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussStandard
			 getStandardeinstellung() {
			return _standardeinstellung;
		}
	
		/**
		Enthält die Parameter (Anzahl der Archivdatensätze, Containergröße in Byte und die Zeitspanne der Container), die angeben, wann ein
							Container des Archivsystems abzuschließen ist.
		<p>
		
		</p>
		
		@param _standardeinstellung der neue Wert von Standardeinstellung.
		*/
		public void setStandardeinstellung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussStandard
		 _standardeinstellung) {
			this._standardeinstellung = _standardeinstellung;
		}
	
		/**
		Enthält die Parameter (Anzahl der Archivdatensätze, Containergröße in Byte und die Zeitspanne der Container) für die ausgewählten
							Attributgruppen, die angeben, wann ein Container des Archivsystems abzuschließen ist.
		<p>
		
		</p>
		
		@return der Wert von Ausnahmen.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussAusnahmen
			> getAusnahmen() {
			return _ausnahmen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getStandardeinstellung().bean2Atl(datum.getItem("Standardeinstellung"), factory);
				// AttributListenDefinition
					final Data.Array arrayAusnahmen = datum.getArray("Ausnahmen");
					arrayAusnahmen.setLength(getAusnahmen().size());
					for (int i = 0; i < arrayAusnahmen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussAusnahmen
						 atl = getAusnahmen().get(i);
						atl.bean2Atl(arrayAusnahmen.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getStandardeinstellung().atl2Bean(daten.getItem("Standardeinstellung"), factory);
				// AttributListenDefinition
					final Data.Array arrayAusnahmen = daten.getArray("Ausnahmen");
					for (int i = 0; i < arrayAusnahmen.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussAusnahmen
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlContainerAbschlussAusnahmen
						 ();
						atl.atl2Bean(arrayAusnahmen.getItem(i), factory);
						getAusnahmen().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlContainerAbschlussParameter clone() {
		AtlContainerAbschlussParameter klon = new AtlContainerAbschlussParameter();
		
						klon._standardeinstellung = getStandardeinstellung().clone();
					klon._ausnahmen = getAusnahmen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
