/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommunikationszustand einer Datenverteilerverbindung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 36
 */
public class AtlDatenverteilerKommunikationsZustand implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
			 _datenverteiler
			;
			private String
			 _adresse
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDatenverteilerKommunikationsZustand
			 _zustand
			;
			private String
			 _meldung
			= new String
			()
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.datenverteiler (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@return der Wert von Datenverteiler.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
			 getDatenverteiler() {
			return _datenverteiler;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.datenverteiler (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@param _datenverteiler der neue Wert von Datenverteiler.
		*/
		public void setDatenverteiler(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
		 _datenverteiler) {
			this._datenverteiler = _datenverteiler;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Adresse.
		*/
			public String
			 getAdresse() {
			return _adresse;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _adresse der neue Wert von Adresse.
		*/
		public void setAdresse(String
		 _adresse) {
			if (_adresse.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._adresse = _adresse;
		}
	
		/**
		Kommunikationszustand der Kommunikation mit einem anderen Datenverteiler.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDatenverteilerKommunikationsZustand
			 getZustand() {
			return _zustand;
		}
	
		/**
		Kommunikationszustand der Kommunikation mit einem anderen Datenverteiler.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDatenverteilerKommunikationsZustand
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Meldung.
		*/
			public String
			 getMeldung() {
			return _meldung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _meldung der neue Wert von Meldung.
		*/
		public void setMeldung(String
		 _meldung) {
			if (_meldung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._meldung = _meldung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soDatenverteiler = getDatenverteiler();
					final SystemObject tmpDatenverteiler;
						if (soDatenverteiler instanceof SystemObject) {
							tmpDatenverteiler = (SystemObject)soDatenverteiler;
						} else if(soDatenverteiler instanceof SystemObjekt){
							tmpDatenverteiler = ((SystemObjekt)soDatenverteiler).getSystemObject();
						} else{
							tmpDatenverteiler = null;
						}
					datum.getReferenceValue("Datenverteiler").setSystemObject(tmpDatenverteiler);
				// ZeichenkettenAttributTyp
				if (getAdresse() != null) {
					datum.getTextValue("Adresse").setText(getAdresse());
				}
				// GanzzahlAttributTyp
				if (getZustand() != null) {
	                if (getZustand().isZustand()) {
	                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zustand").set(getZustand().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getMeldung() != null) {
					datum.getTextValue("Meldung").setText(getMeldung());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idDatenverteiler = daten.getReferenceValue("Datenverteiler").getId();
					final SystemObjekt tmpDatenverteiler;
					if (idDatenverteiler == 0) {
						tmpDatenverteiler = null;
					} else {
						final SystemObject soDatenverteiler = factory.getDav().getDataModel().getObject(idDatenverteiler);
						if (soDatenverteiler == null) {
								tmpDatenverteiler = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.DatenverteilerUngueltig(idDatenverteiler);
						} else {
							tmpDatenverteiler = factory.getModellobjekt(soDatenverteiler);
						}
					}
					setDatenverteiler((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
					) tmpDatenverteiler);
				// ZeichenkettenAttributTyp
					setAdresse(daten.getTextValue("Adresse").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zustand").isState()) {
							setZustand(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDatenverteilerKommunikationsZustand
							.getZustand(daten.getScaledValue("Zustand").getText()));
						} else {
						setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttDatenverteilerKommunikationsZustand
						(daten.
							getUnscaledValue
						("Zustand").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setMeldung(daten.getTextValue("Meldung").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDatenverteilerKommunikationsZustand clone() {
		AtlDatenverteilerKommunikationsZustand klon = new AtlDatenverteilerKommunikationsZustand();
		
						klon.setDatenverteiler(getDatenverteiler());
						klon.setAdresse(getAdresse());
						klon.setZustand(getZustand());
						klon.setMeldung(getMeldung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
