/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste, mit der eine Datenverteilerverbindung deaktiviert werden kann.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 36
 */
public class AtlDeaktivierteVerbindung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
			 _remoteDatenverteiler
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _verbindungTrennen
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.datenverteiler (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@return der Wert von RemoteDatenverteiler.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
			 getRemoteDatenverteiler() {
			return _remoteDatenverteiler;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.datenverteiler (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@param _remoteDatenverteiler der neue Wert von RemoteDatenverteiler.
		*/
		public void setRemoteDatenverteiler(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
		 _remoteDatenverteiler) {
			this._remoteDatenverteiler = _remoteDatenverteiler;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von VerbindungTrennen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getVerbindungTrennen() {
			return _verbindungTrennen;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _verbindungTrennen der neue Wert von VerbindungTrennen.
		*/
		public void setVerbindungTrennen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _verbindungTrennen) {
			this._verbindungTrennen = _verbindungTrennen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soRemoteDatenverteiler = getRemoteDatenverteiler();
					final SystemObject tmpRemoteDatenverteiler;
						if (soRemoteDatenverteiler instanceof SystemObject) {
							tmpRemoteDatenverteiler = (SystemObject)soRemoteDatenverteiler;
						} else if(soRemoteDatenverteiler instanceof SystemObjekt){
							tmpRemoteDatenverteiler = ((SystemObjekt)soRemoteDatenverteiler).getSystemObject();
						} else{
							tmpRemoteDatenverteiler = null;
						}
					datum.getReferenceValue("RemoteDatenverteiler").setSystemObject(tmpRemoteDatenverteiler);
				// GanzzahlAttributTyp
				if (getVerbindungTrennen() != null) {
	                if (getVerbindungTrennen().isZustand()) {
	                    datum.getUnscaledValue("VerbindungTrennen").setText(getVerbindungTrennen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VerbindungTrennen").set(getVerbindungTrennen().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idRemoteDatenverteiler = daten.getReferenceValue("RemoteDatenverteiler").getId();
					final SystemObjekt tmpRemoteDatenverteiler;
					if (idRemoteDatenverteiler == 0) {
						tmpRemoteDatenverteiler = null;
					} else {
						final SystemObject soRemoteDatenverteiler = factory.getDav().getDataModel().getObject(idRemoteDatenverteiler);
						if (soRemoteDatenverteiler == null) {
								tmpRemoteDatenverteiler = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.DatenverteilerUngueltig(idRemoteDatenverteiler);
						} else {
							tmpRemoteDatenverteiler = factory.getModellobjekt(soRemoteDatenverteiler);
						}
					}
					setRemoteDatenverteiler((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
					) tmpRemoteDatenverteiler);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VerbindungTrennen").isState()) {
							setVerbindungTrennen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("VerbindungTrennen").getText()));
						} else {
						setVerbindungTrennen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("VerbindungTrennen").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDeaktivierteVerbindung clone() {
		AtlDeaktivierteVerbindung klon = new AtlDeaktivierteVerbindung();
		
						klon.setRemoteDatenverteiler(getRemoteDatenverteiler());
						klon.setVerbindungTrennen(getVerbindungTrennen());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
