/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein Objekt der HierarchieDefinition.
<p>
Ein Hierarchieobjekt wird beschrieben durch den Typ des Objekts, den Namen der Menge in der sich die Nachfolgerobjekte befinden
					und den Typ der Nachfolgerobjekte.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class AtlHierarchieObjekt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _objektTyp
			= new String
			()
			;
			private String
			 _menge
			= new String
			()
			;
			private String
			 _nachfolgerTyp
			= new String
			()
			;
	
		/**
		Attribut zur Speicherung der permanenten ID eines Objekts.
		<p>
		
		</p>
		
		@return der Wert von ObjektTyp.
		*/
			public String
			 getObjektTyp() {
			return _objektTyp;
		}
	
		/**
		Attribut zur Speicherung der permanenten ID eines Objekts.
		<p>
		
		</p>
		
		@param _objektTyp der neue Wert von ObjektTyp.
		*/
		public void setObjektTyp(String
		 _objektTyp) {
			if (_objektTyp.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._objektTyp = _objektTyp;
		}
	
		/**
		Attribut zur Speicherung des Namens eines Objekts.
		<p>
		
		</p>
		
		@return der Wert von Menge.
		*/
			public String
			 getMenge() {
			return _menge;
		}
	
		/**
		Attribut zur Speicherung des Namens eines Objekts.
		<p>
		
		</p>
		
		@param _menge der neue Wert von Menge.
		*/
		public void setMenge(String
		 _menge) {
			if (_menge.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._menge = _menge;
		}
	
		/**
		Attribut zur Speicherung der permanenten ID eines Objekts.
		<p>
		
		</p>
		
		@return der Wert von NachfolgerTyp.
		*/
			public String
			 getNachfolgerTyp() {
			return _nachfolgerTyp;
		}
	
		/**
		Attribut zur Speicherung der permanenten ID eines Objekts.
		<p>
		
		</p>
		
		@param _nachfolgerTyp der neue Wert von NachfolgerTyp.
		*/
		public void setNachfolgerTyp(String
		 _nachfolgerTyp) {
			if (_nachfolgerTyp.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._nachfolgerTyp = _nachfolgerTyp;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getObjektTyp() != null) {
					datum.getTextValue("ObjektTyp").setText(getObjektTyp());
				}
				// ZeichenkettenAttributTyp
				if (getMenge() != null) {
					datum.getTextValue("Menge").setText(getMenge());
				}
				// ZeichenkettenAttributTyp
				if (getNachfolgerTyp() != null) {
					datum.getTextValue("NachfolgerTyp").setText(getNachfolgerTyp());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setObjektTyp(daten.getTextValue("ObjektTyp").getText());
				// ZeichenkettenAttributTyp
					setMenge(daten.getTextValue("Menge").getText());
				// ZeichenkettenAttributTyp
					setNachfolgerTyp(daten.getTextValue("NachfolgerTyp").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlHierarchieObjekt clone() {
		AtlHierarchieObjekt klon = new AtlHierarchieObjekt();
		
						klon.setObjektTyp(getObjektTyp());
						klon.setMenge(getMenge());
						klon.setNachfolgerTyp(getNachfolgerTyp());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
