/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit denen das
					endgültige Löschen parametriert wird.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 38
 */
public class AtlParameterSatzArchivLoeschen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _bereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
			> _datenSpezifikation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
			>(0, true);
			@Defaultwert(wert = "1000 Tage")
			private 	RelativerZeitstempel
			 _zusaetzlicheVorhaltezeit
			;
	
		/**
		Die in der folgenden Attributliste "Datenspezifikation" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
								Konfigurationsbereich (Kein Eintrag: Alle Konfigurationsbereiche).
		<p>
		
		</p>
		
		@return der Wert von Bereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getBereich() {
			return _bereich;
		}
	
	
		/**
		Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
							folgenden Einstellungen gelten.
		<p>
		
		</p>
		
		@return der Wert von DatenSpezifikation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
			> getDatenSpezifikation() {
			return _datenSpezifikation;
		}
	
	
		/**
		Dieses Attribut gibt an, wie lange die Daten bzw. die Metainformationen zu den gelöschten Daten
								nach Ablauf des Vorhaltezeitraums noch mindestens erhalten bleiben, bevor sie endgültig gelöscht werden
								können und dann nicht mehr wiederherstellbar sind.
		<p>
		&lt;absatz&gt;
									Das endgültige Löschen ignoriert den Löschschutz und die Sicherung, d. h. sofern das endgültige
									Löschen aktiviert ist, werden alle Daten gelöscht, die älter sind als der aktuell parametrierte Vorhaltezeitraum
									plus die hier aktuell parametrierte ZusätzlicheVorhaltezeit, egal ob die Daten schon gesichert wurden oder nicht.
									Es spielt für das endgültige Löschen keine Rolle, welche Vorhaltezeit beim Anlegen des Containers parametriert war.
								&lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von ZusaetzlicheVorhaltezeit.
		*/
			public 	RelativerZeitstempel
			 getZusaetzlicheVorhaltezeit() {
			return _zusaetzlicheVorhaltezeit;
		}
	
		/**
		Dieses Attribut gibt an, wie lange die Daten bzw. die Metainformationen zu den gelöschten Daten
								nach Ablauf des Vorhaltezeitraums noch mindestens erhalten bleiben, bevor sie endgültig gelöscht werden
								können und dann nicht mehr wiederherstellbar sind.
		<p>
		&lt;absatz&gt;
									Das endgültige Löschen ignoriert den Löschschutz und die Sicherung, d. h. sofern das endgültige
									Löschen aktiviert ist, werden alle Daten gelöscht, die älter sind als der aktuell parametrierte Vorhaltezeitraum
									plus die hier aktuell parametrierte ZusätzlicheVorhaltezeit, egal ob die Daten schon gesichert wurden oder nicht.
									Es spielt für das endgültige Löschen keine Rolle, welche Vorhaltezeit beim Anlegen des Containers parametriert war.
								&lt;&#47;absatz&gt;
		</p>
		
		@param _zusaetzlicheVorhaltezeit der neue Wert von ZusaetzlicheVorhaltezeit.
		*/
		public void setZusaetzlicheVorhaltezeit(	RelativerZeitstempel
		 _zusaetzlicheVorhaltezeit) {
			this._zusaetzlicheVorhaltezeit = _zusaetzlicheVorhaltezeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = datum.getReferenceArray("Bereich");
					arrayBereich.setLength(getBereich().size());
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final Object soBereich = getBereich().get(i);
						final SystemObject tmpBereich;
						if (soBereich instanceof SystemObject) {
							tmpBereich = (SystemObject)soBereich;
						} else if(soBereich instanceof SystemObjekt){
							tmpBereich = ((SystemObjekt)soBereich).getSystemObject();
						} else{
							tmpBereich = null;
						}
						arrayBereich.getReferenceValue(i).setSystemObject(tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayDatenSpezifikation = datum.getArray("DatenSpezifikation");
					arrayDatenSpezifikation.setLength(getDatenSpezifikation().size());
					for (int i = 0; i < arrayDatenSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
						 atl = getDatenSpezifikation().get(i);
						atl.bean2Atl(arrayDatenSpezifikation.getItem(i), factory);
	
					}
				// ZeitstempelAttributTyp
					datum.getTimeValue("ZusätzlicheVorhaltezeit").setMillis(getZusaetzlicheVorhaltezeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayBereich = daten.getReferenceArray("Bereich");
					for (int i = 0; i < arrayBereich.getLength(); ++i) {
						final long idBereich = daten.getReferenceArray("Bereich").getReferenceValue(i).getId();
						final SystemObjekt tmpBereich;
						if (idBereich == 0) {
							tmpBereich = null;
						} else {
							final SystemObject soBereich = factory.getDav().getDataModel().getObject(idBereich);
							if (soBereich == null) {
									tmpBereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idBereich);
							} else {
								tmpBereich = factory.getModellobjekt(soBereich);
							}
						}
							getBereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpBereich);
					}
				// AttributListenDefinition
					final Data.Array arrayDatenSpezifikation = daten.getArray("DatenSpezifikation");
					for (int i = 0; i < arrayDatenSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDatenSpezifikationArchiv
						 ();
						atl.atl2Bean(arrayDatenSpezifikation.getItem(i), factory);
						getDatenSpezifikation().add(atl);
					}
				// ZeitstempelAttributTyp
					setZusaetzlicheVorhaltezeit(new
						RelativerZeitstempel
						(daten.getTimeValue("ZusätzlicheVorhaltezeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterSatzArchivLoeschen clone() {
		AtlParameterSatzArchivLoeschen klon = new AtlParameterSatzArchivLoeschen();
		
					klon._bereich = getBereich().clone();
					klon._datenSpezifikation = getDatenSpezifikation().clone();
						klon.setZusaetzlicheVorhaltezeit(getZusaetzlicheVorhaltezeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
