/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält Angaben (ATG, ASP, Objekte, Kompletter Attributpfad, Min-Max-Grenzwerte und Vorgabeflags für die formale PL-Prüfung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlParameterSatzPlausibilitaetsPruefungFormal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributgruppe
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt
			;
			private Feld<	Object
			> _objekt = new Feld<	Object
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributSpezifikationPlausibilitaetsPruefungFormal
			> _attributSpezifikation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributSpezifikationPlausibilitaetsPruefungFormal
			>(0, true);
	
		/**
		Attributgruppe, innerhalb derer ein Attribut für die formale PL-Prüfung festgelegt wird.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppe.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAttributgruppe() {
			return _attributgruppe;
		}
	
		/**
		Attributgruppe, innerhalb derer ein Attribut für die formale PL-Prüfung festgelegt wird.
		<p>
		
		</p>
		
		@param _attributgruppe der neue Wert von Attributgruppe.
		*/
		public void setAttributgruppe(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _attributgruppe) {
			this._attributgruppe = _attributgruppe;
		}
	
		/**
		Aspekt der Attributgruppe, innerhalb derer ein Attribut für die formale PL-Prüfung festgelegt wird.
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getAspekt() {
			return _aspekt;
		}
	
		/**
		Aspekt der Attributgruppe, innerhalb derer ein Attribut für die formale PL-Prüfung festgelegt wird.
		<p>
		
		</p>
		
		@param _aspekt der neue Wert von Aspekt.
		*/
		public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _aspekt) {
			this._aspekt = _aspekt;
		}
	
		/**
		Objekte, für die die formale PL-Prüfung festgelegt wird.
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public Feld<	Object
			> getObjekt() {
			return _objekt;
		}
	
	
		/**
		Kompletter Attributpfad, Min-Max-Grenzwerte und Vorgabeflags für die formale PL-Prüfung.
		<p>
		
		</p>
		
		@return der Wert von AttributSpezifikation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributSpezifikationPlausibilitaetsPruefungFormal
			> getAttributSpezifikation() {
			return _attributSpezifikation;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAttributgruppe = getAttributgruppe();
					final SystemObject tmpAttributgruppe;
						if (soAttributgruppe instanceof SystemObject) {
							tmpAttributgruppe = (SystemObject)soAttributgruppe;
						} else if(soAttributgruppe instanceof SystemObjekt){
							tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
						} else{
							tmpAttributgruppe = null;
						}
					datum.getReferenceValue("Attributgruppe").setSystemObject(tmpAttributgruppe);
				// ObjektReferenzAttributTyp
					final Object soAspekt = getAspekt();
					final SystemObject tmpAspekt;
						if (soAspekt instanceof SystemObject) {
							tmpAspekt = (SystemObject)soAspekt;
						} else if(soAspekt instanceof SystemObjekt){
							tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
						} else{
							tmpAspekt = null;
						}
					datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = datum.getReferenceArray("Objekt");
					arrayObjekt.setLength(getObjekt().size());
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final Object soObjekt = getObjekt().get(i);
						final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
						arrayObjekt.getReferenceValue(i).setSystemObject(tmpObjekt);
					}
				// AttributListenDefinition
					final Data.Array arrayAttributSpezifikation = datum.getArray("AttributSpezifikation");
					arrayAttributSpezifikation.setLength(getAttributSpezifikation().size());
					for (int i = 0; i < arrayAttributSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributSpezifikationPlausibilitaetsPruefungFormal
						 atl = getAttributSpezifikation().get(i);
						atl.bean2Atl(arrayAttributSpezifikation.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAttributgruppe = daten.getReferenceValue("Attributgruppe").getId();
					final SystemObjekt tmpAttributgruppe;
					if (idAttributgruppe == 0) {
						tmpAttributgruppe = null;
					} else {
						final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
						if (soAttributgruppe == null) {
								tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
						} else {
							tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
						}
					}
					setAttributgruppe((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAttributgruppe);
				// ObjektReferenzAttributTyp
					final long idAspekt = daten.getReferenceValue("Aspekt").getId();
					final SystemObjekt tmpAspekt;
					if (idAspekt == 0) {
						tmpAspekt = null;
					} else {
						final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
						if (soAspekt == null) {
								tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
						} else {
							tmpAspekt = factory.getModellobjekt(soAspekt);
						}
					}
					setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpAspekt);
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayObjekt = daten.getReferenceArray("Objekt");
					for (int i = 0; i < arrayObjekt.getLength(); ++i) {
						final long idObjekt = daten.getReferenceArray("Objekt").getReferenceValue(i).getId();
						final SystemObjekt tmpObjekt;
						if (idObjekt == 0) {
							tmpObjekt = null;
						} else {
							final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
							if (soObjekt == null) {
									tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
							} else {
								tmpObjekt = factory.getModellobjekt(soObjekt);
							}
						}
							getObjekt().add((	Object
							) tmpObjekt);
					}
				// AttributListenDefinition
					final Data.Array arrayAttributSpezifikation = daten.getArray("AttributSpezifikation");
					for (int i = 0; i < arrayAttributSpezifikation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributSpezifikationPlausibilitaetsPruefungFormal
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlAttributSpezifikationPlausibilitaetsPruefungFormal
						 ();
						atl.atl2Bean(arrayAttributSpezifikation.getItem(i), factory);
						getAttributSpezifikation().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterSatzPlausibilitaetsPruefungFormal clone() {
		AtlParameterSatzPlausibilitaetsPruefungFormal klon = new AtlParameterSatzPlausibilitaetsPruefungFormal();
		
						klon.setAttributgruppe(getAttributgruppe());
						klon.setAspekt(getAspekt());
					klon._objekt = getObjekt().clone();
					klon._attributSpezifikation = getAttributSpezifikation().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
