/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Auswahl von Objekten über die Vorgabe von Regionen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 30
 */
public class AtlRegionen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
			> _region = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> _typ = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			>(0, true);
			@Defaultwert(wert = "")
			private String
			 _mengenbezeichnung
			= new String
			()
			;
	
		/**
		Referenz auf eine Region.
		<p>
		&lt;absatz&gt;
		                            Über dieses Array können bereits definierte Regionen angegeben werden. Die Auswahl einer
		                            Region bedeutet, dass alle Konfigurationsobjekte dieser Region betrachtet werden.
		                            Wenn das Array Region leer ist, sind alle Konfigurationsobjekte ausgewählt.
		                        &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Region.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
			> getRegion() {
			return _region;
		}
	
	
		/**
		Referenz auf Typobjekte.
		<p>
		&lt;absatz&gt;
		                            Über dieses Array werden die bisher ausgewählten Objekte auf die angegebenen Typobjekte
		                            beschränkt. D.h., wenn hier z.B. als Typ MessQuerschnitt angegeben wird, werden nur noch
		                            Konfigurationsobjekte betrachtet, die von diesem Typ stammen.
		                            Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
		                        &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Typ.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			> getTyp() {
			return _typ;
		}
	
	
		/**
		Mengenname.
		<p>
		&lt;absatz&gt;
		                            Über die Vorgabe eines Mengennamens können die Objekte ausgewählt werden, die in Mengen dieses Namens
		                            bei den ausgewählten Objekten enthalten sind. Ist hier z.B. als Menge "FahrStreifen" angegeben,
		                            wird für alle bisher ausgewählten Objekte geprüft, ob an dem Konfigurationsobjekt eine Menge
		                            dieses Namens vorhanden ist und für diesen Fall werden die enthaltenen Konfigurationsobjekte betrachtet.
		                            Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
		                         &lt;&#47;absatz&gt;
		</p>
		
		@return der Wert von Mengenbezeichnung.
		*/
			public String
			 getMengenbezeichnung() {
			return _mengenbezeichnung;
		}
	
		/**
		Mengenname.
		<p>
		&lt;absatz&gt;
		                            Über die Vorgabe eines Mengennamens können die Objekte ausgewählt werden, die in Mengen dieses Namens
		                            bei den ausgewählten Objekten enthalten sind. Ist hier z.B. als Menge "FahrStreifen" angegeben,
		                            wird für alle bisher ausgewählten Objekte geprüft, ob an dem Konfigurationsobjekt eine Menge
		                            dieses Namens vorhanden ist und für diesen Fall werden die enthaltenen Konfigurationsobjekte betrachtet.
		                            Wenn hier keine Angabe erfolgt, bleibt die Auswahl bestehen.
		                         &lt;&#47;absatz&gt;
		</p>
		
		@param _mengenbezeichnung der neue Wert von Mengenbezeichnung.
		*/
		public void setMengenbezeichnung(String
		 _mengenbezeichnung) {
			if (_mengenbezeichnung.length() > 64) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
			}
			this._mengenbezeichnung = _mengenbezeichnung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRegion = datum.getReferenceArray("Region");
					arrayRegion.setLength(getRegion().size());
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						final Object soRegion = getRegion().get(i);
						final SystemObject tmpRegion;
						if (soRegion instanceof SystemObject) {
							tmpRegion = (SystemObject)soRegion;
						} else if(soRegion instanceof SystemObjekt){
							tmpRegion = ((SystemObjekt)soRegion).getSystemObject();
						} else{
							tmpRegion = null;
						}
						arrayRegion.getReferenceValue(i).setSystemObject(tmpRegion);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = datum.getReferenceArray("Typ");
					arrayTyp.setLength(getTyp().size());
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final Object soTyp = getTyp().get(i);
						final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
						arrayTyp.getReferenceValue(i).setSystemObject(tmpTyp);
					}
				// ZeichenkettenAttributTyp
				if (getMengenbezeichnung() != null) {
					datum.getTextValue("Mengenbezeichnung").setText(getMengenbezeichnung());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayRegion = daten.getReferenceArray("Region");
					for (int i = 0; i < arrayRegion.getLength(); ++i) {
						final long idRegion = daten.getReferenceArray("Region").getReferenceValue(i).getId();
						final SystemObjekt tmpRegion;
						if (idRegion == 0) {
							tmpRegion = null;
						} else {
							final SystemObject soRegion = factory.getDav().getDataModel().getObject(idRegion);
							if (soRegion == null) {
									tmpRegion = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ZugriffsRegionNeuUngueltig(idRegion);
							} else {
								tmpRegion = factory.getModellobjekt(soRegion);
							}
						}
							getRegion().add((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
							) tmpRegion);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTyp = daten.getReferenceArray("Typ");
					for (int i = 0; i < arrayTyp.getLength(); ++i) {
						final long idTyp = daten.getReferenceArray("Typ").getReferenceValue(i).getId();
						final SystemObjekt tmpTyp;
						if (idTyp == 0) {
							tmpTyp = null;
						} else {
							final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
							if (soTyp == null) {
									tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTyp);
							} else {
								tmpTyp = factory.getModellobjekt(soTyp);
							}
						}
							getTyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
							) tmpTyp);
					}
				// ZeichenkettenAttributTyp
					setMengenbezeichnung(daten.getTextValue("Mengenbezeichnung").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRegionen clone() {
		AtlRegionen klon = new AtlRegionen();
		
					klon._region = getRegion().clone();
					klon._typ = getTyp().clone();
						klon.setMengenbezeichnung(getMengenbezeichnung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
