/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ordnet einer Rolle eine Region zu.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public class AtlRollenRegionenPaarNeu implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
			 _rolle
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
			 _region
			;
	
		/**
		Referenziert die Rolle eines Rollen&#47;Regionen-Paars.
		<p>
		
		</p>
		
		@return der Wert von Rolle.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
			 getRolle() {
			return _rolle;
		}
	
		/**
		Referenziert die Rolle eines Rollen&#47;Regionen-Paars.
		<p>
		
		</p>
		
		@param _rolle der neue Wert von Rolle.
		*/
		public void setRolle(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
		 _rolle) {
			this._rolle = _rolle;
		}
	
		/**
		Referenziert die Region eines Rollen&#47;Regionen-Paars.
		<p>
		
		</p>
		
		@return der Wert von Region.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
			 getRegion() {
			return _region;
		}
	
		/**
		Referenziert die Region eines Rollen&#47;Regionen-Paars.
		<p>
		
		</p>
		
		@param _region der neue Wert von Region.
		*/
		public void setRegion(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
		 _region) {
			this._region = _region;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soRolle = getRolle();
					final SystemObject tmpRolle;
						if (soRolle instanceof SystemObject) {
							tmpRolle = (SystemObject)soRolle;
						} else if(soRolle instanceof SystemObjekt){
							tmpRolle = ((SystemObjekt)soRolle).getSystemObject();
						} else{
							tmpRolle = null;
						}
					datum.getReferenceValue("Rolle").setSystemObject(tmpRolle);
				// ObjektReferenzAttributTyp
					final Object soRegion = getRegion();
					final SystemObject tmpRegion;
						if (soRegion instanceof SystemObject) {
							tmpRegion = (SystemObject)soRegion;
						} else if(soRegion instanceof SystemObjekt){
							tmpRegion = ((SystemObjekt)soRegion).getSystemObject();
						} else{
							tmpRegion = null;
						}
					datum.getReferenceValue("Region").setSystemObject(tmpRegion);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idRolle = daten.getReferenceValue("Rolle").getId();
					final SystemObjekt tmpRolle;
					if (idRolle == 0) {
						tmpRolle = null;
					} else {
						final SystemObject soRolle = factory.getDav().getDataModel().getObject(idRolle);
						if (soRolle == null) {
								tmpRolle = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ZugriffsRolleNeuUngueltig(idRolle);
						} else {
							tmpRolle = factory.getModellobjekt(soRolle);
						}
					}
					setRolle((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRolleNeu
					) tmpRolle);
				// ObjektReferenzAttributTyp
					final long idRegion = daten.getReferenceValue("Region").getId();
					final SystemObjekt tmpRegion;
					if (idRegion == 0) {
						tmpRegion = null;
					} else {
						final SystemObject soRegion = factory.getDav().getDataModel().getObject(idRegion);
						if (soRegion == null) {
								tmpRegion = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ZugriffsRegionNeuUngueltig(idRegion);
						} else {
							tmpRegion = factory.getModellobjekt(soRegion);
						}
					}
					setRegion((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegionNeu
					) tmpRegion);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRollenRegionenPaarNeu clone() {
		AtlRollenRegionenPaarNeu klon = new AtlRollenRegionenPaarNeu();
		
						klon.setRolle(getRolle());
						klon.setRegion(getRegion());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
