/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt die aktive Seite für den Aufbau einer Verbindung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttAktiveVerbindungsRolle extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Verbindung wird initial von keiner Seite aufgebaut.
	<p>
	
	</p>
	*/
	public static final AttAktiveVerbindungsRolle ZUSTAND_0__ = new AttAktiveVerbindungsRolle("-", 		Byte
	.valueOf("0"));

	/**
	Verbindung wird initial von der ersten Seite (z.B vom ersten Datenverteiler) aufgebaut.
	<p>
	
	</p>
	*/
	public static final AttAktiveVerbindungsRolle ZUSTAND_1_A = new AttAktiveVerbindungsRolle("A", 		Byte
	.valueOf("1"));

	/**
	Verbindung wird initial von der zweiten Seite (z.B vom zweiten Datenverteiler) aufgebaut.
	<p>
	
	</p>
	*/
	public static final AttAktiveVerbindungsRolle ZUSTAND_2_B = new AttAktiveVerbindungsRolle("B", 		Byte
	.valueOf("2"));

	/**
	Verbindung wird initial von beiden Seiten aufgebaut.
	<p>
	
	</p>
	*/
	public static final AttAktiveVerbindungsRolle ZUSTAND_3_A_B = new AttAktiveVerbindungsRolle("A+B", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttAktiveVerbindungsRolle getZustand(final 		Byte
	 value) {
		for (AttAktiveVerbindungsRolle e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttAktiveVerbindungsRolle getZustand(final String value) {
		for (AttAktiveVerbindungsRolle e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttAktiveVerbindungsRolle> getZustaende() {
		List<AttAktiveVerbindungsRolle> list = new ArrayList<AttAktiveVerbindungsRolle>();
		list.add(ZUSTAND_0__);
		list.add(ZUSTAND_1_A);
		list.add(ZUSTAND_2_B);
		list.add(ZUSTAND_3_A_B);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut AktiveSeite.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttAktiveVerbindungsRolle(final 		Byte
	 value) {
		super(value);
	}
	
	private AttAktiveVerbindungsRolle(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
