/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommunikationszustand der Kommunikation mit einem anderen Datenverteiler.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 36
 */
public class AttDatenverteilerKommunikationsZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_0_NICHT_VERBUNDEN = new AttDatenverteilerKommunikationsZustand("Nicht verbunden", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_1_ERSATZVERBINDUNG_NICHT_VERBUNDEN_ = new AttDatenverteilerKommunikationsZustand("Ersatzverbindung (nicht verbunden)", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_2_DEAKTIVIERT_NICHT_VERBUNDEN_ = new AttDatenverteilerKommunikationsZustand("Deaktiviert (nicht verbunden)", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_4_WARTE_AUF_EINGEHENDE_VERBINDUNG = new AttDatenverteilerKommunikationsZustand("Warte auf eingehende Verbindung", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_5_FEHLER = new AttDatenverteilerKommunikationsZustand("Fehler", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_6_VERBINDUNGSAUFBAU = new AttDatenverteilerKommunikationsZustand("Verbindungsaufbau", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_7_AUTHENTIFIZIERUNG = new AttDatenverteilerKommunikationsZustand("Authentifizierung", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_8_VERBUNDEN = new AttDatenverteilerKommunikationsZustand("Verbunden", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatenverteilerKommunikationsZustand ZUSTAND_9_VERBINDUNGSABBAU = new AttDatenverteilerKommunikationsZustand("Verbindungsabbau", 		Byte
	.valueOf("9"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDatenverteilerKommunikationsZustand getZustand(final 		Byte
	 value) {
		for (AttDatenverteilerKommunikationsZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDatenverteilerKommunikationsZustand getZustand(final String value) {
		for (AttDatenverteilerKommunikationsZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDatenverteilerKommunikationsZustand> getZustaende() {
		List<AttDatenverteilerKommunikationsZustand> list = new ArrayList<AttDatenverteilerKommunikationsZustand>();
		list.add(ZUSTAND_0_NICHT_VERBUNDEN);
		list.add(ZUSTAND_1_ERSATZVERBINDUNG_NICHT_VERBUNDEN_);
		list.add(ZUSTAND_2_DEAKTIVIERT_NICHT_VERBUNDEN_);
		list.add(ZUSTAND_4_WARTE_AUF_EINGEHENDE_VERBINDUNG);
		list.add(ZUSTAND_5_FEHLER);
		list.add(ZUSTAND_6_VERBINDUNGSAUFBAU);
		list.add(ZUSTAND_7_AUTHENTIFIZIERUNG);
		list.add(ZUSTAND_8_VERBUNDEN);
		list.add(ZUSTAND_9_VERBINDUNGSABBAU);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KommunikationsZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDatenverteilerKommunikationsZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttDatenverteilerKommunikationsZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
