/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von Konfigurationsanfragen(lesend) dient.
<p>
Alle Nachrichtentypen, mit denen Daten aus der Konfiguration angefordert werden können. Die Konfiguration kann durch diese Nachrichtentypen
					nicht aufgefordert werden Daten zu ändern.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 19
 */
public class AttKonfigurationsAnfrageNachrichtenTypLesend extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kennzeichnet Anfragen nach grundlegenden Objektinformationen zu der angegebenen Objekt-Id.
	                            Unterstützt nur dynamische Objekte und wird nur Konfigurationsseitig für Anfragen nach fremden dynamischen Objekten verwendet.
	                            Für allgemeine Anfragen wird stattdessen
	                            &lt;schluesselwort&gt;ObjekteAnfragenMitIds&lt;&#47;schluesselwort&gt;
	                            verwendet.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_1_OBJEKTANFRAGEMITID = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjektAnfrageMitId", 		Byte
	.valueOf("1"));

	/**
	Kennzeichnet Anfragen nach grundlegenden Objektinformationen zu der angegebenen Objekt-Pid.
	                            Unterstützt nur dynamische Objekte und wird von der Kernsoftware nicht verwendet.
	                            Für allgemeine Anfragen wird stattdessen
	                            &lt;schluesselwort&gt;ObjekteAnfragenMitPids&lt;&#47;schluesselwort&gt;
	                            verwendet.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_2_OBJEKTANFRAGEMITPID = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjektAnfrageMitPid", 		Byte
	.valueOf("2"));

	/**
	Kennzeichnet Antworten mit grundlegenden Objektinformationen zu angefragten Objekten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_3_OBJEKTANTWORT = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjektAntwort", 		Byte
	.valueOf("3"));

	/**
	Kennzeichnet Antworten mit einem Fehlertext bei fehlgeschlagenen Anfragen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_4_FEHLERANTWORT = new AttKonfigurationsAnfrageNachrichtenTypLesend("FehlerAntwort", 		Byte
	.valueOf("4"));

	/**
	Kennzeichnet Anfragen nach allen Elementen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_5_DYNAMISCHEMENGEALLEELEMENTEANFRAGE = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeMengeAlleElementeAnfrage", 		Byte
	.valueOf("5"));

	/**
	Kennzeichnet Antworten mit allen Elementen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_6_DYNAMISCHEMENGEALLEELEMENTEANTWORT = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeMengeAlleElementeAntwort", 		Byte
	.valueOf("6"));

	/**
	Kennzeichnet das Anmelden eines Beobachters an einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_7_DYNAMISCHEMENGEBEOBACHTERANMELDEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeMengeBeobachterAnmelden", 		Byte
	.valueOf("7"));

	/**
	Kennzeichnet das Abmelden eines Beobachters von einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_8_DYNAMISCHEMENGEBEOBACHTERABMELDEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeMengeBeobachterAbmelden", 		Byte
	.valueOf("8"));

	/**
	Kennzeichnet das Aktualisieren von Dynamischen Mengen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_9_DYNAMISCHEMENGEAKTUALISIERUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeMengeAktualisierung", 		Byte
	.valueOf("9"));

	/**
	Kennzeichnet Anfragen nach konfigurierenden Datensätzen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_10_DATENSATZANFRAGE = new AttKonfigurationsAnfrageNachrichtenTypLesend("DatensatzAnfrage", 		Byte
	.valueOf("10"));

	/**
	Kennzeichnet eine Antwort mit einem konfigurierenden Datensatz.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_11_DATENSATZANTWORT = new AttKonfigurationsAnfrageNachrichtenTypLesend("DatensatzAntwort", 		Byte
	.valueOf("11"));

	/**
	Kennzeichnet Anfragen nach Objekte, die in einem bestimmten Zeitbereich gültig waren.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_12_OBJEKTEANFRAGENMITPIDUNDZEITBEREICH = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjekteAnfragenMitPidUndZeitbereich", 		Byte
	.valueOf("12"));

	/**
	Kennzeichnet eine Antwort nach Objekten, die in einem bestimmten Zeitbereich gültig waren.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_13_ANTWORTOBJEKTEANFRAGENMITPIDUNDZEITBEREICH = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortObjekteAnfragenMitPidUndZeitbereich", 		Byte
	.valueOf("13"));

	/**
	Kennzeichnet Anfragen nach der aktiven Version eines Konfigurationsbereichs.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_14_AKTIVEVERSIONKONFIGURATIONSBEREICH = new AttKonfigurationsAnfrageNachrichtenTypLesend("AktiveVersionKonfigurationsbereich", 		Byte
	.valueOf("14"));

	/**
	Kennzeichnet eine Antwort nach der aktiven Version eines Konfigurationsbereichs.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_15_ANTWORTAKTIVEVERSIONKONFIGURATIONSBEREICH = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortAktiveVersionKonfigurationsbereich", 		Byte
	.valueOf("15"));

	/**
	Kennzeichnet Anfragen nach der aktiven Version eines Konfigurationsbereichs.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_16_OBJEKTEMITBEREICHUNDTYPANFRAGEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjekteMitBereichUndTypAnfragen", 		Byte
	.valueOf("16"));

	/**
	Kennzeichnet eine Antwort nach der aktiven Version eines Konfigurationsbereichs.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_17_ANTWORTOBJEKTEMITBEREICHUNDTYPANFRAGEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortObjekteMitBereichUndTypAnfragen", 		Byte
	.valueOf("17"));

	/**
	Kennzeichnet Anfragen nach Objekten eines Konfigurationsbereichs, die direkt einem Typ zugeorndert werden können.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_18_OBJEKTEDIREKTERTYP = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjekteDirekterTyp", 		Byte
	.valueOf("18"));

	/**
	Kennzeichnet eine Antwort nach Objekten eines Konfigurationsbereichs, die direkt einem Typ zugeorndert werden
								können.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_19_ANTWORTOBJEKTEDIREKTERTYP = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortObjekteDirekterTyp", 		Byte
	.valueOf("19"));

	/**
	Wird nicht mehr benötigt.
	<p>
	Die Konfiguration wird die anfragende Applikation benachrichtigen, wenn ein dynamisches Objekt ungültig wird. Dieses Telegramm wird
								ebenfalls dazu benutzt die Überwachung eines dynamischen Objekts einzustellen, wenn dieses überwacht wird.
	
								Der Mechanismus wird nun über "Objektaktualisierung" ermöglicht.
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_20_GUELTIGKEITDYNAMISCHESOBJEKTUEBERWACHEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("GueltigkeitDynamischesObjektUeberwachen", 		Byte
	.valueOf("20"));

	/**
	Wird nicht mehr benötigt.
	<p>
	Antwort auf den Auftrage die Gültigkeit dynamischer Objekte zu überwachen&#47;nicht mehr zu überwachen. Falls der Auftrag nicht
								durchgeführt werden konnte, wird ein "Fehler" Telegramm verschickt. Das Telegramm dient nur als Bestätigung der Konfiguration auf
								den Auftrag.
	
								Der Mechanismus wird nun über "Objektaktualisierung" ermöglicht.
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_21_ANTWORTGUELTIGKEITDYNAMISCHESOBJEKTUEBERWACHEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortGueltigkeitDynamischesObjektUeberwachen", 		Byte
	.valueOf("21"));

	/**
	Wird nicht mehr benötigt.
	<p>
	Das Telegramm wird verschickt, wenn ein dynamisches Objekt ungültig wird. Es werden alle Objekte benachrichtigt, die sich mit einem
								Telegramm vom Typ "GueltigkeitDynamischesObjektUeberwachen" angemeldet haben.
	
								Der Mechanismus wird nun über "Objektaktualisierung" ermöglicht.
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_22_GUELTIGKEITDYNAMISCHESOBJEKTAKTUALISIERUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("GueltigkeitDynamischesObjektAktualisierung", 		Byte
	.valueOf("22"));

	/**
	Kennzeichnet Anfragen nach der Version eines Konfigurationsbereichs, die sich derzeit in Bearbeitung(Modifiable Version)
								befindet.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_23_VERSIONINARBEITKONFIGURATIONSBEREICH = new AttKonfigurationsAnfrageNachrichtenTypLesend("VersionInArbeitKonfigurationsbereich", 		Byte
	.valueOf("23"));

	/**
	Kennzeichnet eine Antwort nach der in Bearbeitung befindlichen Version eines Konfigurationsbereichs.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_24_ANTWORTVERSIONINARBEITKONFIGURATIONSBEREICH = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortVersionInArbeitKonfigurationsbereich", 		Byte
	.valueOf("24"));

	/**
	Kennzeichnet eine Nachricht, die für ein Objekt aktuelle Werte enthält.
	<p>
	Dieses Telegramm wird von der Konfiguration an eine Applikation verschickt, wenn es an einem dynamischen oder einem
								Konfigurationsobjekt zu Änderungen gekommen ist.
								Ein Beispiel wäre eine Namensänderung an einem dynamischen Objekt. Der Name des gespeicherte Objekts auf Seiten der Applikation
								würde nach empfang des Telegramms auf den neuen Namen gesetzt.
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_25_OBJEKTAKTUALISIERUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("Objektaktualisierung", 		Byte
	.valueOf("25"));

	/**
	Kennzeichnet eine Nachricht, alle neuen Objekte eines bestimmten Bereichs zurückzugeben.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_26_NEUEOBJEKTEEINESBEREICHSANFORDERN = new AttKonfigurationsAnfrageNachrichtenTypLesend("NeueObjekteEinesBereichsAnfordern", 		Byte
	.valueOf("26"));

	/**
	Antwort auf die Anfrage alle neuen Objekte eines Bereichts anzu-fordern.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_27_ANTWORTNEUEOBJEKTEEINESBEREICHSANFORDERN = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortNeueObjekteEinesBereichsAnfordern", 		Byte
	.valueOf("27"));

	/**
	Kennzeichnet eine Nachricht, alle Objekte eines Typs anzufordern und dabei die Versionierung zu beachten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_28_ELEMENTEEINESTYPSMITVERSIONEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("ElementeEinesTypsMitVersionen", 		Byte
	.valueOf("28"));

	/**
	Antwort auf die Anfrage alle Objekte eines Typs anzufordern und dabei die Versionierung zu beachten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_29_ANTWORTELEMENTEEINESTYPSMITVERSIONEN = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortElementeEinesTypsMitVersionen", 		Byte
	.valueOf("29"));

	/**
	Kennzeichnet eine Nachricht, alle Objekte einer Menge anzufordern und dabei die Zeit der Aktivierung zu berücksichtigen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_30_ELEMENTEEINERMENGEZEIT = new AttKonfigurationsAnfrageNachrichtenTypLesend("ElementeEinerMengeZeit", 		Byte
	.valueOf("30"));

	/**
	Antwort auf die Anfrage alle Objekte einer Menge anzufordern und dabei die Zeit der Aktivierung zu beachten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_31_ANTWORTELEMENTEEINERMENGEZEIT = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortElementeEinerMengeZeit", 		Byte
	.valueOf("31"));

	/**
	Kennzeichnet eine Nachricht, alle Objekte einer Menge anzufordern und dabei die Versionierung zu beachten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_32_ELEMENTEEINERMENGEVERSION = new AttKonfigurationsAnfrageNachrichtenTypLesend("ElementeEinerMengeVersion", 		Byte
	.valueOf("32"));

	/**
	Antwort auf die Anfrage alle Objekte einer Menge anzufordern und dabei die Versionierung zu beachten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_33_ANTWORTELEMENTEEINERMENGEVERSION = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortElementeEinerMengeVersion", 		Byte
	.valueOf("33"));

	/**
	Kennzeichnet die Anmeldung auf Änderungen der Elemente einer dynamischen Menge oder eines dynamischen Typs mit
								Simulationsvariante.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_34_DYNAMISCHEKOLLEKTIONANMELDUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeKollektionAnmeldung", 		Byte
	.valueOf("34"));

	/**
	Kennzeichnet den aktuellen Stand der Elemente einer dynamischen Menge oder eines dynamischen Typs mit Simulationsvariante als
								Reaktion auf eine entsprechende Anmeldung.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_35_DYNAMISCHEKOLLEKTIONELEMENTE = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeKollektionElemente", 		Byte
	.valueOf("35"));

	/**
	Kennzeichnet die Aktualisierung der Elemente einer dynamischen Menge oder eines dynamischen Typs mit Simulationsvariante als
								Reaktion auf ein ensprechende Änderung.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_36_DYNAMISCHEKOLLEKTIONAKTUALISIERUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeKollektionAktualisierung", 		Byte
	.valueOf("36"));

	/**
	Kennzeichnet die Abmeldung auf Änderungen der Elemente einer dynamischen Menge oder eines dynamischen Typs mit
								Simulationsvariante.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_37_DYNAMISCHEKOLLEKTIONABMELDUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("DynamischeKollektionAbmeldung", 		Byte
	.valueOf("37"));

	/**
	Kennzeichnet die Anmeldung auf Änderungen des Kommunikationszustands mit der (potentiell) fremden Konfiguration, die eine
								dynamische Menge, bzw. ein enthaltenes dynamisches Objekt verwaltet.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_38_KOMMUNIKATIONSZUSTANDANMELDUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("KommunikationszustandAnmeldung", 		Byte
	.valueOf("38"));

	/**
	Kennzeichnet die Abmeldung auf Änderungen des Kommunikationszustands mit der (potentiell) fremden Konfiguration, die eine
								dynamische Menge, bzw. ein enthaltenes dynamisches Objekt verwaltet.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_39_KOMMUNIKATIONSZUSTANDABMELDUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("KommunikationszustandAbmeldung", 		Byte
	.valueOf("39"));

	/**
	Kennzeichnet die Rückmeldung des Kommunikationszustands mit der (potentiell) fremden Konfiguration, die eine dynamische Menge,
								bzw. ein enthaltenes dynamisches Objekt verwaltet.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_40_KOMMUNIKATIONSZUSTANDRUECKMELDUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("KommunikationszustandRückmeldung", 		Byte
	.valueOf("40"));

	/**
	Kennzeichnet die Aktualisierung des Kommunikationszustands mit der fremden Konfiguration, die eine dynamische Menge, bzw. ein
								enthaltenes dynamisches Objekt verwaltet.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_41_KOMMUNIKATIONSZUSTANDAKTUALISIERUNG = new AttKonfigurationsAnfrageNachrichtenTypLesend("KommunikationszustandAktualisierung", 		Byte
	.valueOf("41"));

	/**
	Kennzeichnet die Anfrage eines Typs nach den Objekten dieses Typs.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_42_OBJEKTEANFRAGENMITTYP = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjekteAnfragenMitTyp", 		Byte
	.valueOf("42"));

	/**
	Kennzeichnet Anfragen nach Objektinformationen zu den angegebenen Objekt-Ids.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_43_OBJEKTEANFRAGENMITIDS = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjekteAnfragenMitIds", 		Byte
	.valueOf("43"));

	/**
	Kennzeichnet Anfragen nach Objektinformationen zu den angegebenen Objekt-Pids.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_44_OBJEKTEANFRAGENMITPIDS = new AttKonfigurationsAnfrageNachrichtenTypLesend("ObjekteAnfragenMitPids", 		Byte
	.valueOf("44"));

	/**
	Antwort mit mehreren Objekten.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypLesend ZUSTAND_45_ANTWORTOBJEKTE = new AttKonfigurationsAnfrageNachrichtenTypLesend("AntwortObjekte", 		Byte
	.valueOf("45"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKonfigurationsAnfrageNachrichtenTypLesend getZustand(final 		Byte
	 value) {
		for (AttKonfigurationsAnfrageNachrichtenTypLesend e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKonfigurationsAnfrageNachrichtenTypLesend getZustand(final String value) {
		for (AttKonfigurationsAnfrageNachrichtenTypLesend e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKonfigurationsAnfrageNachrichtenTypLesend> getZustaende() {
		List<AttKonfigurationsAnfrageNachrichtenTypLesend> list = new ArrayList<AttKonfigurationsAnfrageNachrichtenTypLesend>();
		list.add(ZUSTAND_1_OBJEKTANFRAGEMITID);
		list.add(ZUSTAND_2_OBJEKTANFRAGEMITPID);
		list.add(ZUSTAND_3_OBJEKTANTWORT);
		list.add(ZUSTAND_4_FEHLERANTWORT);
		list.add(ZUSTAND_5_DYNAMISCHEMENGEALLEELEMENTEANFRAGE);
		list.add(ZUSTAND_6_DYNAMISCHEMENGEALLEELEMENTEANTWORT);
		list.add(ZUSTAND_7_DYNAMISCHEMENGEBEOBACHTERANMELDEN);
		list.add(ZUSTAND_8_DYNAMISCHEMENGEBEOBACHTERABMELDEN);
		list.add(ZUSTAND_9_DYNAMISCHEMENGEAKTUALISIERUNG);
		list.add(ZUSTAND_10_DATENSATZANFRAGE);
		list.add(ZUSTAND_11_DATENSATZANTWORT);
		list.add(ZUSTAND_12_OBJEKTEANFRAGENMITPIDUNDZEITBEREICH);
		list.add(ZUSTAND_13_ANTWORTOBJEKTEANFRAGENMITPIDUNDZEITBEREICH);
		list.add(ZUSTAND_14_AKTIVEVERSIONKONFIGURATIONSBEREICH);
		list.add(ZUSTAND_15_ANTWORTAKTIVEVERSIONKONFIGURATIONSBEREICH);
		list.add(ZUSTAND_16_OBJEKTEMITBEREICHUNDTYPANFRAGEN);
		list.add(ZUSTAND_17_ANTWORTOBJEKTEMITBEREICHUNDTYPANFRAGEN);
		list.add(ZUSTAND_18_OBJEKTEDIREKTERTYP);
		list.add(ZUSTAND_19_ANTWORTOBJEKTEDIREKTERTYP);
		list.add(ZUSTAND_20_GUELTIGKEITDYNAMISCHESOBJEKTUEBERWACHEN);
		list.add(ZUSTAND_21_ANTWORTGUELTIGKEITDYNAMISCHESOBJEKTUEBERWACHEN);
		list.add(ZUSTAND_22_GUELTIGKEITDYNAMISCHESOBJEKTAKTUALISIERUNG);
		list.add(ZUSTAND_23_VERSIONINARBEITKONFIGURATIONSBEREICH);
		list.add(ZUSTAND_24_ANTWORTVERSIONINARBEITKONFIGURATIONSBEREICH);
		list.add(ZUSTAND_25_OBJEKTAKTUALISIERUNG);
		list.add(ZUSTAND_26_NEUEOBJEKTEEINESBEREICHSANFORDERN);
		list.add(ZUSTAND_27_ANTWORTNEUEOBJEKTEEINESBEREICHSANFORDERN);
		list.add(ZUSTAND_28_ELEMENTEEINESTYPSMITVERSIONEN);
		list.add(ZUSTAND_29_ANTWORTELEMENTEEINESTYPSMITVERSIONEN);
		list.add(ZUSTAND_30_ELEMENTEEINERMENGEZEIT);
		list.add(ZUSTAND_31_ANTWORTELEMENTEEINERMENGEZEIT);
		list.add(ZUSTAND_32_ELEMENTEEINERMENGEVERSION);
		list.add(ZUSTAND_33_ANTWORTELEMENTEEINERMENGEVERSION);
		list.add(ZUSTAND_34_DYNAMISCHEKOLLEKTIONANMELDUNG);
		list.add(ZUSTAND_35_DYNAMISCHEKOLLEKTIONELEMENTE);
		list.add(ZUSTAND_36_DYNAMISCHEKOLLEKTIONAKTUALISIERUNG);
		list.add(ZUSTAND_37_DYNAMISCHEKOLLEKTIONABMELDUNG);
		list.add(ZUSTAND_38_KOMMUNIKATIONSZUSTANDANMELDUNG);
		list.add(ZUSTAND_39_KOMMUNIKATIONSZUSTANDABMELDUNG);
		list.add(ZUSTAND_40_KOMMUNIKATIONSZUSTANDRUECKMELDUNG);
		list.add(ZUSTAND_41_KOMMUNIKATIONSZUSTANDAKTUALISIERUNG);
		list.add(ZUSTAND_42_OBJEKTEANFRAGENMITTYP);
		list.add(ZUSTAND_43_OBJEKTEANFRAGENMITIDS);
		list.add(ZUSTAND_44_OBJEKTEANFRAGENMITPIDS);
		list.add(ZUSTAND_45_ANTWORTOBJEKTE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KonfigurationsNachrichtenTypLesend.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKonfigurationsAnfrageNachrichtenTypLesend(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKonfigurationsAnfrageNachrichtenTypLesend(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
