/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von Konfigurationsanfragen(schreibend)
					dient.
<p>
Alle Nachrichtentypen, mit denen Daten aus der Konfiguration angefordert werden können. Die Konfiguration wird durch diese Nachrichtentyp
					aufgefordert Daten zu ändern.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class AttKonfigurationsAnfrageNachrichtenTypSchreibend extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kennzeichnet Änderungen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_1_DYNAMISCHEMENGEELEMENTEAENDERN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("DynamischeMengeElementeÄndern", 		Byte
	.valueOf("1"));

	/**
	Kennzeichnet Antworten zu Änderungen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_2_DYNAMISCHEMENGEELEMENTEANTWORT = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("DynamischeMengeElementeAntwort", 		Byte
	.valueOf("2"));

	/**
	Kennzeichnet Antworten mit einem Fehlertext bei fehlgeschlagenen Anfragen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_3_FEHLERANTWORT = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("FehlerAntwort", 		Byte
	.valueOf("3"));

	/**
	Kennzeichnet Änderungen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_4_KONFIGURIERENDENDATENSATZFESTLEGEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("KonfigurierendenDatensatzFestlegen", 		Byte
	.valueOf("4"));

	/**
	Kennzeichnet Änderungen einer Dynamischen Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_5_KONFIGURIERENDENDATENSATZFESTLEGENANTWORT = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("KonfigurierendenDatensatzFestlegenAntwort", 		Byte
	.valueOf("5"));

	/**
	Negative Antwort auf einen Auftrag, der Änderungen in der Konfiguration hervorgerufen hätte.
	<p>
	Diese Nachricht wird verschickt, wenn die Konfiguration eine Änderung in der Konfiguration nicht ausführt, weil gewisse
								Randbediengungen nicht erfüllt sind. Einige Beispiele wären: Bereich aktivieren, obwohl der Bereich noch nicht zur Aktivierung
								freigegeben war; Bereich anlegen wurde verweigert (Pid schon vergeben); usw.
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_6_KONFIGURATIONSAENDERUNGVERWEIGERT = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("KonfigurationsänderungVerweigert", 		Byte
	.valueOf("6"));

	/**
	Kennzeichnet Änderungen einer konfigurierende Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_7_KONFIGURIERENDEMENGEELEMENTEAENDERN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("KonfigurierendeMengeElementeÄndern", 		Byte
	.valueOf("7"));

	/**
	Kennzeichnet Antworten zu Änderungen einer konfigurierende Menge.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_8_KONFIGURIERENDEMENGEELEMENTEANTWORT = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("KonfigurierendeMengeElementeAntwort", 		Byte
	.valueOf("8"));

	/**
	Beauftagt die Konfiguration ein neues Objekt(dynamische oder konfigurierend) anzulegen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_9_OBJEKTANLEGEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("ObjektAnlegen", 		Byte
	.valueOf("9"));

	/**
	Rückmeldung der Konfiguration auf den Auftrag ein Objekt anzulegen. Die Rückmeldung enthält das Objekt.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_10_ANTWORTOBJEKTANLEGEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("AntwortObjektAnlegen", 		Byte
	.valueOf("10"));

	/**
	Beauftragt die Konfiguration die Kopie eines Objekts zu erstellen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_11_OBJEKTKOPIEREN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("ObjektKopieren", 		Byte
	.valueOf("11"));

	/**
	Rückmeldung der Konfiguration auf den Auftrag ein Objekt zu kopieren. Die Antwort enthält die Kopie des Objekts.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_12_ANTWORTOBJEKTKOPIEREN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("AntwortObjektKopieren", 		Byte
	.valueOf("12"));

	/**
	Beauftragt die Konfiguration die Menge eines Objekts zu entfernen oder eine neue Menge hinzuzufügen.
	<p>
	Ein Telegramm dieser Art enthält den Auftrag eine Menge eines Konfigurationsbjekts zu entfernen oder eine neuen
								Menge anzulegen. In beiden Fällen sind die Änderungen erst nach dem er-folgreichen Versionswechsel der Konfiguration
								sichtbar.
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_13_OBJEKTMENGENBEARBEITEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("ObjektMengenBearbeiten", 		Byte
	.valueOf("13"));

	/**
	Positive Rückmeldung der Konfiguration auf den Auftrag die Menge eines Konfigurationsobjekts zu löschen&#47;eine neue Menge
								hinzuzufügen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_14_ANTWORTOBJEKTMENGENBEARBEITEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("AntwortObjektMengenBearbeiten", 		Byte
	.valueOf("14"));

	/**
	Auftrag zur Erstellung eines dynamischen Objekts (siehe ObjektAnlegen), gleichzeitig werden auch die konfigurierenden
								Datensätze bei der Erzeugung des Objekt gespeichert.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_15_DYNAMISCHESOBJEKTMITKONFIGURIERENDENDATENSAETZENANLEGEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("DynamischesObjektMitKonfigurierendenDatensaetzenAnlegen", 		Byte
	.valueOf("15"));

	/**
	Auftrag ein Objekt ungültig zu machen. Dynamische Objekte werden sofort ungültig, Konfigurationsobjekte
	                            erst beim Aktivieren der Änderungen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_16_OBJEKTLOESCHEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("ObjektLöschen", 		Byte
	.valueOf("16"));

	/**
	Antwort auf einen Löschauftrag.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_17_ANTWORTOBJEKTLOESCHEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("AntwortObjektLöschen", 		Byte
	.valueOf("17"));

	/**
	Auftrag, ein gelöschtes Konfigurationsobjekt vor der Aktivierung wieder gültig zu machen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_18_OBJEKTWIEDERHERSTELLEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("ObjektWiederherstellen", 		Byte
	.valueOf("18"));

	/**
	Antwort auf einen Wiederherstellungs-Auftrag.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_19_ANTWORTOBJEKTWIEDERHERSTELLEN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("AntwortObjektWiederherstellen", 		Byte
	.valueOf("19"));

	/**
	Auftrag, den Namen eines Objekts zu ändern.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_20_OBJEKTNAMENAENDERN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("ObjektNamenÄndern", 		Byte
	.valueOf("20"));

	/**
	Antwort auf den Auftrag, einen Objektnamen zu ändern.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsAnfrageNachrichtenTypSchreibend ZUSTAND_21_ANTWORTOBJEKTNAMENAENDERN = new AttKonfigurationsAnfrageNachrichtenTypSchreibend("AntwortObjektNamenÄndern", 		Byte
	.valueOf("21"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKonfigurationsAnfrageNachrichtenTypSchreibend getZustand(final 		Byte
	 value) {
		for (AttKonfigurationsAnfrageNachrichtenTypSchreibend e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKonfigurationsAnfrageNachrichtenTypSchreibend getZustand(final String value) {
		for (AttKonfigurationsAnfrageNachrichtenTypSchreibend e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKonfigurationsAnfrageNachrichtenTypSchreibend> getZustaende() {
		List<AttKonfigurationsAnfrageNachrichtenTypSchreibend> list = new ArrayList<AttKonfigurationsAnfrageNachrichtenTypSchreibend>();
		list.add(ZUSTAND_1_DYNAMISCHEMENGEELEMENTEAENDERN);
		list.add(ZUSTAND_2_DYNAMISCHEMENGEELEMENTEANTWORT);
		list.add(ZUSTAND_3_FEHLERANTWORT);
		list.add(ZUSTAND_4_KONFIGURIERENDENDATENSATZFESTLEGEN);
		list.add(ZUSTAND_5_KONFIGURIERENDENDATENSATZFESTLEGENANTWORT);
		list.add(ZUSTAND_6_KONFIGURATIONSAENDERUNGVERWEIGERT);
		list.add(ZUSTAND_7_KONFIGURIERENDEMENGEELEMENTEAENDERN);
		list.add(ZUSTAND_8_KONFIGURIERENDEMENGEELEMENTEANTWORT);
		list.add(ZUSTAND_9_OBJEKTANLEGEN);
		list.add(ZUSTAND_10_ANTWORTOBJEKTANLEGEN);
		list.add(ZUSTAND_11_OBJEKTKOPIEREN);
		list.add(ZUSTAND_12_ANTWORTOBJEKTKOPIEREN);
		list.add(ZUSTAND_13_OBJEKTMENGENBEARBEITEN);
		list.add(ZUSTAND_14_ANTWORTOBJEKTMENGENBEARBEITEN);
		list.add(ZUSTAND_15_DYNAMISCHESOBJEKTMITKONFIGURIERENDENDATENSAETZENANLEGEN);
		list.add(ZUSTAND_16_OBJEKTLOESCHEN);
		list.add(ZUSTAND_17_ANTWORTOBJEKTLOESCHEN);
		list.add(ZUSTAND_18_OBJEKTWIEDERHERSTELLEN);
		list.add(ZUSTAND_19_ANTWORTOBJEKTWIEDERHERSTELLEN);
		list.add(ZUSTAND_20_OBJEKTNAMENAENDERN);
		list.add(ZUSTAND_21_ANTWORTOBJEKTNAMENAENDERN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KonfigurationsNachrichtenTypSchreibend.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKonfigurationsAnfrageNachrichtenTypSchreibend(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKonfigurationsAnfrageNachrichtenTypSchreibend(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
