/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Nachrichten bei der Abwicklung von Konfigurationsanfragen(Benutzerverwaltung)
					dient.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class AttKonfigurationsBereichsverwaltungsNachrichtenTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kennzeichnet Antworten mit einem Fehlertext bei fehlgeschlagenen Anfragen.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_1_FEHLERANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("FehlerAntwort", 		Byte
	.valueOf("1"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration die übergebenen Konfigurationsbereiche einer Konsistenzprüfung zu
								unterziehen.
	<p>
	Beauftragt die Konfiguration bestimmte Konfigurationsbereiche in bestimmten Versionen gemeinsam einer Konsistenzprüfung zu
								unterziehen. Die Bereiche werden nur der Prüfung unterzogen, es findet keine Änderung in der Konfiguration statt.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_2_BEREICHEPRUEFEN = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereichePrüfen", 		Byte
	.valueOf("2"));

	/**
	Positives oder negatives Ergebnis einer Konsistenzprüfung.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_3_BEREICHEPRUEFENANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereichePrüfenAntwort", 		Byte
	.valueOf("3"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration die übergebenen Konfigurationsbereiche zu aktivieren.
	<p>
	Beauftragt die Konfiguration bestimmte Konfigurationsbereiche in bestimmten Versionen gemeinsam einer Konsistenzprüfung zu
								unterziehen und diese bei positiver Prüfung zu aktivieren. Die Konfigurationsbereiche werden beim nächsten Neustart der
								Konfiguration in den übergebenen Versionen aktiv.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_4_BEREICHEAKTIVIEREN = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheAktivieren", 		Byte
	.valueOf("4"));

	/**
	Positives oder negatives Ergebnis auf einen Auftrag bestimmte Konfigurationsbereiche zu aktivieren.
	<p>
	Bei einem positiven Ergebnis werden die Konfigurationsbereiche bei einem Neustart der Konfiguration aktiviert. Bei einem negativen
								Ergebnis bleiben die Konfigurationsbereiche in ihrer aktuellen Version (auch bei einem Neustart der Konfiguration).
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_5_BEREICHEAKTIVIERENANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheAktivierenAntwort", 		Byte
	.valueOf("5"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration die übergebenen Konfigurationsbereiche in den Zustand "Freigabe zur Übernahme"
								zu überführen.
	<p>
	Beauftragt die Konfiguration bestimmte Konfigurationsbereiche in bestimmten Versionen gemeinsam einer Konsistenzprüfung zu
								unterziehen und diese bei positiver Prüfung zur Übernahme freizugeben. Dieser Zustand ist, bei positiver Prüfung, sofort
								aktiv.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_6_BEREICHEFREIGABEZURUEBERNAHME = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheFreigabeZurÜbernahme", 		Byte
	.valueOf("6"));

	/**
	Positives oder negatives Ergebnis auf einen Auftrag bestimmte Konfigurationsbereiche zur Übernahme freizugeben.
	<p>
	Bei einem positiven Ergebnis werden die Konfigurationsbereiche sofort zur Übernahme freigegeben. Bei einem negativen Ergebnis
								bleiben die Konfigurationsbereiche in der letzten Version, die zur Übernahme freigegeben wurde. Es findet keine Änderung
								statt.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_7_BEREICHEFREIGABEZURUEBERNAHMEANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheFreigabeZurÜbernahmeAntwort", 		Byte
	.valueOf("7"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration die übergebenen Konfigurationsbereiche in den Zustand "Freigabe zur
								Aktivierung" zu überführen.
	<p>
	Beauftragt die Konfiguration bestimmte Konfigurationsbereiche in bestimmten Versionen gemeinsam zur Aktivierung freizugeben. Dieser
								Zustand ist, bei positiver Prüfung, sofort aktiv.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_8_BEREICHEFREIGABEZURAKTIVIERUNG = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheFreigabeZurAktivierung", 		Byte
	.valueOf("8"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration die übergebenen Konfigurationsbereiche in den Zustand "Freigabe zur
								Aktivierung" zu überführen.
	<p>
	Beauftragt die Konfiguration bestimmte Konfigurationsbereiche in bestimmten Versionen gemeinsam zur Aktivierung freizugeben. Dieser
								Zustand ist, bei positiver Prüfung, sofort aktiv.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_9_BEREICHEFREIGABEZURAKTIVIERUNGANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheFreigabeZurAktivierungAntwort", 		Byte
	.valueOf("9"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration einen Konfigurationsbereich zu erzeugen.
	<p>
	Beauftragt die Konfiguration einen Konfigurationsbereich zu erzeugen. Der Bereich ist nicht aktiv.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_10_BEREICHANLEGEN = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereichAnlegen", 		Byte
	.valueOf("10"));

	/**
	Konfigurationsbereich, der neu angelegt wurde.
	<p>
	Positive Antwort auf den Auftrag einen Konfigurationsbereich neu anzulegen. Die Antwort enthält die Id des neuen
								Bereichs.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_11_BEREICHANLEGENANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereichAnlegenAntwort", 		Byte
	.valueOf("11"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration bestimmte Konfigurationsbereich zu importieren.
	<p>
	Beauftragt die Konfiguration Konfigurationsbereiche aus einem bestimmten Verzeichnis zu importieren. Die Bereiche und das
								Verzeichnis sind im Telegramm enthalten.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_12_BEREICHEIMPORTIEREN = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheImportieren", 		Byte
	.valueOf("12"));

	/**
	Positive Antwort auf den Auftrag bestimmte Konfigurationsbereiche zu importieren.
	<p>
	Positive Antwort auf den Auftrag bestimmte Konfigurationsbereiche zu importieren. Die Nachricht enthält keine weiteren
								Daten.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_13_BEREICHEIMPORTIERENANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BereicheImportierenAntwort", 		Byte
	.valueOf("13"));

	/**
	Negative Antwort auf einen Auftrag, der Änderungen in der Konfiguration hervorgerufen hätte.
	<p>
	Diese Nachricht wird verschickt, wenn die Konfiguration eine Änderung in der Konfiguration nicht ausführt, weil gewisse
								Randbediengungen nicht erfüllt sind. Einige Beispiele wären: Bereich aktivieren, obwohl der Bereich noch nicht zur Aktivierung
								freigegeben war; Bereich anlegen wurde verweigert (Pid schon vergeben); usw.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_14_KONFIGURATIONSAENDERUNGVERWEIGERT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("KonfigurationsänderungVerweigert", 		Byte
	.valueOf("14"));

	/**
	Negative Antwort auf einen Auftrag, der der Konfiguration erteilt wurde.
	<p>
	Diese Nachricht wird verschickt, wenn die Konfiguration einen Auftrag nicht ausführt, weil gewisse Randbediengungen nicht erfüllt
								sind.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_15_KONFIGURATIONSAUFTRAGVERWEIGERT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("KonfigurationsauftragVerweigert", 		Byte
	.valueOf("15"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration alle Konfigurationsbereiche zurück zu geben.
	<p>
	Beauftragt die Konfiguration alle Konfigurationsbereiche zurück zu geben. Es werde auch Bereiche zurückgegeben,
								die noch nicht aktiviert wurden.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_16_ALLEBEREICHEANFORDERN = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("AlleBereicheAnfordern", 		Byte
	.valueOf("16"));

	/**
	Alle Bereiche die mit AlleBereicheAnfordern angefordert wurden.
	<p>
	
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_17_ALLEBEREICHEANFORDERNANTWORT = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("AlleBereicheAnfordernAntwort", 		Byte
	.valueOf("17"));

	/**
	Kennzeichnet einen Auftrag an die Konfiguration die Konfigurationsdateien zu sichern.
	<p>
	Kennzeichnet eine Anfrage an die Konfiguration, eine Sicherung der Konfigurationsdateien anzulegen. Als Daten ist ein
								serialisierter String mit dem Zielverzeichnis anzugeben.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_18_BACKUPKONFIGURATIONSDATEN = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("BackupKonfigurationsdaten", 		Byte
	.valueOf("18"));

	/**
	Antwort auf einen Auftrag die Konfigurationsdateien zu sichern.
	<p>
	Daten enthalten Informationen über den Zustand und Fortschritt der Sicherung in serialisierter Form.
								Pro Sicherungsauftrag werden mindestens 2 Antworten verschickt.
	</p>
	*/
	public static final AttKonfigurationsBereichsverwaltungsNachrichtenTyp ZUSTAND_19_ANTWORTBACKUPKONFIGURATIONSDATEN = new AttKonfigurationsBereichsverwaltungsNachrichtenTyp("AntwortBackupKonfigurationsdaten", 		Byte
	.valueOf("19"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKonfigurationsBereichsverwaltungsNachrichtenTyp getZustand(final 		Byte
	 value) {
		for (AttKonfigurationsBereichsverwaltungsNachrichtenTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKonfigurationsBereichsverwaltungsNachrichtenTyp getZustand(final String value) {
		for (AttKonfigurationsBereichsverwaltungsNachrichtenTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKonfigurationsBereichsverwaltungsNachrichtenTyp> getZustaende() {
		List<AttKonfigurationsBereichsverwaltungsNachrichtenTyp> list = new ArrayList<AttKonfigurationsBereichsverwaltungsNachrichtenTyp>();
		list.add(ZUSTAND_1_FEHLERANTWORT);
		list.add(ZUSTAND_2_BEREICHEPRUEFEN);
		list.add(ZUSTAND_3_BEREICHEPRUEFENANTWORT);
		list.add(ZUSTAND_4_BEREICHEAKTIVIEREN);
		list.add(ZUSTAND_5_BEREICHEAKTIVIERENANTWORT);
		list.add(ZUSTAND_6_BEREICHEFREIGABEZURUEBERNAHME);
		list.add(ZUSTAND_7_BEREICHEFREIGABEZURUEBERNAHMEANTWORT);
		list.add(ZUSTAND_8_BEREICHEFREIGABEZURAKTIVIERUNG);
		list.add(ZUSTAND_9_BEREICHEFREIGABEZURAKTIVIERUNGANTWORT);
		list.add(ZUSTAND_10_BEREICHANLEGEN);
		list.add(ZUSTAND_11_BEREICHANLEGENANTWORT);
		list.add(ZUSTAND_12_BEREICHEIMPORTIEREN);
		list.add(ZUSTAND_13_BEREICHEIMPORTIERENANTWORT);
		list.add(ZUSTAND_14_KONFIGURATIONSAENDERUNGVERWEIGERT);
		list.add(ZUSTAND_15_KONFIGURATIONSAUFTRAGVERWEIGERT);
		list.add(ZUSTAND_16_ALLEBEREICHEANFORDERN);
		list.add(ZUSTAND_17_ALLEBEREICHEANFORDERNANTWORT);
		list.add(ZUSTAND_18_BACKUPKONFIGURATIONSDATEN);
		list.add(ZUSTAND_19_ANTWORTBACKUPKONFIGURATIONSDATEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut KonfigurationsBereichsverwaltungsNachrichtenTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKonfigurationsBereichsverwaltungsNachrichtenTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKonfigurationsBereichsverwaltungsNachrichtenTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
