/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ der Anfrage an die Paramterierung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AttParametrierungsAnfrageTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_1_PARAMETERSCHREIBEN = new AttParametrierungsAnfrageTyp("ParameterSchreiben", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_2_PARAMETERLESEN = new AttParametrierungsAnfrageTyp("ParameterLesen", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_3_PARAMETER = new AttParametrierungsAnfrageTyp("Parameter", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_4_SUCHEPARAMETERWURZEL = new AttParametrierungsAnfrageTyp("SucheParameterWurzel", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_5_PARAMETERWURZEL = new AttParametrierungsAnfrageTyp("ParameterWurzel", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_6_SUCHEAENDERBAREOBJEKTE = new AttParametrierungsAnfrageTyp("SucheÄnderbareObjekte", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_7_AENDERBAREOBJEKTE = new AttParametrierungsAnfrageTyp("ÄnderbareObjekte", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_8_SUCHEVORGAENGER = new AttParametrierungsAnfrageTyp("SucheVorgänger", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_9_VORGAENGER = new AttParametrierungsAnfrageTyp("Vorgänger", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_10_SUCHENACHFOLGER = new AttParametrierungsAnfrageTyp("SucheNachfolger", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttParametrierungsAnfrageTyp ZUSTAND_11_NACHFOLGER = new AttParametrierungsAnfrageTyp("Nachfolger", 		Byte
	.valueOf("11"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttParametrierungsAnfrageTyp getZustand(final 		Byte
	 value) {
		for (AttParametrierungsAnfrageTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttParametrierungsAnfrageTyp getZustand(final String value) {
		for (AttParametrierungsAnfrageTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttParametrierungsAnfrageTyp> getZustaende() {
		List<AttParametrierungsAnfrageTyp> list = new ArrayList<AttParametrierungsAnfrageTyp>();
		list.add(ZUSTAND_1_PARAMETERSCHREIBEN);
		list.add(ZUSTAND_2_PARAMETERLESEN);
		list.add(ZUSTAND_3_PARAMETER);
		list.add(ZUSTAND_4_SUCHEPARAMETERWURZEL);
		list.add(ZUSTAND_5_PARAMETERWURZEL);
		list.add(ZUSTAND_6_SUCHEAENDERBAREOBJEKTE);
		list.add(ZUSTAND_7_AENDERBAREOBJEKTE);
		list.add(ZUSTAND_8_SUCHEVORGAENGER);
		list.add(ZUSTAND_9_VORGAENGER);
		list.add(ZUSTAND_10_SUCHENACHFOLGER);
		list.add(ZUSTAND_11_NACHFOLGER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttParametrierungsAnfrageTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttParametrierungsAnfrageTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
