/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe für grundlegende Eigenschaften einer Applikation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 40
 */
public class KdApplikationsEigenschaften extends AbstractKonfigurationsDatensatz<KdApplikationsEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				 _datenverteiler
				;
				@Defaultwert(wert = "undefiniert")
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 _benutzer
				;
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.datenverteiler.
			<p>
			
			</p>
			
			@return der Wert von Datenverteiler.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				 getDatenverteiler() {
				return _datenverteiler;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.datenverteiler.
			<p>
			
			</p>
			
			@param _datenverteiler der neue Wert von Datenverteiler.
			*/
			public void setDatenverteiler(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
			 _datenverteiler) {
				this._datenverteiler = _datenverteiler;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer (Optionale Referenzierung erlaubt).
			<p>
			
			</p>
			
			@return der Wert von Benutzer.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 getBenutzer() {
				return _benutzer;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer (Optionale Referenzierung erlaubt).
			<p>
			
			</p>
			
			@param _benutzer der neue Wert von Benutzer.
			*/
			public void setBenutzer(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _benutzer) {
				this._benutzer = _benutzer;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soDatenverteiler = getDatenverteiler();
						final SystemObject tmpDatenverteiler;
							if (soDatenverteiler instanceof SystemObject) {
								tmpDatenverteiler = (SystemObject)soDatenverteiler;
							} else if(soDatenverteiler instanceof SystemObjekt){
								tmpDatenverteiler = ((SystemObjekt)soDatenverteiler).getSystemObject();
							} else{
								tmpDatenverteiler = null;
							}
						datum.getReferenceValue("Datenverteiler").setSystemObject(tmpDatenverteiler);
					// ObjektReferenzAttributTyp
						final Object soBenutzer = getBenutzer();
						final SystemObject tmpBenutzer;
							if (soBenutzer instanceof SystemObject) {
								tmpBenutzer = (SystemObject)soBenutzer;
							} else if(soBenutzer instanceof SystemObjekt){
								tmpBenutzer = ((SystemObjekt)soBenutzer).getSystemObject();
							} else{
								tmpBenutzer = null;
							}
						datum.getReferenceValue("Benutzer").setSystemObject(tmpBenutzer);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idDatenverteiler = daten.getReferenceValue("Datenverteiler").getId();
						final SystemObjekt tmpDatenverteiler;
						if (idDatenverteiler == 0) {
							tmpDatenverteiler = null;
						} else {
							final SystemObject soDatenverteiler = factory.getDav().getDataModel().getObject(idDatenverteiler);
							if (soDatenverteiler == null) {
									tmpDatenverteiler = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.DatenverteilerUngueltig(idDatenverteiler);
							} else {
								tmpDatenverteiler = factory.getModellobjekt(soDatenverteiler);
							}
						}
						setDatenverteiler((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
						) tmpDatenverteiler);
					// ObjektReferenzAttributTyp
						final long idBenutzer = daten.getReferenceValue("Benutzer").getId();
						final SystemObjekt tmpBenutzer;
						if (idBenutzer == 0) {
							tmpBenutzer = null;
						} else {
							final SystemObject soBenutzer = factory.getDav().getDataModel().getObject(idBenutzer);
							if (soBenutzer == null) {
									tmpBenutzer = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idBenutzer);
							} else {
								tmpBenutzer = factory.getModellobjekt(soBenutzer);
							}
						}
						setBenutzer((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
						) tmpBenutzer);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDatenverteiler(getDatenverteiler());
							klon.setBenutzer(getBenutzer());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.applikationsEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdApplikationsEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
