/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften eines Benutzers.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdBenutzerEigenschaften extends AbstractKonfigurationsDatensatz<KdBenutzerEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _vorname
				= new String
				()
				;
				private String
				 _zweiterVorname
				= new String
				()
				;
				private String
				 _nachname
				= new String
				()
				;
				private String
				 _organisation
				= new String
				()
				;
				private String
				 _emailAdresse
				= new String
				()
				;
		
			/**
			Vorname des Benutzers.
			<p>
			
			</p>
			
			@return der Wert von Vorname.
			*/
				public String
				 getVorname() {
				return _vorname;
			}
		
			/**
			Vorname des Benutzers.
			<p>
			
			</p>
			
			@param _vorname der neue Wert von Vorname.
			*/
			public void setVorname(String
			 _vorname) {
				if (_vorname.length() > 64) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
				}
				this._vorname = _vorname;
			}
		
			/**
			Zweiter Vorname des Benutzers.
			<p>
			
			</p>
			
			@return der Wert von ZweiterVorname.
			*/
				public String
				 getZweiterVorname() {
				return _zweiterVorname;
			}
		
			/**
			Zweiter Vorname des Benutzers.
			<p>
			
			</p>
			
			@param _zweiterVorname der neue Wert von ZweiterVorname.
			*/
			public void setZweiterVorname(String
			 _zweiterVorname) {
				if (_zweiterVorname.length() > 64) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
				}
				this._zweiterVorname = _zweiterVorname;
			}
		
			/**
			Nachname des Benutzers.
			<p>
			
			</p>
			
			@return der Wert von Nachname.
			*/
				public String
				 getNachname() {
				return _nachname;
			}
		
			/**
			Nachname des Benutzers.
			<p>
			
			</p>
			
			@param _nachname der neue Wert von Nachname.
			*/
			public void setNachname(String
			 _nachname) {
				if (_nachname.length() > 64) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
				}
				this._nachname = _nachname;
			}
		
			/**
			Name der Verwaltung oder Firma, der dieser Benutzer angehört.
			<p>
			
			</p>
			
			@return der Wert von Organisation.
			*/
				public String
				 getOrganisation() {
				return _organisation;
			}
		
			/**
			Name der Verwaltung oder Firma, der dieser Benutzer angehört.
			<p>
			
			</p>
			
			@param _organisation der neue Wert von Organisation.
			*/
			public void setOrganisation(String
			 _organisation) {
				if (_organisation.length() > 64) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
				}
				this._organisation = _organisation;
			}
		
			/**
			E-Mail Adresse des Benutzers.
			<p>
			
			</p>
			
			@return der Wert von EmailAdresse.
			*/
				public String
				 getEmailAdresse() {
				return _emailAdresse;
			}
		
			/**
			E-Mail Adresse des Benutzers.
			<p>
			
			</p>
			
			@param _emailAdresse der neue Wert von EmailAdresse.
			*/
			public void setEmailAdresse(String
			 _emailAdresse) {
				if (_emailAdresse.length() > 64) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
				}
				this._emailAdresse = _emailAdresse;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getVorname() != null) {
						datum.getTextValue("vorname").setText(getVorname());
					}
					// ZeichenkettenAttributTyp
					if (getZweiterVorname() != null) {
						datum.getTextValue("zweiterVorname").setText(getZweiterVorname());
					}
					// ZeichenkettenAttributTyp
					if (getNachname() != null) {
						datum.getTextValue("nachname").setText(getNachname());
					}
					// ZeichenkettenAttributTyp
					if (getOrganisation() != null) {
						datum.getTextValue("organisation").setText(getOrganisation());
					}
					// ZeichenkettenAttributTyp
					if (getEmailAdresse() != null) {
						datum.getTextValue("emailAdresse").setText(getEmailAdresse());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setVorname(daten.getTextValue("vorname").getText());
					// ZeichenkettenAttributTyp
						setZweiterVorname(daten.getTextValue("zweiterVorname").getText());
					// ZeichenkettenAttributTyp
						setNachname(daten.getTextValue("nachname").getText());
					// ZeichenkettenAttributTyp
						setOrganisation(daten.getTextValue("organisation").getText());
					// ZeichenkettenAttributTyp
						setEmailAdresse(daten.getTextValue("emailAdresse").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVorname(getVorname());
							klon.setZweiterVorname(getZweiterVorname());
							klon.setNachname(getNachname());
							klon.setOrganisation(getOrganisation());
							klon.setEmailAdresse(getEmailAdresse());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.benutzerEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdBenutzerEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
