/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften eines Datenverteilers.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdDatenverteilerEigenschaften extends AbstractKonfigurationsDatensatz<KdDatenverteilerEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _adresse
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttKommunikationsSubAdresse
				 _subAdresse
				;
		
			/**
			Adresse, über die die Verbindung zum jeweiligen Datenverteiler von anderen Datenverteilern hergestellt werden kann.
			<p>
			
			</p>
			
			@return der Wert von Adresse.
			*/
				public String
				 getAdresse() {
				return _adresse;
			}
		
			/**
			Adresse, über die die Verbindung zum jeweiligen Datenverteiler von anderen Datenverteilern hergestellt werden kann.
			<p>
			
			</p>
			
			@param _adresse der neue Wert von Adresse.
			*/
			public void setAdresse(String
			 _adresse) {
				if (_adresse.length() > 64) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 64 + " Zeichen sein.");
				}
				this._adresse = _adresse;
			}
		
			/**
			Subadresse, über die die Verbindung zum jeweiligen Datenverteiler von anderen Datenverteilern hergestellt werden kann. Die
									Subadresse entspricht bei Verwendung von TCP der TCP-Portnummer. Innerhalb eines Rechners darf die vergebene TCP-Portnummer nicht von
									weiteren Datenverteilern oder anderen Prozessen benutzt werden.
			<p>
			
			</p>
			
			@return der Wert von SubAdresse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttKommunikationsSubAdresse
				 getSubAdresse() {
				return _subAdresse;
			}
		
			/**
			Subadresse, über die die Verbindung zum jeweiligen Datenverteiler von anderen Datenverteilern hergestellt werden kann. Die
									Subadresse entspricht bei Verwendung von TCP der TCP-Portnummer. Innerhalb eines Rechners darf die vergebene TCP-Portnummer nicht von
									weiteren Datenverteilern oder anderen Prozessen benutzt werden.
			<p>
			
			</p>
			
			@param _subAdresse der neue Wert von SubAdresse.
			*/
			public void setSubAdresse(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttKommunikationsSubAdresse
			 _subAdresse) {
				this._subAdresse = _subAdresse;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getAdresse() != null) {
						datum.getTextValue("adresse").setText(getAdresse());
					}
					// GanzzahlAttributTyp
					if (getSubAdresse() != null) {
		                if (getSubAdresse().isZustand()) {
		                    datum.getUnscaledValue("subAdresse").setText(getSubAdresse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("subAdresse").set(getSubAdresse().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setAdresse(daten.getTextValue("adresse").getText());
					// GanzzahlAttributTyp
							setSubAdresse(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttKommunikationsSubAdresse
							(daten.
								getUnscaledValue
							("subAdresse").
									intValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAdresse(getAdresse());
							klon.setSubAdresse(getSubAdresse());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.datenverteilerEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDatenverteilerEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
