/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert die Kommunikationstopologie der Datenverteiler als Eigenschaften der Datenverteilerverbindungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class KdDatenverteilerTopologie extends AbstractKonfigurationsDatensatz<KdDatenverteilerTopologie.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				 _datenverteilerA
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				 _datenverteilerB
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttVerbindungsWichtung
				 _wichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAktiveVerbindungsRolle
				 _aktiverDatenverteiler
				;
				private 	RelativerZeitstempel
				 _ersatzverbindungsWartezeit
				;
				private String
				 _benutzer1
				= new String
				()
				;
				private String
				 _benutzer2
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDurchsatzPruefungsParameter
				 _durchsatzPruefung
				= new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDurchsatzPruefungsParameter
				()
				;
		
			/**
			Erster an dieser Verbindung beteiligte Datenverteiler.
			<p>
			
			</p>
			
			@return der Wert von DatenverteilerA.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				 getDatenverteilerA() {
				return _datenverteilerA;
			}
		
			/**
			Erster an dieser Verbindung beteiligte Datenverteiler.
			<p>
			
			</p>
			
			@param _datenverteilerA der neue Wert von DatenverteilerA.
			*/
			public void setDatenverteilerA(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
			 _datenverteilerA) {
				this._datenverteilerA = _datenverteilerA;
			}
		
			/**
			Zweiter an dieser Verbindung beteiligte Datenverteiler.
			<p>
			
			</p>
			
			@return der Wert von DatenverteilerB.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				 getDatenverteilerB() {
				return _datenverteilerB;
			}
		
			/**
			Zweiter an dieser Verbindung beteiligte Datenverteiler.
			<p>
			
			</p>
			
			@param _datenverteilerB der neue Wert von DatenverteilerB.
			*/
			public void setDatenverteilerB(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
			 _datenverteilerB) {
				this._datenverteilerB = _datenverteilerB;
			}
		
			/**
			Wichtung dieser Verbindung.
			<p>
			Die Wichtung einer Verbindung wird zur Bestimmung des günstigsten Wegs zwischen Datenverteilern benutzt. Dazu werden die
									Wichtungswerte der Verbindungen jedes möglichen Wegs zwischen zwei Datenverteilern aufsummiert und der Weg mit der kleinsten Summe
									ausgewählt.
			</p>
			
			@return der Wert von Wichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttVerbindungsWichtung
				 getWichtung() {
				return _wichtung;
			}
		
			/**
			Wichtung dieser Verbindung.
			<p>
			Die Wichtung einer Verbindung wird zur Bestimmung des günstigsten Wegs zwischen Datenverteilern benutzt. Dazu werden die
									Wichtungswerte der Verbindungen jedes möglichen Wegs zwischen zwei Datenverteilern aufsummiert und der Weg mit der kleinsten Summe
									ausgewählt.
			</p>
			
			@param _wichtung der neue Wert von Wichtung.
			*/
			public void setWichtung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttVerbindungsWichtung
			 _wichtung) {
				this._wichtung = _wichtung;
			}
		
			/**
			Beschreibt von welchem Datenverteiler diese Verbindung aufgebaut werden soll.
			<p>
			
			</p>
			
			@return der Wert von AktiverDatenverteiler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAktiveVerbindungsRolle
				 getAktiverDatenverteiler() {
				return _aktiverDatenverteiler;
			}
		
			/**
			Beschreibt von welchem Datenverteiler diese Verbindung aufgebaut werden soll.
			<p>
			
			</p>
			
			@param _aktiverDatenverteiler der neue Wert von AktiverDatenverteiler.
			*/
			public void setAktiverDatenverteiler(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAktiveVerbindungsRolle
			 _aktiverDatenverteiler) {
				this._aktiverDatenverteiler = _aktiverDatenverteiler;
			}
		
			/**
			Wartezeit nach der Ersatzverbindungen aufgebaut werden.
			<p>
			Wenn die Verbindung nicht innerhalb der hier angegebenen Zeit aufgebaut werden kann, dann werden Ersatzverbindungen aufgebaut.
									Diese sind durch die Menge"Ersatzverbindungen" an der betroffenen Verbindung spezifiziert.
			</p>
			
			@return der Wert von ErsatzverbindungsWartezeit.
			*/
				public 	RelativerZeitstempel
				 getErsatzverbindungsWartezeit() {
				return _ersatzverbindungsWartezeit;
			}
		
			/**
			Wartezeit nach der Ersatzverbindungen aufgebaut werden.
			<p>
			Wenn die Verbindung nicht innerhalb der hier angegebenen Zeit aufgebaut werden kann, dann werden Ersatzverbindungen aufgebaut.
									Diese sind durch die Menge"Ersatzverbindungen" an der betroffenen Verbindung spezifiziert.
			</p>
			
			@param _ersatzverbindungsWartezeit der neue Wert von ErsatzverbindungsWartezeit.
			*/
			public void setErsatzverbindungsWartezeit(	RelativerZeitstempel
			 _ersatzverbindungsWartezeit) {
				this._ersatzverbindungsWartezeit = _ersatzverbindungsWartezeit;
			}
		
			/**
			Name des Benutzers mit dem sich Datenverteiler 1 bei Datenverteiler 2 authentifizieren soll.
			<p>
			
			</p>
			
			@return der Wert von Benutzer1.
			*/
				public String
				 getBenutzer1() {
				return _benutzer1;
			}
		
			/**
			Name des Benutzers mit dem sich Datenverteiler 1 bei Datenverteiler 2 authentifizieren soll.
			<p>
			
			</p>
			
			@param _benutzer1 der neue Wert von Benutzer1.
			*/
			public void setBenutzer1(String
			 _benutzer1) {
				if (_benutzer1.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._benutzer1 = _benutzer1;
			}
		
			/**
			Name des Benutzers mit dem sich Datenverteiler 2 bei Datenverteiler 1 authentifizieren soll.
			<p>
			
			</p>
			
			@return der Wert von Benutzer2.
			*/
				public String
				 getBenutzer2() {
				return _benutzer2;
			}
		
			/**
			Name des Benutzers mit dem sich Datenverteiler 2 bei Datenverteiler 1 authentifizieren soll.
			<p>
			
			</p>
			
			@param _benutzer2 der neue Wert von Benutzer2.
			*/
			public void setBenutzer2(String
			 _benutzer2) {
				if (_benutzer2.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._benutzer2 = _benutzer2;
			}
		
			/**
			Parameter, die für die Durchsatzprüfung dieser Verbindung von beiden Datenverteilern benutzt werden sollen.
			<p>
			
			</p>
			
			@return der Wert von DurchsatzPruefung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDurchsatzPruefungsParameter
				 getDurchsatzPruefung() {
				return _durchsatzPruefung;
			}
		
			/**
			Parameter, die für die Durchsatzprüfung dieser Verbindung von beiden Datenverteilern benutzt werden sollen.
			<p>
			
			</p>
			
			@param _durchsatzPruefung der neue Wert von DurchsatzPruefung.
			*/
			public void setDurchsatzPruefung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlDurchsatzPruefungsParameter
			 _durchsatzPruefung) {
				this._durchsatzPruefung = _durchsatzPruefung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soDatenverteilerA = getDatenverteilerA();
						final SystemObject tmpDatenverteilerA;
							if (soDatenverteilerA instanceof SystemObject) {
								tmpDatenverteilerA = (SystemObject)soDatenverteilerA;
							} else if(soDatenverteilerA instanceof SystemObjekt){
								tmpDatenverteilerA = ((SystemObjekt)soDatenverteilerA).getSystemObject();
							} else{
								tmpDatenverteilerA = null;
							}
						datum.getReferenceValue("datenverteilerA").setSystemObject(tmpDatenverteilerA);
					// ObjektReferenzAttributTyp
						final Object soDatenverteilerB = getDatenverteilerB();
						final SystemObject tmpDatenverteilerB;
							if (soDatenverteilerB instanceof SystemObject) {
								tmpDatenverteilerB = (SystemObject)soDatenverteilerB;
							} else if(soDatenverteilerB instanceof SystemObjekt){
								tmpDatenverteilerB = ((SystemObjekt)soDatenverteilerB).getSystemObject();
							} else{
								tmpDatenverteilerB = null;
							}
						datum.getReferenceValue("datenverteilerB").setSystemObject(tmpDatenverteilerB);
					// GanzzahlAttributTyp
					if (getWichtung() != null) {
		                if (getWichtung().isZustand()) {
		                    datum.getUnscaledValue("wichtung").setText(getWichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("wichtung").set(getWichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAktiverDatenverteiler() != null) {
		                if (getAktiverDatenverteiler().isZustand()) {
		                    datum.getUnscaledValue("aktiverDatenverteiler").setText(getAktiverDatenverteiler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("aktiverDatenverteiler").set(getAktiverDatenverteiler().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("ersatzverbindungsWartezeit").setMillis(getErsatzverbindungsWartezeit().getTime());
					// ZeichenkettenAttributTyp
					if (getBenutzer1() != null) {
						datum.getTextValue("benutzer1").setText(getBenutzer1());
					}
					// ZeichenkettenAttributTyp
					if (getBenutzer2() != null) {
						datum.getTextValue("benutzer2").setText(getBenutzer2());
					}
					// AttributListenDefinition
						getDurchsatzPruefung().bean2Atl(datum.getItem("durchsatzPrüfung"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idDatenverteilerA = daten.getReferenceValue("datenverteilerA").getId();
						final SystemObjekt tmpDatenverteilerA;
						if (idDatenverteilerA == 0) {
							tmpDatenverteilerA = null;
						} else {
							final SystemObject soDatenverteilerA = factory.getDav().getDataModel().getObject(idDatenverteilerA);
							if (soDatenverteilerA == null) {
									tmpDatenverteilerA = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.DatenverteilerUngueltig(idDatenverteilerA);
							} else {
								tmpDatenverteilerA = factory.getModellobjekt(soDatenverteilerA);
							}
						}
						setDatenverteilerA((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
						) tmpDatenverteilerA);
					// ObjektReferenzAttributTyp
						final long idDatenverteilerB = daten.getReferenceValue("datenverteilerB").getId();
						final SystemObjekt tmpDatenverteilerB;
						if (idDatenverteilerB == 0) {
							tmpDatenverteilerB = null;
						} else {
							final SystemObject soDatenverteilerB = factory.getDav().getDataModel().getObject(idDatenverteilerB);
							if (soDatenverteilerB == null) {
									tmpDatenverteilerB = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.DatenverteilerUngueltig(idDatenverteilerB);
							} else {
								tmpDatenverteilerB = factory.getModellobjekt(soDatenverteilerB);
							}
						}
						setDatenverteilerB((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
						) tmpDatenverteilerB);
					// GanzzahlAttributTyp
							setWichtung(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttVerbindungsWichtung
							(daten.
								getUnscaledValue
							("wichtung").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("aktiverDatenverteiler").isState()) {
								setAktiverDatenverteiler(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAktiveVerbindungsRolle
								.getZustand(daten.getScaledValue("aktiverDatenverteiler").getText()));
							} else {
							setAktiverDatenverteiler(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAktiveVerbindungsRolle
							(daten.
								getUnscaledValue
							("aktiverDatenverteiler").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setErsatzverbindungsWartezeit(new
							RelativerZeitstempel
							(daten.getTimeValue("ersatzverbindungsWartezeit").getMillis()));
					// ZeichenkettenAttributTyp
						setBenutzer1(daten.getTextValue("benutzer1").getText());
					// ZeichenkettenAttributTyp
						setBenutzer2(daten.getTextValue("benutzer2").getText());
					// AttributListenDefinition
						getDurchsatzPruefung().atl2Bean(daten.getItem("durchsatzPrüfung"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDatenverteilerA(getDatenverteilerA());
							klon.setDatenverteilerB(getDatenverteilerB());
							klon.setWichtung(getWichtung());
							klon.setAktiverDatenverteiler(getAktiverDatenverteiler());
							klon.setErsatzverbindungsWartezeit(getErsatzverbindungsWartezeit());
							klon.setBenutzer1(getBenutzer1());
							klon.setBenutzer2(getBenutzer2());
							klon._durchsatzPruefung = getDurchsatzPruefung().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.datenverteilerTopologie";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDatenverteilerTopologie(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
