/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert ein Archiv mit seinen Eigenschaften.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface Archiv extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.archiv"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Statusinformation Archiv für die Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsStatusArchiv.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusArchiv getOdSimulationsStatusArchiv();
	
	/**
	Attributgruppe zur Publikation des freien Festplatten-Speicherplatzes des Archivsystems.
	<p>
	
	</p>
	@return der Datensatz ArchivSpeicherplatz.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivSpeicherplatz getOdArchivSpeicherplatz();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Allgemeine Einstellungen zum Archivsystem.
	<p>
	&lt;absatz&gt;Dieser Parameter fasst folgende Einstellung des Archivsystems zusammen:&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Maximaler Archivzeitsprung vorwärts T
								&lt;tief&gt;max&lt;&#47;tief&gt;
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Sicherungsintervall&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Löschintervall&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Nachforderungsintervall&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Spontanes Löschen&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Löschschutz&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl Bytes, die pro Anfrage zur Pufferung genutzt werden können&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Maximale Anzahl der noch nicht quittierten übertragenen Blöcke pro Stream&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen hoher Priorität&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen mittlerer Priorität&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen niedriger Priorität&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz ArchivEinstellung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivEinstellung getPdArchivEinstellung();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Archivanfragen dienen.
	<p>
	&lt;absatz&gt;
							Wird vom streambasierten Archivanfragemechanismus für die Übertragung von Anfragen und entsprechende Antworten zwischen der
							Archivanfragebibliothek (innerhalb von Applikationen) und dem Archivsystem benutzt. Außerdem wird diese Attributgruppe für
							Steuerungsnachrichten insbesondere zur Flußkontrolle bei der streambasierten Übertragung von Archivantworten benutzt.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ArchivAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrageSchnittstelle getOdArchivAnfrageSchnittstelle();
	
	/**
	Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit der die
						Archivierung parametriert wird.
	<p>
	&lt;absatz&gt;Potentiell können durch das Archivsystem alle im System durch die Applikationen bereitgestellten Daten archiviert werden. Welche
							Daten tatsächlich archiviert werden sollen, ist online parametrierbar. Zur Spezifikation, welche Daten archiviert werden sollen, müssen
							folgende Angaben gemacht werden:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Angabe der Konfigurationsobjekte, zu denen Datensätze archiviert werden sollen&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Attributgruppen&#47;Aspektkombinationen und Simulationsvariante&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Archivierungseinstellungen&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Der hierfür notwendige Parametersatz weist eine flexible Struktur auf, die es ermöglicht, neben ganz konkreten Spezifikationen, zu
							welchem Konfigurationsobjekt die Datensätze welcher Attributgruppen&#47;Aspektkombination archiviert werden sollen, "flächendeckende"
							Angaben zu tätigen, um den Parametrierungsaufwand zu minimieren.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "ParameterSatz [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste dient zur Zusammenfassung einer (Teil)Spezifikation, zu welchen Konfigurationsobjekten welche Datensätze unter
							welchen Einstellungen archiviert werden sollen. Die Attributgruppe zur Parametrierung des Archivsystems besteht aus einem Feld mit
							beliebig vielen dieser Attributlisten.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Bereich [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Die in der folgenden Attributliste "Datenspezifikation" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
							Konfigurationsbereich.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "DatenSpezifikation [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
							folgenden Einstellungen gelten. Diese Attributliste kann innerhalb der Attributliste "Archivsystem Parameter" beliebig oft enthalten
							sein.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Objekte [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut können beliebig viele Konfigurationsobjekte angegeben werden, für die Datensätze archiviert werden sollen. Die
							Spezifikation der gewünschten Konfigurationsobjekte erfolgt über die direkte Angabe von einzelnen Konfigurationsobjekten (z.B. über die
							PID), über die Angabe einer Menge (z.B. Menge der MQ) oder durch die Angabe von Typen (z.B. Typ MQ). Bei der Angabe von Objekttypen
							werden alle Konfigurationsobjekte dieses Typs aus den Konfigurationsbereichen ausgewählt, die über das Attribut "Bereich" spezifiziert
							wurden.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "AttributGruppe [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Attributgruppen spezifiziert, die für die ausgewählten Konfigurationsobjekte archiviert werden
							sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Aspekt [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Aspekte spezifiziert, unter denen die angegebenen Attributgruppen für die ausgewählten
							Konfigurationsobjekte archiviert werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "SimulationsVariante [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den angegebenen
							Aspekten für die ausgewählten Konfigurationsobjekte archiviert werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "Einstellungen [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation zu archivierenden Datensätze zu behandeln
							sind, zusammen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Archivieren"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu archivieren sind ("Ja" oder "Nein"). Wird an dieser Stelle "Nein"
							angegeben, sind die weiteren Attribute der Attributliste "Einstellungen" obsolet.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Nachfordern [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob Daten bei potentiell erkannter Datenlücken von anderen Archivsystemen nachgefordert werden
							sollen. Das Attribut stellt ein Array dar, in dem die Archivsysteme aufgeführt sind, bei denen nachgefragt werden soll.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Sichern"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu sichern sind ("Ja" oder "Nein").&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Quittieren"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu quittieren sind. In diesem Fall wird an dieser Stelle der Aspekt
							spezifiziert, unter dem die entsprechenden Attributgruppen nach erfolgreicher Archivierung publiziert werden.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Vorhalten"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird spezifiziert, wie lange sich die zu archivierenden Datensätze im direkten Zugriff des Archivsystems
							befinden sollen. Bei der Datenspezifikation mit der Attributliste werden die Objekte, Attributgruppen und Aspekte in voneinander
							unabhängigen Feldern spezifiziert. Für jede Kombination der Angabe in den drei Feldern gelten die in der Attributliste Einstellungen
							vorgegebenen Parameter. Dabei ist zu beachten, dass nur sinnvolle Kombinationen betrachtet werden; d.h. es werden natürlich nur die
							Attributgruppen&#47;Aspektkombinationen für ein Konfigurationsobjekt angemeldet, die laut Konfiguration bei einem Konfigurationsobjekt des
							entsprechenden Typs möglich sind. Weiter ist zu beachten, dass durch die Auslegung der Attributliste "Archivsystem Parameter" als Feld
							eine Überlagerung von gleichen Tupeln möglich ist. In diesem Fall setzt sich die Spezifikation im Datensatz mit dem höchsten Feldindex
							durch.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz Archiv.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchiv getPdArchiv();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Enthält die Parameter zum endgültigen Löschen.
	<p>
	&lt;absatz&gt;
							Ein Parameterdatensatz dieser Attributgruppe enthält globale Einstellungen und spezifische
							Einstellungen für verschiedene Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante)
							zum endgültigen Löschen.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ArchivDatenEndgueltigLoeschen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivDatenEndgueltigLoeschen getPdArchivDatenEndgueltigLoeschen();
	
	/**
	Allgemeine Einstellungen zum Persistenzmodul.
	<p>
	&lt;absatz&gt;Dieser Parameter fasst folgende Einstellung des Persistenzmoduls zusammen:&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Puffergröße des Containers&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Maximale Pufferzeit&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz ArchivContainerPersistenzEinstellung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainerPersistenzEinstellung getPdArchivContainerPersistenzEinstellung();
	
	/**
	Attributgruppe zur Publikation der Zustände von Hintergrund-Tasks einer Applikation.
	<p>
	
	</p>
	@return der Datensatz HintergrundTaskZustaende.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdHintergrundTaskZustaende getOdHintergrundTaskZustaende();
	
	/**
	Enthält die Parameter (Anzahl der Archivdatensätze, Containergröße in Byte und den Zeitbereich), die angeben, wann ein Container des
						Archivsystems abzuschließen ist.
	<p>
	
	</p>
	@return der Datensatz ArchivContainer.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainer getPdArchivContainer();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
