/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert einen Datenverteiler mit seinen Eigenschaften.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface Datenverteiler extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.datenverteiler"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Mit dem Datenverteiler verbundene Applikationen.
<p>

</p>

@return die Menge Applikationen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation> getApplikationen();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Übertragung aller Applikationen, die an einem Datenverteiler angemeldet sind.
	<p>
	
	</p>
	@return der Datensatz AngemeldeteApplikationen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdAngemeldeteApplikationen getOdAngemeldeteApplikationen();
	
	/**
	Attributgruppe zur Übertragung von Anfragen um Verbindungen zu Applikationen oder Datenverteilern zu terminieren.
	<p>
	
	</p>
	@return der Datensatz Terminierung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdTerminierung getOdTerminierung();
	
	/**
	Zur Übermittlung der Ergebnisse von Konfigurationsanfragen an die anfragende Applikation.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAntwort getOdKonfigurationsAntwort();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Informationen über ein Distributionspaket.
	<p>
	
	</p>
	@return der Datensatz DistributionspaketReleaseInfo.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdDistributionspaketReleaseInfo getOdDistributionspaketReleaseInfo();
	
	/**
	Zur Übermittlung der Ergebnisse von Konfigurationsänderungsanfragen an die anfragende Applikation.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsSchreibAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsSchreibAntwort getOdKonfigurationsSchreibAntwort();
	
	/**
	Schnittstelle für Anfragen und Antworten an die Applikation des Datenverteilers.
	<p>
	
	</p>
	@return der Datensatz DatenverteilerSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdDatenverteilerSchnittstelle getOdDatenverteilerSchnittstelle();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Attributgruppe zur Übertragung der Ergebnisse einer Telegrammlaufzeitmessung.
	<p>
	Die Attributgruppe enthält die Ergebnisse einer vom Datenverteiler durchgeführten Telegrammlaufzeitermittlung zu den mit ihm
						verbundenen Applikationen.
	</p>
	@return der Datensatz TelegrammLaufzeiten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdTelegrammLaufzeiten getOdTelegrammLaufzeiten();
	
	/**
	Parameterdatensatz mit dem Datenverteiler-Verbindungen deaktiviert werden können.
	<p>
	
	</p>
	@return der Datensatz DeaktivierteVerbindungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdDeaktivierteVerbindungen getPdDeaktivierteVerbindungen();
	
	/**
	Datensatz, den der Datenverteiler als Quelle anmeldet, um über den Zustand der Kommunikation mit anderen Datenverteilern zu informieren.
	<p>
	
	</p>
	@return der Datensatz DatenverteilerKommunikationsZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdDatenverteilerKommunikationsZustand getOdDatenverteilerKommunikationsZustand();
	
	/**
	Datensatz, den der Datenverteiler als Quelle anmeldet um über den Zustand der Rechteprüfung zu informieren.
	<p>
	
	</p>
	@return der Datensatz DatenverteilerRechtepruefung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdDatenverteilerRechtepruefung getOdDatenverteilerRechtepruefung();
	
	/**
	Zur Übermittlung der Ergebnisse von Archivanfragen an die anfragende Applikation.
	<p>
	
	</p>
	@return der Datensatz ArchivAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAntwort getOdArchivAntwort();
	
	/**
	Eigenschaften eines Datenverteilers.
	<p>
	
	</p>
	@return der Datensatz DatenverteilerEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.konfigurationsdaten.KdDatenverteilerEigenschaften getKdDatenverteilerEigenschaften();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
