/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ von mit einem Datenverteiler verbundenen Konfigurations-Applikationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface KonfigurationsApplikation extends de.bsvrz.sys.funclib.bitctrl.modell.DynamischesObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.konfigurationsApplikation"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Schnittstelle für Antworten der Parametrierung.
	<p>
	&lt;absatz&gt;
							Über Datensätze dieser Attributgruppe werden von der Parametrierung Anfragen beantwortet, die über Datensätze der
							Attributgruppe atg.parametrierungsAnfrage gestellt wurden.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ParametrierungsAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungsAntwort getOdParametrierungsAntwort();
	
	/**
	Zur Übermittlung der Ergebnisse von Konfigurationsanfragen an die anfragende Applikation.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAntwort getOdKonfigurationsAntwort();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Archivanfragen dienen.
	<p>
	&lt;absatz&gt;
							Wird vom streambasierten Archivanfragemechanismus für die Übertragung von Anfragen und entsprechende Antworten zwischen der
							Archivanfragebibliothek (innerhalb von Applikationen) und dem Archivsystem benutzt. Außerdem wird diese Attributgruppe für
							Steuerungsnachrichten insbesondere zur Flußkontrolle bei der streambasierten Übertragung von Archivantworten benutzt.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ArchivAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrageSchnittstelle getOdArchivAnfrageSchnittstelle();
	
	/**
	Attributgruppe für grundlegende Eigenschaften einer Applikation.
	<p>
	
	</p>
	@return der Datensatz ApplikationsEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.konfigurationsdaten.KdApplikationsEigenschaften getKdApplikationsEigenschaften();
	
	/**
	Zur Übermittlung der Ergebnisse von Konfigurationsänderungsanfragen an die anfragende Applikation.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsSchreibAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsSchreibAntwort getOdKonfigurationsSchreibAntwort();
	
	/**
	Schnittstelle für Anfragen und Antworten an die Applikation des Datenverteilers.
	<p>
	
	</p>
	@return der Datensatz DatenverteilerSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdDatenverteilerSchnittstelle getOdDatenverteilerSchnittstelle();
	
	/**
	Attributgruppe zum Versand von Antworten der Ganglinienprognose.
	<p>
	
	</p>
	@return der Datensatz PrognoseGanglinienAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.onlinedaten.OdPrognoseGanglinienAntwort getOdPrognoseGanglinienAntwort();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Attributgruppe zur Uebertragung von Nachrichten die zur Abwicklung von PuA Anfragen dienen.
	<p>
	
	</p>
	@return der Datensatz PuaProtokollAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.onlinedaten.OdPuaProtokollAnfrageSchnittstelle getOdPuaProtokollAnfrageSchnittstelle();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert.
	</p>
	@return der Datensatz KonfigurationsAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelle getOdKonfigurationsAnfrageSchnittstelle();
	
	/**
	Attributgruppe zur Übertragung aller angemeldeten Daten einer Applikation.
	<p>
	
	</p>
	@return der Datensatz AngemeldeteDatenidentifikationen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdAngemeldeteDatenidentifikationen getOdAngemeldeteDatenidentifikationen();
	
	/**
	Zur Übermittlung von Ereignisantworten an die anfragende Applikation.
	<p>
	
	</p>
	@return der Datensatz EreignisKalenderAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten.OdEreignisKalenderAntwort getOdEreignisKalenderAntwort();
	
	/**
	Enthält Informationen, wenn dieses Objekt mit KExDaV übertragen wurde und von einer anderen Konfiguration stammt.
	<p>
	
	</p>
	@return der Datensatz KexdavAustauschObjekt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKexdavAustauschObjekt getKdKexdavAustauschObjekt();
	
	/**
	Attributgruppe für Fertigmeldungen von Applikationen.
	<p>
	
	</p>
	@return der Datensatz ApplikationsFertigmeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdApplikationsFertigmeldung getOdApplikationsFertigmeldung();
	
	/**
	Schnittstelle für Anfragen und Antworten an die Parametrierung.
	<p>
	
	</p>
	@return der Datensatz ParametrierungSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungSchnittstelle getOdParametrierungSchnittstelle();
	
	/**
	Zur Übermittlung der Ergebnisse von Archivanfragen an die anfragende Applikation.
	<p>
	
	</p>
	@return der Datensatz ArchivAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAntwort getOdArchivAntwort();
	
	/**
	Zur Übermittlung von Antworten auf Verwaltungsanfragen für Simulationen.
	<p>
	
	</p>
	@return der Datensatz SimulationVerwaltungAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationVerwaltungAntwort getOdSimulationVerwaltungAntwort();
	
	/**
	Attributgruppe zur Übertragung von Antwortnachrichten von Start&#47;Stopp auf Anfragen an Start&#47;Stopp.
	<p>
	Wird für die Übertragung von entsprechende Antworten auf Anfragen an Start&#47;Stopp benutzt.
								Die Anfragen werden unter typ.rechner&#47;atg.startStoppAnfrage gestellt.
	</p>
	@return der Datensatz StartStoppAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmrechner.onlinedaten.OdStartStoppAntwort getOdStartStoppAntwort();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
