/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine Parametrierung mit ihren Eigenschaften.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface Parametrierung extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.parametrierung"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Schnittstelle für Anfragen und Antworten an die Parametrierung.
	<p>
	
	</p>
	@return der Datensatz ParametrierungSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungSchnittstelle getOdParametrierungSchnittstelle();
	
	/**
	Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit der die
						Parametrierung parametriert wird.
	<p>
	&lt;absatz&gt;Potentiell kann die Parametrierapplikation alle im System vorhandenen Paramterdaten Daten verwalten. .Für welche Daten eine
							Parametrierapplikation aber tatsächlich zuständig ist, ist online parametrierbar. Zur Spezifikation, welche Daten archiviert werden
							sollen, müssen folgende Angaben gemacht werden:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Angabe der Konfigurationsobjekte, zu denen Parameterdatensätze verwaltet werden sollen&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Attributgruppen&#47;Aspektkombinationen und Simulationsvariante&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Parametrierungseinstellungen&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Der hierfür notwendige Parametersatz weist eine flexible Struktur auf, die es ermöglicht, neben ganz konkreten Spezifikationen, zu
							welchem Konfigurationsobjekt die Datensätze welcher Attributgruppen&#47;Aspektkombination Parametersätze verwaltet werden sollen,
							"flächendeckende" Angaben zu tätigen, um den Parametrierungsaufwand zu minimieren.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "ParameterSatz [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste dient zur Zusammenfassung einer (Teil)Spezifikation, zu welchen Konfigurationsobjekten welche Datensätze unter
							welchen Einstellungen durch die Parametrierung verwaltet werden sollen. Die Attributgruppe zur Parametrierung der Parametrirung besteht
							aus einem Feld mit beliebig vielen dieser Attributlisten.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Bereich [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Die in der folgenden Attributliste "Datenspezifikation" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
							Konfigurationsbereich.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "DatenSpezifikation [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
							folgenden Einstellungen gelten. Diese Attributliste kann innerhalb der Attributliste "ParameterSatz" beliebig oft enthalten
							sein.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Objekte [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut können beliebig viele Konfigurationsobjekte angegeben werden, für die Datensätze von der Parametrierung
							verwaltet werden sollen. Die Spezifikation der gewünschten Konfigurationsobjekte erfolgt über die direkte Angabe von einzelnen
							Konfigurationsobjekten (z.B. über die PID), über die Angabe einer Menge (z.B. Menge der MQ) oder durch die Angabe von Typen (z.B. Typ
							MQ). Bei der Angabe von Objekttypen werden alle Konfigurationsobjekte dieses Typs aus den Konfigurationsbereichen ausgewählt, die über
							das Attribut "Bereich" spezifiziert wurden.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "AttributGruppe [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Attributgruppen spezifiziert, die für die ausgewählten Konfigurationsobjekte durch die Parametrierung
							verwaltet werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "SimulationsVariante [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den angegebenen
							Aspekten für die ausgewählten Konfigurationsobjekte durch die Parametrierung verwaltet werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "Einstellungen [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation festgelegten Datensätze von der
							Parametrierung zu behandeln sind, zusammen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Parametrieren"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu von der Parameterierung zu verwalten sind ("Ja" oder "Nein").
							Wird an dieser Stelle "Nein" angegeben, sind die weiteren Attribute der Attributliste "Einstellungen" obsolet. Die Angabe von "nein"
							kann aber insbesondere dazu verwendet werden, einzelne Datenspezifikationen gezielt nicht zu verwalten, die ansonsten wegen einer
							"globaleren" Spezifikation mit verwaltet worden wären.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz Parametrierung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdParametrierung getPdParametrierung();
	
	/**
	Schnittstelle für Anfragen an die Parametrierung.
	<p>
	&lt;absatz&gt;
							Über Online-Datensätze dieser Attributgruppe können Anfragen an die Parametrierung gestellt werden, die von dieser über
							Datensätze der Attributgruppe atg.parametrierungsAntwort beantwortet werden.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ParametrierungsAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungsAnfrage getOdParametrierungsAnfrage();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
