/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Im Rahmen der Zugriffsrechteprüfung definiert eine Rolle erlaubte Aktivitäten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 28
 */
public interface ZugriffsRolleNeu extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.zugriffsRolleNeu"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Beschreibung von Aktivitäten.
	<p>
	&lt;absatz&gt;Über diesen Parameter wird spezifziert, welche Aktivitäten Benutzer dieser Rolle ausführen dürfen.&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;
								&lt;absatz&gt;
									Über die Attributliste AktivitätDaten  wird spezifziert, wie die Zugriffrechte beim Datenaustausch
									für die entsprechende Rolle gesetzt sind.
									Es können verschiedenen Aktivitäten definiert und der Rolle zugeordnet werden.
								&lt;&#47;absatz&gt;
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								&lt;absatz&gt;Über die Attributliste AktivitätObjekte wird spezifziert, welche Objekte neu angelegt, geändert oder gelöscht werden dürfen.&lt;&#47;absatz&gt;
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;
								&lt;absatz&gt;Über die Attributliste AktivitätMengen wird spezifziert, welche Menge geändert werden dürfen.&lt;&#47;absatz&gt;
							&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz RollenAktivitaet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdRollenAktivitaet getPdRollenAktivitaet();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
