/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Im Rahmen der Zugriffsrechteprüfung definiert eine Region Objekte, auf die sich Aktivitäten beziehen können.
<p>
Die zur Region gehörenden Objekte werden durch die Angabe von Mengen spezifiziert, die direkt oder indirekt auf die enthaltenen
					Objekte verweisen. Wenn alle Mengen leer sind, dann bedeutet dies, dass die definierte Region alle Objekte enthält.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 20
 */
public class ZugriffsRegionImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.ZugriffsRegion { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public ZugriffsRegionImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public ZugriffsRegionImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein RegionAlt.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection zusammmenstellungen;
	
	public Collection getZusammmenstellungen() {
		if (zusammmenstellungen == null) {
			final Collection menge = new ArrayList();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Zusammmenstellungen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Zusammmenstellungen").getElements()) {
				menge.add(getObjektFactory().getModellobjekt(so));
			}
			zusammmenstellungen = Collections.unmodifiableCollection(menge);
		}
		return zusammmenstellungen;
	}
	private Collection zusammenstellungen;
	
	public Collection getZusammenstellungen() {
		if (zusammenstellungen == null) {
			final Collection menge = new ArrayList();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Zusammenstellungen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Zusammenstellungen").getElements()) {
				menge.add(getObjektFactory().getModellobjekt(so));
			}
			zusammenstellungen = Collections.unmodifiableCollection(menge);
		}
		return zusammenstellungen;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt> objekte;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt> getObjekte() {
		if (objekte == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Objekte") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Objekte").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsObjekt) getObjektFactory().getModellobjekt(so));
			}
			objekte = Collections.unmodifiableCollection(menge);
		}
		return objekte;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
