/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Archivanfragen dienen.
<p>
&lt;absatz&gt;
						Wird vom streambasierten Archivanfragemechanismus für die Übertragung von Anfragen und entsprechende Antworten zwischen der
						Archivanfragebibliothek (innerhalb von Applikationen) und dem Archivsystem benutzt. Außerdem wird diese Attributgruppe für
						Steuerungsnachrichten insbesondere zur Flußkontrolle bei der streambasierten Übertragung von Archivantworten benutzt.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 32
 */
public class OdArchivAnfrageSchnittstelle extends AbstractOnlineDatensatz<OdArchivAnfrageSchnittstelle.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Object
				 _absender
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
				 _anfrageIndex
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttArchivNachrichtenTyp
				 _nachrichtenTyp
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _daten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
		
			/**
			Referenz auf den Absender des Datensatzes.
			<p>
			Die anfragende Applikation trägt in diesem Attribut das vom Datenverteiler dynamisch erzeugte Applikations-Objekt ein. Das Archiv
									addressiert entsprechende Antworten an dieses Applikationsobjekt. In den Antworten des Archivsystems ist in diesem Attribut eine
									Referenz auf das dem jeweiligen Archivsystem zugeordnete Objekt, an das die Archivanfragen adressiert werden enthalten.
			</p>
			
			@return der Wert von Absender.
			*/
				public 	Object
				 getAbsender() {
				return _absender;
			}
		
			/**
			Referenz auf den Absender des Datensatzes.
			<p>
			Die anfragende Applikation trägt in diesem Attribut das vom Datenverteiler dynamisch erzeugte Applikations-Objekt ein. Das Archiv
									addressiert entsprechende Antworten an dieses Applikationsobjekt. In den Antworten des Archivsystems ist in diesem Attribut eine
									Referenz auf das dem jeweiligen Archivsystem zugeordnete Objekt, an das die Archivanfragen adressiert werden enthalten.
			</p>
			
			@param _absender der neue Wert von Absender.
			*/
			public void setAbsender(	Object
			 _absender) {
				this._absender = _absender;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation zur Unterscheidung mehrerer paralleler Anfragen fortlaufend vergeben wird.
			<p>
			In allen zu einer Archivanfrage gehörenden Nachrichten wird diese Identifikation eingetragen, damit der jeweilige Empfänger die
									Nachricht zu der richtigen Anfrage zuordnen kann.
			</p>
			
			@return der Wert von AnfrageIndex.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
				 getAnfrageIndex() {
				return _anfrageIndex;
			}
		
			/**
			Kennzeichnung, die von der anfragenden Applikation zur Unterscheidung mehrerer paralleler Anfragen fortlaufend vergeben wird.
			<p>
			In allen zu einer Archivanfrage gehörenden Nachrichten wird diese Identifikation eingetragen, damit der jeweilige Empfänger die
									Nachricht zu der richtigen Anfrage zuordnen kann.
			</p>
			
			@param _anfrageIndex der neue Wert von AnfrageIndex.
			*/
			public void setAnfrageIndex(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
			 _anfrageIndex) {
				this._anfrageIndex = _anfrageIndex;
			}
		
			/**
			Typ der Nachricht.
			<p>
			
			</p>
			
			@return der Wert von NachrichtenTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttArchivNachrichtenTyp
				 getNachrichtenTyp() {
				return _nachrichtenTyp;
			}
		
			/**
			Typ der Nachricht.
			<p>
			
			</p>
			
			@param _nachrichtenTyp der neue Wert von NachrichtenTyp.
			*/
			public void setNachrichtenTyp(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttArchivNachrichtenTyp
			 _nachrichtenTyp) {
				this._nachrichtenTyp = _nachrichtenTyp;
			}
		
			/**
			Datenbytes der Nachricht.
			<p>
			&lt;absatz&gt;
										Je nach Wert der Attributs
										&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
										ist das Byte-Array folgendermassen zu interpretieren:
									&lt;&#47;absatz&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Archivanfrage an das Archivsystem&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 1
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die Anfrage wird in dem Byte-Array der
											&lt;verweis num="n" pid="atg.archivAnfrageSchnittstelle"&gt;&lt;&#47;verweis&gt;
											gespeichert und verschickt. Die Anfrage wird wie folgt in ein Byte-Array byte[] zerlegt:
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird Byteweise
											zerlegt:
										&lt;&#47;absatz&gt;
										&lt;anker pid="ref.serializerVersion"&gt;&lt;&#47;anker&gt;
										&lt;tabelle ausrichtung="l" rahmen="0" transponiert="n"&gt;
											&lt;rumpf&gt;
												&lt;zeile&gt;
													&lt;zelle anzZeilen="2" vertikal="o"&gt;byte[0]&lt;&#47;zelle&gt;
													&lt;zelle vertikal="o"&gt;höherwertigstes Byte der Serialisiererversion&lt;&#47;zelle&gt;
												&lt;&#47;zeile&gt;
												&lt;zeile&gt;
													&lt;zelle vertikal="o"&gt;(serializerVersion &amp; 0xff000000) &gt;&gt;&gt; 24)&lt;&#47;zelle&gt;
												&lt;&#47;zeile&gt;
												&lt;zeile&gt;
													&lt;zelle&gt;byte[1]&lt;&#47;zelle&gt;
													&lt;zelle&gt;(serializerVersion &amp; 0x00ff0000) &gt;&gt;&gt; 16)&lt;&#47;zelle&gt;
												&lt;&#47;zeile&gt;
												&lt;zeile&gt;
													&lt;zelle&gt;byte[2]&lt;&#47;zelle&gt;
													&lt;zelle&gt;(serializerVersion &amp; 0x0000ff00) &gt;&gt;&gt; 8)&lt;&#47;zelle&gt;
												&lt;&#47;zeile&gt;
												&lt;zeile&gt;
													&lt;zelle&gt;byte[3]&lt;&#47;zelle&gt;
													&lt;zelle&gt;(serializerVersion &amp; 0x000000ff)&lt;&#47;zelle&gt;
												&lt;&#47;zeile&gt;
											&lt;&#47;rumpf&gt;
										&lt;&#47;tabelle&gt;
										&lt;absatz&gt;
											Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer) vorgenommen, dieser benutzt die
											eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Priorität der Anfrage, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Größe Empfangspuffer, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Größe der Liste, die die einzelnen "ArchiveDataSpecification" speichert, int&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
										&lt;absatz&gt;
											Jeder Eintrag in der Liste, die die "ArchiveDataSpecification" speichert, wird ebenfalls in dem Byte-Array gespeichert. Die
											einzelnen Einträge werden wie folgt gespeichert:
										&lt;&#47;absatz&gt;
										&lt;anker pid="ref.byteArrayArS"&gt;&lt;&#47;anker&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;&#47;&#47; ArchiveTimeSpecification
												&lt;ze&gt;&lt;&#47;ze&gt;
												TimingType, byte (1 = DATA_TIME, 2 = ARCHIVE_TIME, 3 = DATA_INDEX)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;isStartRelative, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;intervalStart, long&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;intervalEnd, long&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;&#47;&#47; ArchiveDataKindCombination
												&lt;ze&gt;&lt;&#47;ze&gt;
												archiveDataKindCombination.isOnline, byte (1 = true, 0 = false)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;archiveDataKindCombination.isOnlineDelayed (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;archiveDataKindCombination.isRequested, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;archiveDataKindCombination.isRequestedDelayed, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;ArchiveOrder, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;ArchiveRequestOption, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;&#47;&#47; DataDescription
												&lt;ze&gt;&lt;&#47;ze&gt;
												AttributeGroup, ObjectReference
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Aspect, ObjectReference&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;SimulationVariant, short&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;SystemObject, ObjectReference&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Initiale Ergebnismeldung des Archivsystems zu einer Archivanfrage&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 2
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Diese wird wie folgt in einem Byte-Array übertragen, alle Einträge des Arrays werden mit einem Serialisierer erzeugt. (siehe
											Interface Serializer, dav.data.Serializer. Als Serialisiererversion wird die in
											&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
											= 1 übertragene Version benutzt)
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Anfrage erfolgreich, byte (1= true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Fehlermeldung, String&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;BlockingFactor des StreamDemultiplexers, int&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Archivdaten, die vom Archivsystem als Antwort auf eine Archivanfrage verschickt werden&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 3
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die Daten sind dabei ein Byte-Array, in diesem können durchaus mehrere Archivdaten verpackt worden sein. Ein Mechanismus zum
											erzeugen solcher Byte-Arrays wird von den Klassen StreamMultiplexer (verpackt Daten in einem Byte-Array) und StreamDemultiplexer
											(erzeugt aus dem Byte-Array Daten) zur Verfügung gestellt.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Ausgangsdaten des StreamMultiplexer, byte[]&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
										&lt;absatz&gt;
											Eingangsdaten für den StreamMultiplexer sind mehrere Byte-Arrays, die folgenden Aufbau haben: (alle Informationen wurden mit
											einem Serialisierer geschrieben. Als Serialisiererversion wird die in
											&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
											= 1 übertragene Version benutzt).
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;archiveDataKind, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;dataTime ,long&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;archiveTime, long&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;dataIndex, long&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;archiveDataType, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Serialisiererversion, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;ArchiveDataCompression, byte&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												Größe des folgenden Byte-Arrays, int (falls das Byte-Array die Größe 0 hat, wird das Byte-Array unter 9) nicht
												serialisiert)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Archivdatensatz als Byte-Array, byte[]&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Steuerungspakete, die zwecks Flußkontrolle an dass Archivsystem gesendet werden&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 4
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Sendeerlaubnis für das Archivsystem, die von der Applikation erteilt wird und zur Flusskontrolle der übertragenden Daten je
											Stream dient. Die Sendeerlaubnis wird in einem Byte-Array übertragen.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Der StreamMultiplexer verwendet dabei ein Byte-Array, das folgenden Aufbau besitzt (die Daten werden mit einem Serialisierer in
											ein Byte-Array umgewandelt. Als Serialisiererversion wird die in
											&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
											= 1 übertragene Version benutzt):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Index des Streams, der Senden darf, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Neuer Index, bis zu dem Daten verschickt werden dürfen, int&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Informationsanfragen an das Archivsystem&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 5
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Archivinformationsanfrage, auch diese wird in ein Byte-Array umgewandelt. Aufbau des Byte-Arrays:
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
											vorgenommen, dieser benutzt die eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Größe der Liste, in der die "ArchiveDataSpecification" abgespeichert sind&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
										&lt;absatz&gt;
											Danach gibt es für jeden Eintrag in der Liste, die die "ArchiveDataSpecification" speichert, weitere Einträge im Byte-Array.
											Diese haben die gleiche
											&lt;verweis pid="ref.byteArrayArS" txt="Form"&gt;&lt;&#47;verweis&gt;
											wie bei der Archivanfrage.
										&lt;&#47;absatz&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Antwort auf eine Informationsanfrage&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 6
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Antwort des Archivs auf eine Archivinformationsanfrage.
											&lt;ze&gt;&lt;&#47;ze&gt;
											Das Byte-Array wurde mit einem Serialisierer erzeugt und beinhaltet folgende Informationen (alle Informationen wurden mit einem
											Serialisierer geschrieben. Dieser benutzt die Version, die mit der Archivinformationsanfrage übertragen wurde):
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;1) Anfrage erfolgreich, byte (1 = true, 0 = false)&lt;&#47;absatz&gt;
										&lt;absatz&gt;Fehlerfall, die Archivinformationsanfrage konnte nicht bearbeitet werden:
											&lt;ze&gt;&lt;&#47;ze&gt;
											2) Wenn die Anfrage nicht beantwortet werden konnte, steht an dieser Stelle ein String mit dem aufgetretenen Fehler, String
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Normalfall, die Archivinformationsanfrage konnte bearbeitet werden:
											&lt;ze&gt;&lt;&#47;ze&gt;
											2) Größe der Liste, die die Antworten enthält
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;Jedes Element aus der Antwortliste wird wie folgt im Byte-Array übertragen:&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;intervalStart, long&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;intervalEnd, long&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;TimingType, byte (1 = DATA_TIME, 2 = ARCHIVE_TIME, 3 = DATA_INDEX)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;isDataGap, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;directAccess, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;volumeId, int&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												Index der verwendeten ArchiveDataSpecification, dieser kann aus der übertragenen Liste (
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 5) abgeleitet werden, int
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Auftrag, Archivdaten zu löschen&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 7
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Ein Löschauftrag, der an das Archivsystem verschickt werden soll. Der Löschauftrag wird als Byte-Array codiert und hat folgende
											Form:
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Der nächste Eintrag im Byte-Array wird durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer) vorgenommen,
											dieser benutzt die eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;zu löschende Simulationsvariante, short&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Ergebnis Löschauftrag&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 8
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Dies ist die Antwort auf einen Löschauftrag.
											&lt;ze&gt;&lt;&#47;ze&gt;
											Die Antwort wird als Byte-Array übertragen und hat folgenden Aufbau (alle Informationen wurden mit einem Serialisierer
											geschrieben. Dieser benutzt die Version, die mit dem Löschauftrag übertragen wurde):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Löschauftrag ausgeführt, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Wenn ein Fehler aufgetreten ist, wird als nächstes die Fehlermeldung codiert
												&lt;ze&gt;&lt;&#47;ze&gt;
												Fehlermeldung, String
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Sicherungsauftrag&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 9
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Diese Nachricht beauftragt das Archiv, seine Daten zu Sichern.
											&lt;ze&gt;&lt;&#47;ze&gt;
											Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau hat:
											&lt;ze&gt;&lt;&#47;ze&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Ergebnis Sicherungsauftrag&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 10
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Dies ist die Antwort des Archivsystems auf einen Auftrag, der die Sicherung des Archivsystems anstößt. Alle Informationen sind
											in einem Byte-Array codiert, das folgenden Aufbau besitzt (alle Informationen wurden mit einem Serialisierer geschrieben. Dieser
											benutzt die Version, die mit dem Speicherauftrag übertragen wurde):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Speicherauftrag ausgeführt, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Wenn ein Fehler aufgetreten ist, wird als nächstes die Fehlermeldung codiert
												&lt;ze&gt;&lt;&#47;ze&gt;
												Fehlermeldung, String
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Wiederherstellungsauftrag&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 11
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Dies ist ein Auftrag an das Archivsystem bestimmte Daten von der Sicherung in den direkten Zugriff des Archivsystems zu bringen
											(Wiederherstellungsauftrag). Dieser Auftrag wird als Byte-Array codiert und hat folgenden Aufbau:
											&lt;ze&gt;&lt;&#47;ze&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
											vorgenommen, dieser benutzt die eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Größe der Liste, die die genauen Bereiche enthält, die wiederhergestellt werden sollen&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
										&lt;absatz&gt;
											Jedes Element aus der Liste wird in der gleichen
											&lt;verweis pid="ref.byteArrayArS" txt="Form"&gt;&lt;&#47;verweis&gt;
											wie bei der Archivanfrage im Byte-Array gespeichert.
										&lt;&#47;absatz&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Ergebnis Wiederherstellungsauftrag&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 12
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Dies ist die Antwort des Archivsystems auf einen Auftrag, der Daten, die sich nicht mehr im direkten Zugriff befinden, von der
											Sicherung wiederhergestellt hat. Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt (alle
											Informationen wurden mit einem Serialisierer geschrieben. Dieser benutzt die Version, die mit dem Wiederherstellungsauftrag
											übertragen wurde):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;Wiederherstellen ausgeführt, byte (1 = true, 0 = false)&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;Wenn ein Fehler aufgetreten ist, wird als nächstes die Fehlermeldung codiert
												&lt;ze&gt;&lt;&#47;ze&gt;
												Fehlermeldung, String
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Löschzeitpunktänderung&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 13
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Dieser Auftrag benachrichtigt das Archivsystem, den Löschzeitpunkt der angegebenen Zeitbereiche um den angegebenen Wert in die
											Zukunft zu verschieben.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Dieses Telegramm kann aber auch dafür benutzt werden, wenn Archivdaten gelöscht werden sollen. Für diesen Zweck wird der
											Long-Wert, der im ersten Fall anzeigt, wie lange das Löschen verzögert werden soll, mit dem Wert 0 oder -1 übergeben. Alle
											Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt:
											&lt;ze&gt;&lt;&#47;ze&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
											vorgenommen, dieser benutzt die eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												relative Zeitangabe (in ms) um den die angegebenen Zeitbereiche länger im direkten Zugriff des Archivsystems bleiben sollen
												oder 0 für "löschen beim automatischen Löschen" oder -1 für "Daten sofort löschen", long
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												Größe der Liste, die die genauen Bereiche enthält, deren Vorhaltezeitraum verlängert werden soll oder die gelöscht werden
												sollen, int
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
										&lt;absatz&gt;
											Jedes Element aus der Liste wird in der gleichen
											&lt;verweis pid="ref.byteArrayArS" txt="Form"&gt;&lt;&#47;verweis&gt;
											wie bei der Archivanfrage im Byte-Array gespeichert.
										&lt;&#47;absatz&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Ergebnis Löschzeitpunktänderung&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 14
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;Dies ist die Antwort des Archivsystems auf eine Löschzeitpunktänderung.&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt (alle Informationen wurden mit einem
											Serialisierer geschrieben. Dieser benutzt die Version, die mit dem Auftrag att.archivNachrichtenTyp = 13 übertragen
											wurde):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												Vorhaltezeitraum&#47;räume verschoben, Daten der Löschung übergeben, byte (1 = true, 0 = false)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												Wenn ein Fehler aufgetreten ist, wird als nächstes die Fehlermeldung codiert
												&lt;ze&gt;&lt;&#47;ze&gt;
												Fehlermeldung, String
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Verwaltungsinformationsabgleich&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 15
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Dieser Auftrag benachrichtigt das Archivsystem, seine Verwaltungsinformationen mit einem Speichermedium vom Typ B abzugleichen.
											Dieser Auftrag wird als Byte-Array codiert und hat folgenden Aufbau:
											&lt;ze&gt;&lt;&#47;ze&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
											vorgenommen, dieser benutzt die eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												Eindeutige Identifizierung des Speichermediums Typ B mit dem sich das Archiv abgleichen soll, int
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Ergebnis Verwaltungsinformationsabgleich&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 16
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;Dies ist die Antwort des Archivsystems auf einen Auftrag zum Verwaltungsinformationsabgleich.&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt (alle Informationen wurden mit einem
											Serialisierer geschrieben. Dieser benutzt die Version, die mit dem Auftrag att.archivNachrichtenTyp = 15 übertragen
											wurde):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												Abgleich erfolgreich, byte (1 = true, 0 = false)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												Wenn ein Fehler aufgetreten ist, wird als nächstes die Fehlermeldung codiert
												&lt;ze&gt;&lt;&#47;ze&gt;
												Fehlermeldung, String
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Nachforderungsauftrag für festgelegte Datenidentifikationen&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 17
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;Diese Nachricht beauftragt das Archivsystem festgelegte Datenidentifikationen aus anderen Archivsystemen
											nachzufordern.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;Dies ist die Antwort des Archivsystems auf einen Auftrag zum Verwaltungsinformationsabgleich.&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt:
											&lt;ze&gt;&lt;&#47;ze&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
											vorgenommen, dieser benutzt die eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												&lt;absatz&gt;Größe der Liste, die die genauen Bereiche enthält, die nachgefordert werden sollen, int&lt;&#47;absatz&gt;
												&lt;absatz&gt;
													Jedes Element aus der Liste wird in der gleichen
													&lt;verweis pid="ref.byteArrayArS" txt="Form"&gt;&lt;&#47;verweis&gt;
													wie bei der Archivanfrage im Byte-Array gespeichert.
												&lt;&#47;absatz&gt;
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												&lt;absatz&gt;Größe der Liste, die alle Archivsysteme enthält, bei denen Daten nachgefordert werden sollen, int&lt;&#47;absatz&gt;
												&lt;absatz&gt;Jedes Element aus der Liste wird wie folgt im Byte-Array gespeichert:&lt;&#47;absatz&gt;
												&lt;numListe typ="1"&gt;
													&lt;listenPunkt&gt;
														&lt;absatz&gt;SystemObject, ObjectReference&lt;&#47;absatz&gt;
													&lt;&#47;listenPunkt&gt;
												&lt;&#47;numListe&gt;
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Ergebnis Nachforderungsauftrag (Typ 17)&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 18
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;Dies ist die Antwort des Archivsystems auf einen Nachforderungsauftrag für festgelegte Datenidentifikationen (Typ
											17).
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt (alle Informationen wurden mit einem
											Serialisierer geschrieben. Dieser benutzt die Version, die mit dem Auftrag att.archivNachrichtenTyp = 17 übertragen
											wurde):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												Auftrag zum Nachfordern wurde empfangen und wird bearbeitet, byte (1 = true, 0 = false)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												Wenn ein Fehler aufgetreten ist, wird als nächstes die Fehlermeldung codiert
												&lt;ze&gt;&lt;&#47;ze&gt;
												Fehlermeldung, String
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Nachforderungsauftrag für Datenidentifikationen der automatischen Nachforderung&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 19
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Diese Nachricht beauftragt das Archivsystem Datenidentifikationen, die bei der automatischen Nachforderung benutzt werden,
											gegebenenfalls aus den vorgegebenen Archivsystemen nachzufordern.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt:
											&lt;ze&gt;&lt;&#47;ze&gt;
											In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
											&lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
											zerlegt.
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
											vorgenommen, dieser benutzt die eben gespeicherte Version.
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												&lt;absatz&gt;Startzeitpunkt, long&lt;&#47;absatz&gt;
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												&lt;absatz&gt;Endzeitpunkt, long&lt;&#47;absatz&gt;
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												&lt;absatz&gt;Größe der Liste, die alle Archivsysteme enthält, bei denen Daten nachgefordert werden sollen, int&lt;&#47;absatz&gt;
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
										&lt;absatz&gt;Jedes Element aus der Liste wird wie folgt im Byte-Array gespeichert:&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												&lt;absatz&gt;SystemObject, ObjectReference&lt;&#47;absatz&gt;
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
									&lt;sektion&gt;
										&lt;titel&gt;Ergebnis Nachforderungsauftrag (Typ 19)&lt;&#47;titel&gt;
										&lt;absatz&gt;
											&lt;wichtig&gt;
												&lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
												= 20
											&lt;&#47;wichtig&gt;
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;Dies ist die Antwort des Archivsystems auf einen Nachforderungsauftrag für Datenidentifikationen der automatischen
											Nachforderung (Typ 19).
										&lt;&#47;absatz&gt;
										&lt;absatz&gt;
											Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt (alle Informationen wurden mit einem
											Serialisierer geschrieben. Dieser benutzt die Version, die mit dem Auftrag att.archivNachrichtenTyp = 19 übertragen
											wurde):
										&lt;&#47;absatz&gt;
										&lt;numListe typ="1"&gt;
											&lt;listenPunkt&gt;
												Auftrag zum Nachfordern wurde empfangen und wird bearbeitet, byte (1 = true, 0 = false)
											&lt;&#47;listenPunkt&gt;
											&lt;listenPunkt&gt;
												Wenn ein Fehler aufgetreten ist, wird als nächstes die Fehlermeldung codiert
												&lt;ze&gt;&lt;&#47;ze&gt;
												Fehlermeldung, String
											&lt;&#47;listenPunkt&gt;
										&lt;&#47;numListe&gt;
									&lt;&#47;sektion&gt;
			                        &lt;sektion&gt;
			                            &lt;titel&gt;Anfrage Anzahl Archivanfragen pro Applikation&lt;&#47;titel&gt;
			                            &lt;absatz&gt;
			                                &lt;wichtig&gt;
			                                    &lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
			                                    = 21
			                                &lt;&#47;wichtig&gt;
			                            &lt;&#47;absatz&gt;
			                            &lt;absatz&gt;
			                                Diese Nachricht beauftragt das Archivsystem Informationen über die Anzahl maximal verfügbarer gleichzeitiger Archivanfragen pro Applikation
			                                und die aktuelle Anzahl an vorhandenen Archivanfragen zurückzugeben.
			                            &lt;&#47;absatz&gt;
			                            &lt;absatz&gt;
			                                Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt:
			                                &lt;ze&gt;&lt;&#47;ze&gt;
			                                In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
			                                &lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
			                                zerlegt.
			                            &lt;&#47;absatz&gt;
			                            &lt;absatz&gt;
			                                Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
			                                vorgenommen, dieser benutzt die eben gespeicherte Version.
			                            &lt;&#47;absatz&gt;
			                            &lt;numListe typ="1"&gt;
			                                &lt;listenPunkt&gt;
			                                    &lt;absatz&gt;Nachrichtentyp, int, bisher immer 0, kann später erweitert werden&lt;&#47;absatz&gt;
			                                &lt;&#47;listenPunkt&gt;
			                            &lt;&#47;numListe&gt;
			                        &lt;&#47;sektion&gt;
			                        &lt;sektion&gt;
			                            &lt;titel&gt;Antwort Anzahl Archivanfragen pro Applikation&lt;&#47;titel&gt;
			                            &lt;absatz&gt;
			                                &lt;wichtig&gt;
			                                    &lt;verweis num="n" pid="att.archivNachrichtenTyp"&gt;&lt;&#47;verweis&gt;
			                                    = 22
			                                &lt;&#47;wichtig&gt;
			                            &lt;&#47;absatz&gt;
			                            &lt;absatz&gt;
			                                Alle Informationen sind in einem Byte-Array codiert, das folgenden Aufbau besitzt:
			                                &lt;ze&gt;&lt;&#47;ze&gt;
			                                In den ersten vier Bytes des Arrays ist die Serialisiererversion gespeichert. Dieser Integerwert wird wie bei der Archivanfrage
			                                &lt;verweis pid="ref.serializerVersion" txt="Byteweise"&gt;&lt;&#47;verweis&gt;
			                                zerlegt.
			                            &lt;&#47;absatz&gt;
			                            &lt;absatz&gt;
			                                Die nächsten Einträge im Byte-Array werden durch den Serialisierer (siehe Interface Serializer, dav.data.Serializer)
			                                vorgenommen, dieser benutzt die eben gespeicherte Version.
			                            &lt;&#47;absatz&gt;
			                            &lt;numListe typ="1"&gt;
			                                &lt;listenPunkt&gt;
			                                    &lt;absatz&gt;Maximale Anzahl an gleichzeitigen Archivanfragen pro Applikation, int&lt;&#47;absatz&gt;
			                                &lt;&#47;listenPunkt&gt;
			                                &lt;listenPunkt&gt;
			                                    &lt;absatz&gt;Aktuell verwendete Anzahl an Archivanfragen der anfragenden Applikation, int&lt;&#47;absatz&gt;
			                                &lt;&#47;listenPunkt&gt;
			                            &lt;&#47;numListe&gt;
			                        &lt;&#47;sektion&gt;
			</p>
			
			@return der Wert von Daten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getDaten() {
				return _daten;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAbsender = getAbsender();
						final SystemObject tmpAbsender;
							if (soAbsender instanceof SystemObject) {
								tmpAbsender = (SystemObject)soAbsender;
							} else if(soAbsender instanceof SystemObjekt){
								tmpAbsender = ((SystemObjekt)soAbsender).getSystemObject();
							} else{
								tmpAbsender = null;
							}
						datum.getReferenceValue("absender").setSystemObject(tmpAbsender);
					// GanzzahlAttributTyp
					if (getAnfrageIndex() != null) {
		                if (getAnfrageIndex().isZustand()) {
		                    datum.getUnscaledValue("anfrageIndex").setText(getAnfrageIndex().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("anfrageIndex").set(getAnfrageIndex().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNachrichtenTyp() != null) {
		                if (getNachrichtenTyp().isZustand()) {
		                    datum.getUnscaledValue("nachrichtenTyp").setText(getNachrichtenTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("nachrichtenTyp").set(getNachrichtenTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDaten() != null) {
						final Data.NumberArray arrayDaten = datum.
							getUnscaledArray
							("daten");
						arrayDaten.setLength(getDaten().size());
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
							arrayDaten.getValue(i).set(getDaten().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAbsender = daten.getReferenceValue("absender").getId();
						final SystemObjekt tmpAbsender;
						if (idAbsender == 0) {
							tmpAbsender = null;
						} else {
							final SystemObject soAbsender = factory.getDav().getDataModel().getObject(idAbsender);
							if (soAbsender == null) {
									tmpAbsender = new BaseUngueltigesSystemObjekt(idAbsender);
							} else {
								tmpAbsender = factory.getModellobjekt(soAbsender);
							}
						}
						setAbsender((	Object
						) tmpAbsender);
					// GanzzahlAttributTyp
							setAnfrageIndex(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnfrageIndex
							(daten.
								getUnscaledValue
							("anfrageIndex").
									intValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("nachrichtenTyp").isState()) {
								setNachrichtenTyp(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttArchivNachrichtenTyp
								.getZustand(daten.getScaledValue("nachrichtenTyp").getText()));
							} else {
							setNachrichtenTyp(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttArchivNachrichtenTyp
							(daten.
								getUnscaledValue
							("nachrichtenTyp").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayDaten = daten.
							getUnscaledArray
						("daten");
		
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
		                    getDaten().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayDaten.
		                    		byteValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsender(getAbsender());
							klon.setAnfrageIndex(getAnfrageIndex());
							klon.setNachrichtenTyp(getNachrichtenTyp());
						klon._daten = getDaten().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.archivAnfrageSchnittstelle";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdArchivAnfrageSchnittstelle(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
