/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zur Übermittlung der Ergebnisse von Konfigurationsänderungsanfragen an die anfragende Applikation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdKonfigurationsSchreibAntwort extends AbstractOnlineDatensatz<OdKonfigurationsSchreibAntwort.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Antwort,
				};
			}
	
			/**
			 * Wird zur Beantwortung von Anfragen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Antwort = new Aspekte("Antwort", "asp.antwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	Object
				 _absenderId
				;
				private String
				 _absenderZeichen
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				 _antwortTyp
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _antwort = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
		
			/**
			Objekt-ID der Konfiguration, die das Ergebnis bereitgestellt hat.
			<p>
			
			</p>
			
			@return der Wert von AbsenderId.
			*/
				public 	Object
				 getAbsenderId() {
				return _absenderId;
			}
		
			/**
			Objekt-ID der Konfiguration, die das Ergebnis bereitgestellt hat.
			<p>
			
			</p>
			
			@param _absenderId der neue Wert von AbsenderId.
			*/
			public void setAbsenderId(	Object
			 _absenderId) {
				this._absenderId = _absenderId;
			}
		
			/**
			Kennzeichnung, die in der entsprechenden Konfigurationsschreibanfrage von der Applikation vergeben wurde.
			<p>
			Der Wert dieses Attributs wird von der Konfiguration aus dem entsprechenden Attribut der Konfigurationsschreibanfrage kopiert.
									Die Bedeutung des Attributs wird von der anfragenden Applikation beliebig festgelegt und kann zum Beispiel dazu benutzt werden, um eine
									empfangene Antwort der ursprünglichen Anfrage zuzuordnen.
			</p>
			
			@return der Wert von AbsenderZeichen.
			*/
				public String
				 getAbsenderZeichen() {
				return _absenderZeichen;
			}
		
			/**
			Kennzeichnung, die in der entsprechenden Konfigurationsschreibanfrage von der Applikation vergeben wurde.
			<p>
			Der Wert dieses Attributs wird von der Konfiguration aus dem entsprechenden Attribut der Konfigurationsschreibanfrage kopiert.
									Die Bedeutung des Attributs wird von der anfragenden Applikation beliebig festgelegt und kann zum Beispiel dazu benutzt werden, um eine
									empfangene Antwort der ursprünglichen Anfrage zuzuordnen.
			</p>
			
			@param _absenderZeichen der neue Wert von AbsenderZeichen.
			*/
			public void setAbsenderZeichen(String
			 _absenderZeichen) {
				if (_absenderZeichen.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._absenderZeichen = _absenderZeichen;
			}
		
			/**
			Typ der Konfigurationsantwort.
			<p>
			
			</p>
			
			@return der Wert von AntwortTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				 getAntwortTyp() {
				return _antwortTyp;
			}
		
			/**
			Typ der Konfigurationsantwort.
			<p>
			
			</p>
			
			@param _antwortTyp der neue Wert von AntwortTyp.
			*/
			public void setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			 _antwortTyp) {
				this._antwortTyp = _antwortTyp;
			}
		
			/**
			Daten der Konfigurationsantwort.
			<p>
			
			</p>
			
			@return der Wert von Antwort.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getAntwort() {
				return _antwort;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAbsenderId = getAbsenderId();
						final SystemObject tmpAbsenderId;
							if (soAbsenderId instanceof SystemObject) {
								tmpAbsenderId = (SystemObject)soAbsenderId;
							} else if(soAbsenderId instanceof SystemObjekt){
								tmpAbsenderId = ((SystemObjekt)soAbsenderId).getSystemObject();
							} else{
								tmpAbsenderId = null;
							}
						datum.getReferenceValue("absenderId").setSystemObject(tmpAbsenderId);
					// ZeichenkettenAttributTyp
					if (getAbsenderZeichen() != null) {
						datum.getTextValue("absenderZeichen").setText(getAbsenderZeichen());
					}
					// GanzzahlAttributTyp
					if (getAntwortTyp() != null) {
		                if (getAntwortTyp().isZustand()) {
		                    datum.getUnscaledValue("antwortTyp").setText(getAntwortTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("antwortTyp").set(getAntwortTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAntwort() != null) {
						final Data.NumberArray arrayAntwort = datum.
							getUnscaledArray
							("antwort");
						arrayAntwort.setLength(getAntwort().size());
						for (int i = 0; i < arrayAntwort.getLength(); ++i) {
							arrayAntwort.getValue(i).set(getAntwort().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAbsenderId = daten.getReferenceValue("absenderId").getId();
						final SystemObjekt tmpAbsenderId;
						if (idAbsenderId == 0) {
							tmpAbsenderId = null;
						} else {
							final SystemObject soAbsenderId = factory.getDav().getDataModel().getObject(idAbsenderId);
							if (soAbsenderId == null) {
									tmpAbsenderId = new BaseUngueltigesSystemObjekt(idAbsenderId);
							} else {
								tmpAbsenderId = factory.getModellobjekt(soAbsenderId);
							}
						}
						setAbsenderId((	Object
						) tmpAbsenderId);
					// ZeichenkettenAttributTyp
						setAbsenderZeichen(daten.getTextValue("absenderZeichen").getText());
					// GanzzahlAttributTyp
							setAntwortTyp(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
							(daten.
								getUnscaledValue
							("antwortTyp").
									byteValue
							()));
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAntwort = daten.
							getUnscaledArray
						("antwort");
		
						for (int i = 0; i < arrayAntwort.getLength(); ++i) {
		                    getAntwort().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayAntwort.
		                    		byteValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbsenderId(getAbsenderId());
							klon.setAbsenderZeichen(getAbsenderZeichen());
							klon.setAntwortTyp(getAntwortTyp());
						klon._antwort = getAntwort().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.konfigurationsSchreibAntwort";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdKonfigurationsSchreibAntwort(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
