/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Übertragung von Anfragen um Verbindungen zu Applikationen oder Datenverteilern zu terminieren.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class OdTerminierung extends AbstractOnlineDatensatz<OdTerminierung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Anfrage,
				};
			}
	
			/**
			 * Wird zur Anfrage von Informationen benutzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Anfrage = new Aspekte("Anfrage", "asp.anfrage");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				> _applikationen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				> _datenverteiler = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				>(0, true);
		
			/**
			Liste mit Applikationen, die vom Datenverteiler beendet werden sollen.
			<p>
			
			</p>
			
			@return der Wert von Applikationen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
				> getApplikationen() {
				return _applikationen;
			}
		
		
			/**
			Liste mit Datenverteilerverbindungen, die vom Datenverteiler beendet werden sollen. Wird der eigene Datenverteiler angegeben,
								beendet sich der Datenverteiler selbst.
			<p>
			
			</p>
			
			@return der Wert von Datenverteiler.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
				> getDatenverteiler() {
				return _datenverteiler;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayApplikationen = datum.getReferenceArray("Applikationen");
						arrayApplikationen.setLength(getApplikationen().size());
						for (int i = 0; i < arrayApplikationen.getLength(); ++i) {
							final Object soApplikationen = getApplikationen().get(i);
							final SystemObject tmpApplikationen;
							if (soApplikationen instanceof SystemObject) {
								tmpApplikationen = (SystemObject)soApplikationen;
							} else if(soApplikationen instanceof SystemObjekt){
								tmpApplikationen = ((SystemObjekt)soApplikationen).getSystemObject();
							} else{
								tmpApplikationen = null;
							}
							arrayApplikationen.getReferenceValue(i).setSystemObject(tmpApplikationen);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayDatenverteiler = datum.getReferenceArray("Datenverteiler");
						arrayDatenverteiler.setLength(getDatenverteiler().size());
						for (int i = 0; i < arrayDatenverteiler.getLength(); ++i) {
							final Object soDatenverteiler = getDatenverteiler().get(i);
							final SystemObject tmpDatenverteiler;
							if (soDatenverteiler instanceof SystemObject) {
								tmpDatenverteiler = (SystemObject)soDatenverteiler;
							} else if(soDatenverteiler instanceof SystemObjekt){
								tmpDatenverteiler = ((SystemObjekt)soDatenverteiler).getSystemObject();
							} else{
								tmpDatenverteiler = null;
							}
							arrayDatenverteiler.getReferenceValue(i).setSystemObject(tmpDatenverteiler);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayApplikationen = daten.getReferenceArray("Applikationen");
						for (int i = 0; i < arrayApplikationen.getLength(); ++i) {
							final long idApplikationen = daten.getReferenceArray("Applikationen").getReferenceValue(i).getId();
							final SystemObjekt tmpApplikationen;
							if (idApplikationen == 0) {
								tmpApplikationen = null;
							} else {
								final SystemObject soApplikationen = factory.getDav().getDataModel().getObject(idApplikationen);
								if (soApplikationen == null) {
										tmpApplikationen = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.ApplikationUngueltig(idApplikationen);
								} else {
									tmpApplikationen = factory.getModellobjekt(soApplikationen);
								}
							}
								getApplikationen().add((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Applikation
								) tmpApplikationen);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayDatenverteiler = daten.getReferenceArray("Datenverteiler");
						for (int i = 0; i < arrayDatenverteiler.getLength(); ++i) {
							final long idDatenverteiler = daten.getReferenceArray("Datenverteiler").getReferenceValue(i).getId();
							final SystemObjekt tmpDatenverteiler;
							if (idDatenverteiler == 0) {
								tmpDatenverteiler = null;
							} else {
								final SystemObject soDatenverteiler = factory.getDav().getDataModel().getObject(idDatenverteiler);
								if (soDatenverteiler == null) {
										tmpDatenverteiler = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.DatenverteilerUngueltig(idDatenverteiler);
								} else {
									tmpDatenverteiler = factory.getModellobjekt(soDatenverteiler);
								}
							}
								getDatenverteiler().add((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Datenverteiler
								) tmpDatenverteiler);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._applikationen = getApplikationen().clone();
						klon._datenverteiler = getDatenverteiler().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.terminierung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTerminierung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
