/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit der die
					Archivierung parametriert wird.
<p>
&lt;absatz&gt;Potentiell können durch das Archivsystem alle im System durch die Applikationen bereitgestellten Daten archiviert werden. Welche
						Daten tatsächlich archiviert werden sollen, ist online parametrierbar. Zur Spezifikation, welche Daten archiviert werden sollen, müssen
						folgende Angaben gemacht werden:
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Angabe der Konfigurationsobjekte, zu denen Datensätze archiviert werden sollen&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Angabe der Attributgruppen&#47;Aspektkombinationen und Simulationsvariante&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Angabe der Archivierungseinstellungen&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Der hierfür notwendige Parametersatz weist eine flexible Struktur auf, die es ermöglicht, neben ganz konkreten Spezifikationen, zu
						welchem Konfigurationsobjekt die Datensätze welcher Attributgruppen&#47;Aspektkombination archiviert werden sollen, "flächendeckende"
						Angaben zu tätigen, um den Parametrierungsaufwand zu minimieren.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attributliste "ParameterSatz [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Diese Attributliste dient zur Zusammenfassung einer (Teil)Spezifikation, zu welchen Konfigurationsobjekten welche Datensätze unter
						welchen Einstellungen archiviert werden sollen. Die Attributgruppe zur Parametrierung des Archivsystems besteht aus einem Feld mit
						beliebig vielen dieser Attributlisten.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Bereich [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Die in der folgenden Attributliste "Datenspezifikation" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
						Konfigurationsbereich.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attributliste "DatenSpezifikation [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
						folgenden Einstellungen gelten. Diese Attributliste kann innerhalb der Attributliste "Archivsystem Parameter" beliebig oft enthalten
						sein.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Objekte [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut können beliebig viele Konfigurationsobjekte angegeben werden, für die Datensätze archiviert werden sollen. Die
						Spezifikation der gewünschten Konfigurationsobjekte erfolgt über die direkte Angabe von einzelnen Konfigurationsobjekten (z.B. über die
						PID), über die Angabe einer Menge (z.B. Menge der MQ) oder durch die Angabe von Typen (z.B. Typ MQ). Bei der Angabe von Objekttypen
						werden alle Konfigurationsobjekte dieses Typs aus den Konfigurationsbereichen ausgewählt, die über das Attribut "Bereich" spezifiziert
						wurden.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "AttributGruppe [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut werden die Attributgruppen spezifiziert, die für die ausgewählten Konfigurationsobjekte archiviert werden
						sollen.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Aspekt [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut werden die Aspekte spezifiziert, unter denen die angegebenen Attributgruppen für die ausgewählten
						Konfigurationsobjekte archiviert werden sollen.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "SimulationsVariante [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den angegebenen
						Aspekten für die ausgewählten Konfigurationsobjekte archiviert werden sollen.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attributliste "Einstellungen [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation zu archivierenden Datensätze zu behandeln
						sind, zusammen.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Archivieren"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu archivieren sind ("Ja" oder "Nein"). Wird an dieser Stelle "Nein"
						angegeben, sind die weiteren Attribute der Attributliste "Einstellungen" obsolet.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Nachfordern [..]"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob Daten bei potentiell erkannter Datenlücken von anderen Archivsystemen nachgefordert werden
						sollen. Das Attribut stellt ein Array dar, in dem die Archivsysteme aufgeführt sind, bei denen nachgefragt werden soll.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Sichern"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu sichern sind ("Ja" oder "Nein").&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Quittieren"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu quittieren sind. In diesem Fall wird an dieser Stelle der Aspekt
						spezifiziert, unter dem die entsprechenden Attributgruppen nach erfolgreicher Archivierung publiziert werden.
					&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Attribut "Vorhalten"&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
					&lt;absatz&gt;Mit diesem Attribut wird spezifiziert, wie lange sich die zu archivierenden Datensätze im direkten Zugriff des Archivsystems
						befinden sollen. Bei der Datenspezifikation mit der Attributliste werden die Objekte, Attributgruppen und Aspekte in voneinander
						unabhängigen Feldern spezifiziert. Für jede Kombination der Angabe in den drei Feldern gelten die in der Attributliste Einstellungen
						vorgegebenen Parameter. Dabei ist zu beachten, dass nur sinnvolle Kombinationen betrachtet werden; d.h. es werden natürlich nur die
						Attributgruppen&#47;Aspektkombinationen für ein Konfigurationsobjekt angemeldet, die laut Konfiguration bei einem Konfigurationsobjekt des
						entsprechenden Typs möglich sind. Weiter ist zu beachten, dass durch die Auslegung der Attributliste "Archivsystem Parameter" als Feld
						eine Überlagerung von gleichen Tupeln möglich ist. In diesem Fall setzt sich die Spezifikation im Datensatz mit dem höchsten Feldindex
						durch.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class PdArchiv extends AbstractParameterDatensatz<PdArchiv.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchiv
				> _parameterSatz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchiv
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit der die
								Archivierung parametriert wird.
			<p>
			
			</p>
			
			@return der Wert von ParameterSatz.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchiv
				> getParameterSatz() {
				return _parameterSatz;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayParameterSatz = datum.getArray("ParameterSatz");
						arrayParameterSatz.setLength(getParameterSatz().size());
						for (int i = 0; i < arrayParameterSatz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchiv
							 atl = getParameterSatz().get(i);
							atl.bean2Atl(arrayParameterSatz.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayParameterSatz = daten.getArray("ParameterSatz");
						for (int i = 0; i < arrayParameterSatz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchiv
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchiv
							 ();
							atl.atl2Bean(arrayParameterSatz.getItem(i), factory);
							getParameterSatz().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._parameterSatz = getParameterSatz().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.archiv";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdArchiv(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
