/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Parameter zum endgültigen Löschen.
<p>
&lt;absatz&gt;
						Ein Parameterdatensatz dieser Attributgruppe enthält globale Einstellungen und spezifische
						Einstellungen für verschiedene Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante)
						zum endgültigen Löschen.
					&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 38
 */
public class PdArchivDatenEndgueltigLoeschen extends AbstractParameterDatensatz<PdArchivDatenEndgueltigLoeschen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				@Defaultwert(wert = "Nein")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _aktiv
				;
				@Defaultwert(wert = "0 1 * * Mo")
				private String
				 _loeschintervall
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchivLoeschen
				> _parameterSatz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchivLoeschen
				>(0, true);
				@Defaultwert(wert = "1000 Tage")
				private 	RelativerZeitstempel
				 _vorhaltezeitEndgueltigGeloeschteObjekte
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Gibt an, ob das endgültige Löschen aktiv ist.
			<p>
			
			</p>
			
			@return der Wert von Aktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAktiv() {
				return _aktiv;
			}
		
			/**
			Gibt an, ob das endgültige Löschen aktiv ist.
			<p>
			
			</p>
			
			@param _aktiv der neue Wert von Aktiv.
			*/
			public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv) {
				this._aktiv = _aktiv;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten das endgültige Löschen
									von Archivdaten durchgeführt werden soll.
			<p>
			
			</p>
			
			@return der Wert von Loeschintervall.
			*/
				public String
				 getLoeschintervall() {
				return _loeschintervall;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten das endgültige Löschen
									von Archivdaten durchgeführt werden soll.
			<p>
			
			</p>
			
			@param _loeschintervall der neue Wert von Loeschintervall.
			*/
			public void setLoeschintervall(String
			 _loeschintervall) {
				if (_loeschintervall.length() > 128) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 128 + " Zeichen sein.");
				}
				this._loeschintervall = _loeschintervall;
			}
		
			/**
			Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit denen das
								endgültige Löschen parametriert wird.
			<p>
			
			</p>
			
			@return der Wert von ParameterSatz.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchivLoeschen
				> getParameterSatz() {
				return _parameterSatz;
			}
		
		
			/**
			Dieses Attribut gibt an, wie lange die Daten bzw. die Metainformationen von unbekannten Objekten
									noch mindestens erhalten bleiben, bevor sie endgültig gelöscht werden können und dann nicht mehr wiederherstellbar sind.&lt;ze&gt;&lt;&#47;ze&gt;
									Dieses Attribut bezieht sich auf alle gesicherten Daten, zu denen kein Objekt in der Konfiguration ermittelbar ist.
									(Z. B. archivierte Daten von transienten dynamischen Objekten oder endgültig gelöschten Objekten).
			<p>
			&lt;absatz&gt;
										Das endgültige Löschen ignoriert den Löschschutz und die Sicherung, d. h. sofern das endgültige
										Löschen aktiviert ist, werden alle Daten gelöscht, die älter sind als die hier parametrierte Vorhaltezeit,
										egal ob die Daten schon gesichert wurden oder nicht.
										Es spielt für das endgültige Löschen keine Rolle, welche Vorhaltezeit beim Anlegen des Containers parametriert war.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von VorhaltezeitEndgueltigGeloeschteObjekte.
			*/
				public 	RelativerZeitstempel
				 getVorhaltezeitEndgueltigGeloeschteObjekte() {
				return _vorhaltezeitEndgueltigGeloeschteObjekte;
			}
		
			/**
			Dieses Attribut gibt an, wie lange die Daten bzw. die Metainformationen von unbekannten Objekten
									noch mindestens erhalten bleiben, bevor sie endgültig gelöscht werden können und dann nicht mehr wiederherstellbar sind.&lt;ze&gt;&lt;&#47;ze&gt;
									Dieses Attribut bezieht sich auf alle gesicherten Daten, zu denen kein Objekt in der Konfiguration ermittelbar ist.
									(Z. B. archivierte Daten von transienten dynamischen Objekten oder endgültig gelöschten Objekten).
			<p>
			&lt;absatz&gt;
										Das endgültige Löschen ignoriert den Löschschutz und die Sicherung, d. h. sofern das endgültige
										Löschen aktiviert ist, werden alle Daten gelöscht, die älter sind als die hier parametrierte Vorhaltezeit,
										egal ob die Daten schon gesichert wurden oder nicht.
										Es spielt für das endgültige Löschen keine Rolle, welche Vorhaltezeit beim Anlegen des Containers parametriert war.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _vorhaltezeitEndgueltigGeloeschteObjekte der neue Wert von VorhaltezeitEndgueltigGeloeschteObjekte.
			*/
			public void setVorhaltezeitEndgueltigGeloeschteObjekte(	RelativerZeitstempel
			 _vorhaltezeitEndgueltigGeloeschteObjekte) {
				this._vorhaltezeitEndgueltigGeloeschteObjekte = _vorhaltezeitEndgueltigGeloeschteObjekte;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getAktiv() != null) {
		                if (getAktiv().isZustand()) {
		                    datum.getUnscaledValue("Aktiv").setText(getAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Aktiv").set(getAktiv().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getLoeschintervall() != null) {
						datum.getTextValue("Löschintervall").setText(getLoeschintervall());
					}
					// AttributListenDefinition
						final Data.Array arrayParameterSatz = datum.getArray("ParameterSatz");
						arrayParameterSatz.setLength(getParameterSatz().size());
						for (int i = 0; i < arrayParameterSatz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchivLoeschen
							 atl = getParameterSatz().get(i);
							atl.bean2Atl(arrayParameterSatz.getItem(i), factory);
		
						}
					// ZeitstempelAttributTyp
						datum.getTimeValue("VorhaltezeitEndgültigGelöschteObjekte").setMillis(getVorhaltezeitEndgueltigGeloeschteObjekte().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Aktiv").isState()) {
								setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Aktiv").getText()));
							} else {
							setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Aktiv").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setLoeschintervall(daten.getTextValue("Löschintervall").getText());
					// AttributListenDefinition
						final Data.Array arrayParameterSatz = daten.getArray("ParameterSatz");
						for (int i = 0; i < arrayParameterSatz.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchivLoeschen
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AtlParameterSatzArchivLoeschen
							 ();
							atl.atl2Bean(arrayParameterSatz.getItem(i), factory);
							getParameterSatz().add(atl);
						}
					// ZeitstempelAttributTyp
						setVorhaltezeitEndgueltigGeloeschteObjekte(new
							RelativerZeitstempel
							(daten.getTimeValue("VorhaltezeitEndgültigGelöschteObjekte").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setAktiv(getAktiv());
							klon.setLoeschintervall(getLoeschintervall());
						klon._parameterSatz = getParameterSatz().clone();
							klon.setVorhaltezeitEndgueltigGeloeschteObjekte(getVorhaltezeitEndgueltigGeloeschteObjekte());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.archivDatenEndgültigLöschen";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdArchivDatenEndgueltigLoeschen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
