/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Allgemeine Einstellungen zum Archivsystem.
<p>
&lt;absatz&gt;Dieser Parameter fasst folgende Einstellung des Archivsystems zusammen:&lt;&#47;absatz&gt;
					&lt;liste zeichen="punkt"&gt;
						&lt;listenPunkt&gt;Maximaler Archivzeitsprung vorwärts T
							&lt;tief&gt;max&lt;&#47;tief&gt;
						&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Sicherungsintervall&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Löschintervall&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Nachforderungsintervall&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Spontanes Löschen&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Löschschutz&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Anzahl Bytes, die pro Anfrage zur Pufferung genutzt werden können&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Maximale Anzahl der noch nicht quittierten übertragenen Blöcke pro Stream&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen hoher Priorität&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen mittlerer Priorität&lt;&#47;listenPunkt&gt;
						&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen niedriger Priorität&lt;&#47;listenPunkt&gt;
					&lt;&#47;liste&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class PdArchivEinstellung extends AbstractParameterDatensatz<PdArchivEinstellung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				@Defaultwert(wert = "1 Stunde")
				private 	RelativerZeitstempel
				 _tMax
				;
				@Defaultwert(wert = "0 1 * * Di-Sa")
				private String
				 _sicherungsintervall
				= new String
				()
				;
				@Defaultwert(wert = "0 3 * * Di-Sa")
				private String
				 _loeschintervall
				= new String
				()
				;
				@Defaultwert(wert = "* 5 * * *")
				private String
				 _nachforderungsintervall
				= new String
				()
				;
				@Defaultwert(wert = "5 Minuten")
				private 	RelativerZeitstempel
				 _kapazitaetscheck
				;
				@Defaultwert(wert = "2000000000")
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSpeicherKapazitaet
				 _restkapazitaet
				;
				@Defaultwert(wert = "3 Tage")
				private 	RelativerZeitstempel
				 _loeschschutzverlaengerung
				;
				@Defaultwert(wert = "42 Tage")
				private 	RelativerZeitstempel
				 _loeschschutzverlaengerungMax
				;
				@Defaultwert(wert = "100000")
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBytes
				 _anzahlBytes
				;
				@Defaultwert(wert = "10")
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBlocks
				 _anzahlBlocks
				;
				@Defaultwert(wert = "3")
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
				 _anzahlHohePrioritaet
				;
				@Defaultwert(wert = "6")
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
				 _anzahlMittlerePrioritaet
				;
				@Defaultwert(wert = "9")
				private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
				 _anzahlNiedrigePrioritaet
				;
				private 	RelativerZeitstempel
				 _zeitSpanneNeuerSteuerbefehlNachKeineQuelle
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Maximaler Archivzeitsprung vorwärts T
									&lt;tief&gt;max&lt;&#47;tief&gt;.
			<p>
			
			</p>
			
			@return der Wert von TMax.
			*/
				public 	RelativerZeitstempel
				 getTMax() {
				return _tMax;
			}
		
			/**
			Maximaler Archivzeitsprung vorwärts T
									&lt;tief&gt;max&lt;&#47;tief&gt;.
			<p>
			
			</p>
			
			@param _tMax der neue Wert von TMax.
			*/
			public void setTMax(	RelativerZeitstempel
			 _tMax) {
				this._tMax = _tMax;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten die automatische Sicherung der Archivdaten erfolgen soll.
			<p>
			
			</p>
			
			@return der Wert von Sicherungsintervall.
			*/
				public String
				 getSicherungsintervall() {
				return _sicherungsintervall;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten die automatische Sicherung der Archivdaten erfolgen soll.
			<p>
			
			</p>
			
			@param _sicherungsintervall der neue Wert von Sicherungsintervall.
			*/
			public void setSicherungsintervall(String
			 _sicherungsintervall) {
				if (_sicherungsintervall.length() > 128) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 128 + " Zeichen sein.");
				}
				this._sicherungsintervall = _sicherungsintervall;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten die automatische Löschung der Archivdaten erfolgen soll, deren
									Löschschutz abgelaufen ist.
			<p>
			
			</p>
			
			@return der Wert von Loeschintervall.
			*/
				public String
				 getLoeschintervall() {
				return _loeschintervall;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten die automatische Löschung der Archivdaten erfolgen soll, deren
									Löschschutz abgelaufen ist.
			<p>
			
			</p>
			
			@param _loeschintervall der neue Wert von Loeschintervall.
			*/
			public void setLoeschintervall(String
			 _loeschintervall) {
				if (_loeschintervall.length() > 128) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 128 + " Zeichen sein.");
				}
				this._loeschintervall = _loeschintervall;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten das automatische Nachfordern von Archivdaten aus erkannten Datenlücken
									erfolgen soll.
			<p>
			
			</p>
			
			@return der Wert von Nachforderungsintervall.
			*/
				public String
				 getNachforderungsintervall() {
				return _nachforderungsintervall;
			}
		
			/**
			Über diesen Parameter wird eingestellt, zu welchen Zeitpunkten das automatische Nachfordern von Archivdaten aus erkannten Datenlücken
									erfolgen soll.
			<p>
			
			</p>
			
			@param _nachforderungsintervall der neue Wert von Nachforderungsintervall.
			*/
			public void setNachforderungsintervall(String
			 _nachforderungsintervall) {
				if (_nachforderungsintervall.length() > 128) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 128 + " Zeichen sein.");
				}
				this._nachforderungsintervall = _nachforderungsintervall;
			}
		
			/**
			Über diesen Parameter wird eingestellt, in welchem Zyklus die Restkapazität vom Speichermedium A geprüft werden soll.
			<p>
			
			</p>
			
			@return der Wert von Kapazitaetscheck.
			*/
				public 	RelativerZeitstempel
				 getKapazitaetscheck() {
				return _kapazitaetscheck;
			}
		
			/**
			Über diesen Parameter wird eingestellt, in welchem Zyklus die Restkapazität vom Speichermedium A geprüft werden soll.
			<p>
			
			</p>
			
			@param _kapazitaetscheck der neue Wert von Kapazitaetscheck.
			*/
			public void setKapazitaetscheck(	RelativerZeitstempel
			 _kapazitaetscheck) {
				this._kapazitaetscheck = _kapazitaetscheck;
			}
		
			/**
			Mindest vorhandene Speicherkapazität auf Medium A. Bei Unterschreiten wird das spontane Löschen eingeleitet.
			<p>
			
			</p>
			
			@return der Wert von Restkapazitaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSpeicherKapazitaet
				 getRestkapazitaet() {
				return _restkapazitaet;
			}
		
			/**
			Mindest vorhandene Speicherkapazität auf Medium A. Bei Unterschreiten wird das spontane Löschen eingeleitet.
			<p>
			
			</p>
			
			@param _restkapazitaet der neue Wert von Restkapazitaet.
			*/
			public void setRestkapazitaet(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSpeicherKapazitaet
			 _restkapazitaet) {
				this._restkapazitaet = _restkapazitaet;
			}
		
			/**
			Falls der Zeitpunkt A, der sich aus der Addition der aktuellen Zeit und diesem Parameter ergibt, höher als der zu dem Container
									verwaltete Löschschutz ist, auf den grade zugegriffen wurde, wird der Löschschutz auf den Zeitpunkt A gesetzt.
			<p>
			
			</p>
			
			@return der Wert von Loeschschutzverlaengerung.
			*/
				public 	RelativerZeitstempel
				 getLoeschschutzverlaengerung() {
				return _loeschschutzverlaengerung;
			}
		
			/**
			Falls der Zeitpunkt A, der sich aus der Addition der aktuellen Zeit und diesem Parameter ergibt, höher als der zu dem Container
									verwaltete Löschschutz ist, auf den grade zugegriffen wurde, wird der Löschschutz auf den Zeitpunkt A gesetzt.
			<p>
			
			</p>
			
			@param _loeschschutzverlaengerung der neue Wert von Loeschschutzverlaengerung.
			*/
			public void setLoeschschutzverlaengerung(	RelativerZeitstempel
			 _loeschschutzverlaengerung) {
				this._loeschschutzverlaengerung = _loeschschutzverlaengerung;
			}
		
			/**
			Maximal vorgebbare Zeitdauer für die Löschschutzverlängerung.
			<p>
			
			</p>
			
			@return der Wert von LoeschschutzverlaengerungMax.
			*/
				public 	RelativerZeitstempel
				 getLoeschschutzverlaengerungMax() {
				return _loeschschutzverlaengerungMax;
			}
		
			/**
			Maximal vorgebbare Zeitdauer für die Löschschutzverlängerung.
			<p>
			
			</p>
			
			@param _loeschschutzverlaengerungMax der neue Wert von LoeschschutzverlaengerungMax.
			*/
			public void setLoeschschutzverlaengerungMax(	RelativerZeitstempel
			 _loeschschutzverlaengerungMax) {
				this._loeschschutzverlaengerungMax = _loeschschutzverlaengerungMax;
			}
		
			/**
			Über diesen Parameter wird die sendeseitigen Queue eingestellt. Hiermit wird die Anzahl Bytes je Anfrage vorgegeben, aus der sich durch
									Division durch die Anzahl Streams einer Anfrage direkt die Mindestanzahl Bytes je Stream ergibt. Wenn diese Mindestanzahl Bytes je
									Stream erreicht wird, werden die gepufferten Archivdatensätze in einem Block übertragen.
			<p>
			
			</p>
			
			@return der Wert von AnzahlBytes.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBytes
				 getAnzahlBytes() {
				return _anzahlBytes;
			}
		
			/**
			Über diesen Parameter wird die sendeseitigen Queue eingestellt. Hiermit wird die Anzahl Bytes je Anfrage vorgegeben, aus der sich durch
									Division durch die Anzahl Streams einer Anfrage direkt die Mindestanzahl Bytes je Stream ergibt. Wenn diese Mindestanzahl Bytes je
									Stream erreicht wird, werden die gepufferten Archivdatensätze in einem Block übertragen.
			<p>
			
			</p>
			
			@param _anzahlBytes der neue Wert von AnzahlBytes.
			*/
			public void setAnzahlBytes(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBytes
			 _anzahlBytes) {
				this._anzahlBytes = _anzahlBytes;
			}
		
			/**
			Über diesen Parameter wird die maximale Anzahl der noch nicht quittierten übertragenen Blöcke pro Stream festgelegt. Der empfangsseitige
									Speicherbedarf je Anfrage ergibt sich dabei aus dem Produkt der Parameter AnzahlBytes mit AnzahlBlocks.
			<p>
			
			</p>
			
			@return der Wert von AnzahlBlocks.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBlocks
				 getAnzahlBlocks() {
				return _anzahlBlocks;
			}
		
			/**
			Über diesen Parameter wird die maximale Anzahl der noch nicht quittierten übertragenen Blöcke pro Stream festgelegt. Der empfangsseitige
									Speicherbedarf je Anfrage ergibt sich dabei aus dem Produkt der Parameter AnzahlBytes mit AnzahlBlocks.
			<p>
			
			</p>
			
			@param _anzahlBlocks der neue Wert von AnzahlBlocks.
			*/
			public void setAnzahlBlocks(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBlocks
			 _anzahlBlocks) {
				this._anzahlBlocks = _anzahlBlocks;
			}
		
			/**
			Anzahl parallel zu beantwortener Archivanfragen hoher Priorität.
			<p>
			
			</p>
			
			@return der Wert von AnzahlHohePrioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
				 getAnzahlHohePrioritaet() {
				return _anzahlHohePrioritaet;
			}
		
			/**
			Anzahl parallel zu beantwortener Archivanfragen hoher Priorität.
			<p>
			
			</p>
			
			@param _anzahlHohePrioritaet der neue Wert von AnzahlHohePrioritaet.
			*/
			public void setAnzahlHohePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
			 _anzahlHohePrioritaet) {
				this._anzahlHohePrioritaet = _anzahlHohePrioritaet;
			}
		
			/**
			Anzahl parallel zu beantwortener Archivanfragen mittlerer Priorität.
			<p>
			
			</p>
			
			@return der Wert von AnzahlMittlerePrioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
				 getAnzahlMittlerePrioritaet() {
				return _anzahlMittlerePrioritaet;
			}
		
			/**
			Anzahl parallel zu beantwortener Archivanfragen mittlerer Priorität.
			<p>
			
			</p>
			
			@param _anzahlMittlerePrioritaet der neue Wert von AnzahlMittlerePrioritaet.
			*/
			public void setAnzahlMittlerePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
			 _anzahlMittlerePrioritaet) {
				this._anzahlMittlerePrioritaet = _anzahlMittlerePrioritaet;
			}
		
			/**
			Anzahl parallel zu beantwortener Archivanfragen niedriger Priorität.
			<p>
			
			</p>
			
			@return der Wert von AnzahlNiedrigePrioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
				 getAnzahlNiedrigePrioritaet() {
				return _anzahlNiedrigePrioritaet;
			}
		
			/**
			Anzahl parallel zu beantwortener Archivanfragen niedriger Priorität.
			<p>
			
			</p>
			
			@param _anzahlNiedrigePrioritaet der neue Wert von AnzahlNiedrigePrioritaet.
			*/
			public void setAnzahlNiedrigePrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
			 _anzahlNiedrigePrioritaet) {
				this._anzahlNiedrigePrioritaet = _anzahlNiedrigePrioritaet;
			}
		
			/**
			Falls die Verbindung zur Simulation unterbrochen wurde, muss innerhalb dieser Zeitspanne ein neuer Steuerbefehl eingegangen sein
									(ansonsten werden die simulierten Daten nicht weiter archiviert).
			<p>
			
			</p>
			
			@return der Wert von ZeitSpanneNeuerSteuerbefehlNachKeineQuelle.
			*/
				public 	RelativerZeitstempel
				 getZeitSpanneNeuerSteuerbefehlNachKeineQuelle() {
				return _zeitSpanneNeuerSteuerbefehlNachKeineQuelle;
			}
		
			/**
			Falls die Verbindung zur Simulation unterbrochen wurde, muss innerhalb dieser Zeitspanne ein neuer Steuerbefehl eingegangen sein
									(ansonsten werden die simulierten Daten nicht weiter archiviert).
			<p>
			
			</p>
			
			@param _zeitSpanneNeuerSteuerbefehlNachKeineQuelle der neue Wert von ZeitSpanneNeuerSteuerbefehlNachKeineQuelle.
			*/
			public void setZeitSpanneNeuerSteuerbefehlNachKeineQuelle(	RelativerZeitstempel
			 _zeitSpanneNeuerSteuerbefehlNachKeineQuelle) {
				this._zeitSpanneNeuerSteuerbefehlNachKeineQuelle = _zeitSpanneNeuerSteuerbefehlNachKeineQuelle;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						datum.getTimeValue("TMax").setMillis(getTMax().getTime());
					// ZeichenkettenAttributTyp
					if (getSicherungsintervall() != null) {
						datum.getTextValue("Sicherungsintervall").setText(getSicherungsintervall());
					}
					// ZeichenkettenAttributTyp
					if (getLoeschintervall() != null) {
						datum.getTextValue("Löschintervall").setText(getLoeschintervall());
					}
					// ZeichenkettenAttributTyp
					if (getNachforderungsintervall() != null) {
						datum.getTextValue("Nachforderungsintervall").setText(getNachforderungsintervall());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Kapazitätscheck").setMillis(getKapazitaetscheck().getTime());
					// GanzzahlAttributTyp
					if (getRestkapazitaet() != null) {
		                if (getRestkapazitaet().isZustand()) {
		                    datum.getUnscaledValue("Restkapazität").setText(getRestkapazitaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Restkapazität").set(getRestkapazitaet().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Löschschutzverlängerung").setMillis(getLoeschschutzverlaengerung().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("LöschschutzverlängerungMax").setMillis(getLoeschschutzverlaengerungMax().getTime());
					// GanzzahlAttributTyp
					if (getAnzahlBytes() != null) {
		                if (getAnzahlBytes().isZustand()) {
		                    datum.getUnscaledValue("AnzahlBytes").setText(getAnzahlBytes().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlBytes").set(getAnzahlBytes().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlBlocks() != null) {
		                if (getAnzahlBlocks().isZustand()) {
		                    datum.getUnscaledValue("AnzahlBlocks").setText(getAnzahlBlocks().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlBlocks").set(getAnzahlBlocks().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlHohePrioritaet() != null) {
		                if (getAnzahlHohePrioritaet().isZustand()) {
		                    datum.getUnscaledValue("AnzahlHohePriorität").setText(getAnzahlHohePrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlHohePriorität").set(getAnzahlHohePrioritaet().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlMittlerePrioritaet() != null) {
		                if (getAnzahlMittlerePrioritaet().isZustand()) {
		                    datum.getUnscaledValue("AnzahlMittlerePriorität").setText(getAnzahlMittlerePrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlMittlerePriorität").set(getAnzahlMittlerePrioritaet().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlNiedrigePrioritaet() != null) {
		                if (getAnzahlNiedrigePrioritaet().isZustand()) {
		                    datum.getUnscaledValue("AnzahlNiedrigePriorität").setText(getAnzahlNiedrigePrioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlNiedrigePriorität").set(getAnzahlNiedrigePrioritaet().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("ZeitSpanneNeuerSteuerbefehlNachKeineQuelle").setMillis(getZeitSpanneNeuerSteuerbefehlNachKeineQuelle().getTime());
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeitstempelAttributTyp
						setTMax(new
							RelativerZeitstempel
							(daten.getTimeValue("TMax").getMillis()));
					// ZeichenkettenAttributTyp
						setSicherungsintervall(daten.getTextValue("Sicherungsintervall").getText());
					// ZeichenkettenAttributTyp
						setLoeschintervall(daten.getTextValue("Löschintervall").getText());
					// ZeichenkettenAttributTyp
						setNachforderungsintervall(daten.getTextValue("Nachforderungsintervall").getText());
					// ZeitstempelAttributTyp
						setKapazitaetscheck(new
							RelativerZeitstempel
							(daten.getTimeValue("Kapazitätscheck").getMillis()));
					// GanzzahlAttributTyp
							setRestkapazitaet(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSpeicherKapazitaet
							(daten.
								getUnscaledValue
							("Restkapazität").
									longValue
							()));
					// ZeitstempelAttributTyp
						setLoeschschutzverlaengerung(new
							RelativerZeitstempel
							(daten.getTimeValue("Löschschutzverlängerung").getMillis()));
					// ZeitstempelAttributTyp
						setLoeschschutzverlaengerungMax(new
							RelativerZeitstempel
							(daten.getTimeValue("LöschschutzverlängerungMax").getMillis()));
					// GanzzahlAttributTyp
							setAnzahlBytes(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBytes
							(daten.
								getUnscaledValue
							("AnzahlBytes").
									intValue
							()));
					// GanzzahlAttributTyp
							setAnzahlBlocks(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlBlocks
							(daten.
								getUnscaledValue
							("AnzahlBlocks").
									byteValue
							()));
					// GanzzahlAttributTyp
							setAnzahlHohePrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
							(daten.
								getUnscaledValue
							("AnzahlHohePriorität").
									byteValue
							()));
					// GanzzahlAttributTyp
							setAnzahlMittlerePrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
							(daten.
								getUnscaledValue
							("AnzahlMittlerePriorität").
									byteValue
							()));
					// GanzzahlAttributTyp
							setAnzahlNiedrigePrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttAnzahlPrioritaet
							(daten.
								getUnscaledValue
							("AnzahlNiedrigePriorität").
									byteValue
							()));
					// ZeitstempelAttributTyp
						setZeitSpanneNeuerSteuerbefehlNachKeineQuelle(new
							RelativerZeitstempel
							(daten.getTimeValue("ZeitSpanneNeuerSteuerbefehlNachKeineQuelle").getMillis()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setTMax(getTMax());
							klon.setSicherungsintervall(getSicherungsintervall());
							klon.setLoeschintervall(getLoeschintervall());
							klon.setNachforderungsintervall(getNachforderungsintervall());
							klon.setKapazitaetscheck(getKapazitaetscheck());
							klon.setRestkapazitaet(getRestkapazitaet());
							klon.setLoeschschutzverlaengerung(getLoeschschutzverlaengerung());
							klon.setLoeschschutzverlaengerungMax(getLoeschschutzverlaengerungMax());
							klon.setAnzahlBytes(getAnzahlBytes());
							klon.setAnzahlBlocks(getAnzahlBlocks());
							klon.setAnzahlHohePrioritaet(getAnzahlHohePrioritaet());
							klon.setAnzahlMittlerePrioritaet(getAnzahlMittlerePrioritaet());
							klon.setAnzahlNiedrigePrioritaet(getAnzahlNiedrigePrioritaet());
							klon.setZeitSpanneNeuerSteuerbefehlNachKeineQuelle(getZeitSpanneNeuerSteuerbefehlNachKeineQuelle());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.archivEinstellung";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdArchivEinstellung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
